/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Collection;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationMarshaler;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.SerializedGBeanState;

public class SerializedConfigurationMarshaler
implements ConfigurationMarshaler {
    private static byte[] SERIALIZED_MAGIC = new byte[]{-84, -19};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationData readConfigurationData(InputStream in) throws IOException, ClassNotFoundException {
        byte[] streamHeader;
        PushbackInputStream pushbackInputStream;
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        if ((pushbackInputStream = new PushbackInputStream(in, 2)).read(streamHeader = new byte[2]) != 2) {
            throw new AssertionError((Object)"Cound not read stream header");
        }
        pushbackInputStream.unread(streamHeader);
        if (SERIALIZED_MAGIC[0] != streamHeader[0] || SERIALIZED_MAGIC[1] != streamHeader[1]) {
            ConfigurationMarshaler marshaler;
            try {
                marshaler = ConfigurationUtil.createConfigurationMarshaler("org.apache.geronimo.kernel.config.xstream.XStreamConfigurationMarshaler");
            }
            catch (Throwable ignored) {
                throw (IOException)new IOException("Input does not contain a Java Object Serialization stream").initCause(ignored);
            }
            return marshaler.readConfigurationData(pushbackInputStream);
        }
        ObjectInputStream oin = new ObjectInputStream(pushbackInputStream);
        try {
            ConfigurationData configurationData = (ConfigurationData)oin.readObject();
            return configurationData;
        }
        finally {
            oin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeConfigurationData(ConfigurationData configurationData, OutputStream out) throws IOException {
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out);
        }
        ObjectOutputStream oout = new ObjectOutputStream(out);
        try {
            oout.writeObject(configurationData);
        }
        finally {
            if (oout != null) {
                try {
                    oout.flush();
                }
                catch (IOException ignored) {}
            }
        }
    }

    @Override
    public GBeanState newGBeanState(Collection gbeans) {
        return new SerializedGBeanState(gbeans);
    }
}

