/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.Kernel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GBeanInfoBuilder {
    public static final String DEFAULT_J2EE_TYPE = "GBean";
    private static final Class[] NO_ARGS = new Class[0];
    private final String sourceClass;
    private final String name;
    private final String j2eeType;
    private final Class gbeanType;
    private final Map<String, GAttributeInfo> attributes = new HashMap<String, GAttributeInfo>();
    private GConstructorInfo constructor = new GConstructorInfo();
    private final Map<GOperationSignature, GOperationInfo> operations = new HashMap<GOperationSignature, GOperationInfo>();
    private final Map references = new HashMap();
    private final Set interfaces = new HashSet();
    private int priority = 5;
    private boolean osgiService;
    private Set<String> serviceInterfaces = new HashSet<String>();

    public static GBeanInfoBuilder createStatic(Class gbeanType) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, gbeanType.getName(), gbeanType, null, null);
    }

    public static GBeanInfoBuilder createStatic(Class gbeanType, String j2eeType) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, gbeanType.getName(), gbeanType, null, j2eeType);
    }

    public static GBeanInfoBuilder createStatic(String name, Class gbeanType) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, name, gbeanType, null, null);
    }

    public static GBeanInfoBuilder createStatic(String name, Class gbeanType, String j2eeType) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, name, gbeanType, null, j2eeType);
    }

    public static GBeanInfoBuilder createStatic(Class gbeanType, GBeanInfo source) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, gbeanType.getName(), gbeanType, source, null);
    }

    public static GBeanInfoBuilder createStatic(Class gbeanType, GBeanInfo source, String j2eeType) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, gbeanType.getName(), gbeanType, source, j2eeType);
    }

    public static GBeanInfoBuilder createStatic(String name, Class gbeanType, GBeanInfo source) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(gbeanType, name, gbeanType, source, null);
    }

    public static GBeanInfoBuilder createStatic(Class sourceClass, Class gbeanType) {
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(sourceClass, gbeanType.getName(), gbeanType, null, null);
    }

    public static GBeanInfoBuilder createStatic(Class sourceClass, Class gbeanType, String j2eeType) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass is null");
        }
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(sourceClass, gbeanType.getName(), gbeanType, null, j2eeType);
    }

    public static GBeanInfoBuilder createStatic(Class sourceClass, Class gbeanType, GBeanInfo source, String j2eeType) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass is null");
        }
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(sourceClass, gbeanType.getName(), gbeanType, source, j2eeType);
    }

    public static GBeanInfoBuilder createStatic(Class sourceClass, String name, Class gbeanType, String j2eeType) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return GBeanInfoBuilder.createStatic(sourceClass, name, gbeanType, null, j2eeType);
    }

    public static GBeanInfoBuilder createStatic(Class sourceClass, String name, Class gbeanType, GBeanInfo source, String j2eeType) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanType == null) {
            throw new NullPointerException("gbeanType is null");
        }
        return new GBeanInfoBuilder(sourceClass.getName(), name, gbeanType, source, j2eeType);
    }

    public GBeanInfoBuilder(Class gbeanType) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, null, null);
    }

    public GBeanInfoBuilder(Class gbeanType, String j2eeType) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, null, j2eeType);
    }

    public GBeanInfoBuilder(String name, Class gbeanType) {
        this(name, GBeanInfoBuilder.checkNotNull(gbeanType), null, null);
    }

    public GBeanInfoBuilder(String name, Class gbeanType, String j2eeType) {
        this(name, GBeanInfoBuilder.checkNotNull(gbeanType), null, j2eeType);
    }

    public GBeanInfoBuilder(Class gbeanType, GBeanInfo source) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, source);
    }

    public GBeanInfoBuilder(Class gbeanType, GBeanInfo source, String j2eeType) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, source, j2eeType);
    }

    public GBeanInfoBuilder(String name, Class gbeanType, GBeanInfo source) {
        this(name, gbeanType, source, null);
    }

    public GBeanInfoBuilder(String name, Class gbeanType, GBeanInfo source, String j2eeType) {
        this(null, name, gbeanType, source, j2eeType);
    }

    private GBeanInfoBuilder(String sourceClass, String name, Class gbeanType, GBeanInfo source, String j2eeType) {
        GBeanInfoBuilder.checkNotNull(name);
        GBeanInfoBuilder.checkNotNull(gbeanType);
        this.name = name;
        this.gbeanType = gbeanType;
        this.sourceClass = sourceClass;
        if (source != null) {
            for (GAttributeInfo attributeInfo : source.getAttributes()) {
                this.attributes.put(attributeInfo.getName(), attributeInfo);
            }
            for (GOperationInfo operationInfo : source.getOperations()) {
                this.operations.put(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()), operationInfo);
            }
            for (GReferenceInfo referenceInfo : source.getReferences()) {
                this.references.put(referenceInfo.getName(), new RefInfo(referenceInfo.getReferenceType(), referenceInfo.getNameTypeName()));
            }
            for (String intf : source.getInterfaces()) {
                this.interfaces.add(intf);
            }
            this.constructor = source.getConstructor();
            this.priority = source.getPriority();
            this.osgiService = source.isOsgiService();
            if (source.getServiceInterfaces() != null && source.getServiceInterfaces().length > 0) {
                this.serviceInterfaces.addAll(Arrays.asList(source.getServiceInterfaces()));
            }
        }
        this.j2eeType = j2eeType != null ? j2eeType : (source != null ? source.getJ2eeType() : DEFAULT_J2EE_TYPE);
        if (gbeanType.isArray()) {
            throw new IllegalArgumentException("GBean is an array type: gbeanType=" + gbeanType.getName());
        }
        Set<Class> allTypes = ClassLoading.getAllTypes(gbeanType);
        for (Class type : allTypes) {
            this.addInterface(type);
        }
    }

    public void setPersistentAttributes(String[] persistentAttributes) {
        for (int i = 0; i < persistentAttributes.length; ++i) {
            String attributeName = persistentAttributes[i];
            GAttributeInfo attribute = this.attributes.get(attributeName);
            if (attribute != null && !this.references.containsKey(attributeName)) {
                if (this.isMagicAttribute(attribute)) continue;
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, attribute.getType(), true, attribute.isManageable(), attribute.getEncryptedSetting(), attribute.getGetterName(), attribute.getSetterName()));
                continue;
            }
            if (attributeName.equals("kernel")) {
                this.addAttribute("kernel", Kernel.class, false);
                continue;
            }
            if (attributeName.equals("classLoader")) {
                this.addAttribute("classLoader", ClassLoader.class, false);
                continue;
            }
            if (attributeName.equals("bundle")) {
                this.addAttribute("bundle", Bundle.class, false);
                continue;
            }
            if (attributeName.equals("bundleContext")) {
                this.addAttribute("bundleContext", BundleContext.class, false);
                continue;
            }
            if (attributeName.equals("abstractName")) {
                this.addAttribute("abstractName", AbstractName.class, false);
                continue;
            }
            if (!attributeName.equals("objectName")) continue;
            this.addAttribute("objectName", String.class, false);
        }
    }

    public void setManageableAttributes(String[] manageableAttributes) {
        for (int i = 0; i < manageableAttributes.length; ++i) {
            String attributeName = manageableAttributes[i];
            GAttributeInfo attribute = this.attributes.get(attributeName);
            if (attribute == null) continue;
            this.attributes.put(attributeName, new GAttributeInfo(attributeName, attribute.getType(), attribute.isPersistent(), true, attribute.getEncryptedSetting(), attribute.getGetterName(), attribute.getSetterName()));
        }
    }

    private boolean isMagicAttribute(GAttributeInfo attributeInfo) {
        String name = attributeInfo.getName();
        String type = attributeInfo.getType();
        return "kernel".equals(name) && Kernel.class.getName().equals(type) || "classLoader".equals(name) && ClassLoader.class.getName().equals(type) || "bundle".equals(name) && Bundle.class.getName().equals(type) || "bundleContext".equals(name) && BundleContext.class.getName().equals(type) || "abstractName".equals(name) && AbstractName.class.getName().equals(type) || "objectName".equals(name) && String.class.getName().equals(type);
    }

    public void addInterface(Class intf) {
        this.addInterface(intf, new String[0]);
    }

    public void addInterface(Class intf, String[] persistentAttributes) {
        this.addInterface(intf, persistentAttributes, new String[0]);
    }

    public void addInterface(Class intf, String[] persistentAttributes, String[] manageableAttributes) {
        HashSet<String> persistentNames = new HashSet<String>(Arrays.asList(persistentAttributes));
        HashSet<String> manageableNames = new HashSet<String>(Arrays.asList(manageableAttributes));
        Method[] methods = new Method[]{};
        try {
            methods = intf.getMethods();
        }
        catch (NoClassDefFoundError e) {
            throw (NoClassDefFoundError)new NoClassDefFoundError("could not get methods from interface: " + intf.getName() + " due to: " + e.getMessage() + " loaded in classLoader: " + intf.getClassLoader()).initCause(e);
        }
        for (int i = 0; i < methods.length; ++i) {
            String attributeName;
            Method method = methods[i];
            if ("java.lang.Object".equals(method.getDeclaringClass().getName())) continue;
            if (GBeanInfoBuilder.isGetter(method)) {
                attributeName = this.getAttributeName(method);
                GAttributeInfo attribute = this.attributes.get(attributeName);
                String attributeType = method.getReturnType().getName();
                if (attribute == null) {
                    this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, persistentNames.contains(attributeName), manageableNames.contains(attributeName), method.getName(), null));
                    continue;
                }
                if (!attributeType.equals(attribute.getType())) {
                    throw new IllegalArgumentException("Getter and setter type do not match: " + attributeName + " for gbeanType: " + this.gbeanType.getName());
                }
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, attribute.isPersistent() || persistentNames.contains(attributeName), attribute.isManageable() || manageableNames.contains(attributeName), attribute.getEncryptedSetting(), method.getName(), attribute.getSetterName()));
                continue;
            }
            if (this.isSetter(method)) {
                attributeName = this.getAttributeName(method);
                String attributeType = method.getParameterTypes()[0].getName();
                GAttributeInfo attribute = this.attributes.get(attributeName);
                if (attribute == null) {
                    this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, persistentNames.contains(attributeName), manageableNames.contains(attributeName), null, method.getName()));
                    continue;
                }
                if (!attributeType.equals(attribute.getType())) {
                    throw new IllegalArgumentException("Getter and setter type do not match: " + attributeName + " for gbeanType: " + this.gbeanType.getName());
                }
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, attribute.isPersistent() || persistentNames.contains(attributeName), attribute.isManageable() || manageableNames.contains(attributeName), attribute.getEncryptedSetting(), attribute.getGetterName(), method.getName()));
                continue;
            }
            this.addOperation(new GOperationInfo(method.getName(), method.getParameterTypes(), method.getReturnType().getName()));
        }
        GBeanInfoBuilder.addInterface(this.interfaces, intf);
    }

    private static void addInterface(Set set, Class intf) {
        String name = intf.getName();
        if (set.contains(name)) {
            return;
        }
        set.add(name);
        Class<?>[] cls = intf.getInterfaces();
        for (int i = 0; i < cls.length; ++i) {
            GBeanInfoBuilder.addInterface(set, cls[i]);
        }
    }

    public void addAttribute(String name, Class type, boolean persistent) {
        this.addAttribute(name, type.getName(), persistent, true);
    }

    public void addAttribute(String name, String type, boolean persistent) {
        this.addAttribute(name, type, persistent, true);
    }

    public void addAttribute(String name, Class type, boolean persistent, boolean manageable) {
        this.addAttribute(name, type.getName(), persistent, manageable);
    }

    public void addAttribute(String name, String type, boolean persistent, boolean manageable) {
        String getter = GBeanInfoBuilder.searchForGetter(name, type, this.gbeanType);
        String setter = GBeanInfoBuilder.searchForSetter(name, type, this.gbeanType);
        this.addAttribute(new GAttributeInfo(name, type, persistent, manageable, getter, setter));
    }

    public void addAttribute(String name, Class type, boolean persistent, boolean manageable, boolean encrypted) {
        this.addAttribute(name, type.getName(), persistent, manageable, encrypted);
    }

    public void addAttribute(String name, String type, boolean persistent, boolean manageable, boolean encrypted) {
        String getter = GBeanInfoBuilder.searchForGetter(name, type, this.gbeanType);
        String setter = GBeanInfoBuilder.searchForSetter(name, type, this.gbeanType);
        this.addAttribute(new GAttributeInfo(name, type, persistent, manageable, encrypted, getter, setter));
    }

    public void addAttribute(GAttributeInfo info) {
        this.attributes.put(info.getName(), info);
    }

    public void setConstructor(GConstructorInfo constructor) {
        assert (constructor != null);
        this.constructor = constructor;
        List<String> names = constructor.getAttributeNames();
        this.setPersistentAttributes(names.toArray(new String[names.size()]));
    }

    public void setConstructor(String[] names) {
        this.constructor = new GConstructorInfo(names);
        this.setPersistentAttributes(names);
    }

    public void addOperation(GOperationInfo operationInfo) {
        this.operations.put(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()), operationInfo);
    }

    public void addOperation(String name) {
        this.addOperation(new GOperationInfo(name, NO_ARGS, ""));
    }

    public void addOperation(String name, Class[] paramTypes) {
    }

    public void addOperation(String name, String returnType) {
        this.addOperation(new GOperationInfo(name, NO_ARGS, returnType));
    }

    public void addOperation(String name, Class[] paramTypes, String returnType) {
        this.addOperation(new GOperationInfo(name, paramTypes, returnType));
    }

    public void addReference(GReferenceInfo info) {
        this.references.put(info.getName(), new RefInfo(info.getReferenceType(), info.getNameTypeName()));
    }

    public void addReference(String name, Class type, String namingType) {
        this.references.put(name, new RefInfo(type.getName(), namingType));
    }

    public void addReference(String name, Class type) {
        this.references.put(name, new RefInfo(type.getName(), null));
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setOsgiService(boolean osgiService) {
        this.osgiService = osgiService;
    }

    public Set<String> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public GBeanInfo getBeanInfo() {
        Map constructorTypes = this.getConstructorTypes();
        HashSet<GReferenceInfo> referenceInfos = new HashSet<GReferenceInfo>();
        Iterator i$ = this.references.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            String referenceName = (String)entry.getKey();
            RefInfo refInfo = (RefInfo)entry.getValue();
            String referenceType = refInfo.getJavaType();
            String namingType = refInfo.getNamingType();
            String proxyType = (String)constructorTypes.get(referenceName);
            String setterName = null;
            if (proxyType == null) {
                Method setter = GBeanInfoBuilder.searchForSetterMethod(referenceName, referenceType, this.gbeanType);
                if (setter == null && (setter = GBeanInfoBuilder.searchForSetterMethod(referenceName, Collection.class.getName(), this.gbeanType)) == null) {
                    throw new InvalidConfigurationException("Reference must be a constructor argument or have a setter: name=" + referenceName + " for gbeanType: " + this.gbeanType);
                }
                proxyType = setter.getParameterTypes()[0].getName();
                setterName = setter.getName();
            }
            if (!proxyType.equals(Collection.class.getName()) && !proxyType.equals(referenceType)) {
                throw new InvalidConfigurationException("Reference proxy type must be Collection or " + referenceType + ": name=" + referenceName + " for gbeanType: " + this.gbeanType.getName());
            }
            referenceInfos.add(new GReferenceInfo(referenceName, referenceType, proxyType, setterName, namingType));
        }
        return new GBeanInfo(this.sourceClass, this.name, this.gbeanType.getName(), this.j2eeType, this.attributes.values(), this.constructor, this.operations.values(), referenceInfos, this.interfaces, this.priority, this.osgiService, this.serviceInterfaces.toArray(new String[this.serviceInterfaces.size()]));
    }

    private Map getConstructorTypes() throws InvalidConfigurationException {
        Constructor constructor;
        List<String> arguments = this.constructor.getAttributeNames();
        String[] argumentTypes = new String[arguments.size()];
        boolean[] isReference = new boolean[arguments.size()];
        for (int i = 0; i < argumentTypes.length; ++i) {
            String argumentName = arguments.get(i);
            if (this.references.containsKey(argumentName)) {
                argumentTypes[i] = ((RefInfo)this.references.get(argumentName)).getJavaType();
                isReference[i] = true;
                continue;
            }
            if (!this.attributes.containsKey(argumentName)) continue;
            GAttributeInfo attribute = this.attributes.get(argumentName);
            argumentTypes[i] = attribute.getType();
            isReference[i] = false;
        }
        Constructor<?>[] constructors = this.gbeanType.getConstructors();
        HashSet<Constructor> validConstructors = new HashSet<Constructor>();
        for (int i = 0; i < constructors.length; ++i) {
            constructor = constructors[i];
            if (!GBeanInfoBuilder.isValidConstructor(constructor, argumentTypes, isReference)) continue;
            validConstructors.add(constructor);
        }
        if (validConstructors.isEmpty()) {
            throw new InvalidConfigurationException("Could not find a valid constructor for GBean: " + this.gbeanType.getName());
        }
        if (validConstructors.size() > 1) {
            throw new InvalidConfigurationException("More then one valid constructors found for GBean: " + this.gbeanType.getName());
        }
        HashMap<String, String> constructorTypes = new HashMap<String, String>();
        constructor = (Constructor)validConstructors.iterator().next();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Iterator<String> argumentIterator = arguments.iterator();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterType = parameterTypes[i].getName();
            String argumentName = argumentIterator.next();
            constructorTypes.put(argumentName, parameterType);
        }
        return constructorTypes;
    }

    private static String searchForGetter(String name, String type, Class gbeanType) throws InvalidConfigurationException {
        Method getterMethod = null;
        String getterName = "get" + name;
        String isName = "is" + name;
        Method[] methods = gbeanType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() == Void.TYPE || !getterName.equalsIgnoreCase(methods[i].getName()) && !isName.equalsIgnoreCase(methods[i].getName())) continue;
            getterMethod = methods[i];
            break;
        }
        if (getterMethod != null && !type.equals(getterMethod.getReturnType().getName())) {
            throw new InvalidConfigurationException("Incorrect return type for getter method: name=" + name + ", targetClass=" + gbeanType.getName() + ", getter type=" + getterMethod.getReturnType() + ", expected type=" + type);
        }
        if (getterMethod == null) {
            return null;
        }
        return getterMethod.getName();
    }

    private static String searchForSetter(String name, String type, Class gbeanType) throws InvalidConfigurationException {
        Method method = GBeanInfoBuilder.searchForSetterMethod(name, type, gbeanType);
        if (method == null) {
            return null;
        }
        return method.getName();
    }

    private static Method searchForSetterMethod(String name, String type, Class gbeanType) throws InvalidConfigurationException {
        String setterName = "set" + name;
        Method[] methods = gbeanType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals(type) || method.getReturnType() != Void.TYPE || !setterName.equalsIgnoreCase(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static boolean isValidConstructor(Constructor constructor, String[] argumentTypes, boolean[] isReference) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterType = parameterTypes[i].getName();
            if (!(isReference[i] ? !parameterType.equals(argumentTypes[i]) && !parameterType.equals(Collection.class.getName()) && !parameterType.equals(Set.class.getName()) : !parameterType.equals(argumentTypes[i]))) continue;
            return false;
        }
        return true;
    }

    private String getAttributeName(Method method) {
        String name = method.getName();
        String attributeName = name.startsWith("get") || name.startsWith("set") ? name.substring(3) : name.substring(2);
        attributeName = Introspector.decapitalize(attributeName);
        return attributeName;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1;
    }

    private static boolean isGetter(Method method) {
        String name = method.getName();
        return (name.startsWith("get") || name.startsWith("is")) && method.getParameterTypes().length == 0;
    }

    private static Class checkNotNull(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null argument supplied");
        }
        return clazz;
    }

    private static String checkNotNull(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null argument supplied");
        }
        return string;
    }

    private static Class loadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load class " + name, e);
        }
    }

    private static class RefInfo {
        private final String javaType;
        private final String namingType;

        public RefInfo(String javaType, String namingType) {
            this.javaType = javaType;
            this.namingType = namingType;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getNamingType() {
            return this.namingType;
        }
    }
}

