/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.geronimo.kernel.config.ManifestException;

public class Manifest
implements Serializable {
    private static final long serialVersionUID = -5817029148927697002L;
    public static final String ATTRIBUTE_MANIFEST_VERSION = "Manifest-Version";
    public static final String ATTRIBUTE_SIGNATURE_VERSION = "Signature-Version";
    public static final String ATTRIBUTE_NAME = "Name";
    public static final String ATTRIBUTE_FROM = "From";
    public static final String ATTRIBUTE_CLASSPATH = "Class-Path";
    public static final String DEFAULT_MANIFEST_VERSION = "1.0";
    public static final int MAX_LINE_LENGTH = 72;
    public static final int MAX_SECTION_LENGTH = 70;
    public static final String EOL = "\r\n";
    public static final String ERROR_FROM_FORBIDDEN = "Manifest attributes should not start with \"From\" in \"";
    public static final String JAR_ENCODING = "UTF-8";
    private String manifestVersion = "1.0";
    private Section mainSection = new Section();
    private LinkedHashMap<String, Section> sections = new LinkedHashMap();

    /*
     * Loose catch block
     */
    public static Manifest getDefaultManifest() throws ManifestException {
        InputStream in = null;
        InputStreamReader insr = null;
        String defManifest = "/org/apache/tools/ant/defaultManifest.mf";
        in = Manifest.class.getResourceAsStream(defManifest);
        if (in == null) {
            throw new ManifestException("Could not find default manifest: " + defManifest);
        }
        insr = new InputStreamReader(in, JAR_ENCODING);
        Manifest defaultManifest = new Manifest(insr);
        Attribute createdBy = new Attribute("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        defaultManifest.getMainSection().storeAttribute(createdBy);
        Manifest manifest = defaultManifest;
        Manifest.close(insr);
        Manifest.close(in);
        return manifest;
        {
            catch (UnsupportedEncodingException e) {
                Manifest manifest2;
                try {
                    insr = new InputStreamReader(in);
                    manifest2 = new Manifest(insr);
                }
                catch (IOException e2) {
                    try {
                        throw new ManifestException("Unable to read default manifest", e2);
                    }
                    catch (Throwable throwable) {
                        Manifest.close(insr);
                        Manifest.close(in);
                        throw throwable;
                    }
                }
                Manifest.close(insr);
                Manifest.close(in);
                return manifest2;
            }
        }
    }

    private static void close(InputStreamReader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Manifest() {
    }

    public Manifest(Reader r) throws ManifestException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(r);
        String nextSectionName = this.mainSection.read(reader);
        String readManifestVersion = this.mainSection.getAttributeValue(ATTRIBUTE_MANIFEST_VERSION);
        if (readManifestVersion != null) {
            this.manifestVersion = readManifestVersion;
            this.mainSection.removeAttribute(ATTRIBUTE_MANIFEST_VERSION);
        }
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            Section section = new Section();
            if (nextSectionName == null) {
                Attribute sectionName = new Attribute(line);
                if (!sectionName.getName().equalsIgnoreCase(ATTRIBUTE_NAME)) {
                    throw new ManifestException("Manifest sections should start with a \"Name\" attribute and not \"" + sectionName.getName() + "\"");
                }
                nextSectionName = sectionName.getValue();
            } else {
                Attribute firstAttribute = new Attribute(line);
                section.addAttributeAndCheck(firstAttribute);
            }
            section.setName(nextSectionName);
            nextSectionName = section.read(reader);
            this.addConfiguredSection(section);
        }
    }

    public void addConfiguredSection(Section section) throws ManifestException {
        String sectionName = section.getName();
        if (sectionName == null) {
            throw new ManifestException("Sections must have a name");
        }
        this.sections.put(sectionName, section);
    }

    public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
        if (attribute.getKey() == null || attribute.getValue() == null) {
            throw new ManifestException("Attributes must have name and value");
        }
        if (attribute.getKey().equalsIgnoreCase(ATTRIBUTE_MANIFEST_VERSION)) {
            this.manifestVersion = attribute.getValue();
        } else {
            this.mainSection.addConfiguredAttribute(attribute);
        }
    }

    public void merge(Manifest other) throws ManifestException {
        this.merge(other, false);
    }

    public void merge(Manifest other, boolean overwriteMain) throws ManifestException {
        if (other != null) {
            if (overwriteMain) {
                this.mainSection = (Section)other.mainSection.clone();
            } else {
                this.mainSection.merge(other.mainSection);
            }
            if (other.manifestVersion != null) {
                this.manifestVersion = other.manifestVersion;
            }
            for (Section otherSection : other.sections.values()) {
                String sectionName = otherSection.getName();
                Section ourSection = this.sections.get(sectionName);
                if (ourSection == null) {
                    this.addConfiguredSection((Section)otherSection.clone());
                    continue;
                }
                ourSection.merge(otherSection);
            }
        }
    }

    public void write(PrintWriter writer) throws IOException {
        writer.print("Manifest-Version: " + this.manifestVersion + EOL);
        String signatureVersion = this.mainSection.getAttributeValue(ATTRIBUTE_SIGNATURE_VERSION);
        if (signatureVersion != null) {
            writer.print("Signature-Version: " + signatureVersion + EOL);
            this.mainSection.removeAttribute(ATTRIBUTE_SIGNATURE_VERSION);
        }
        this.mainSection.write(writer);
        if (signatureVersion != null) {
            try {
                Attribute svAttr = new Attribute(ATTRIBUTE_SIGNATURE_VERSION, signatureVersion);
                this.mainSection.addConfiguredAttribute(svAttr);
            }
            catch (ManifestException e) {
                // empty catch block
            }
        }
        for (Section section : this.sections.values()) {
            section.write(writer);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(new PrintWriter(sw));
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    public List<String> getWarnings() {
        ArrayList<String> warnings = new ArrayList<String>(this.mainSection.getWarnings());
        for (Section section : this.sections.values()) {
            warnings.addAll(section.getWarnings());
        }
        return warnings;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.manifestVersion != null) {
            hashCode += this.manifestVersion.hashCode();
        }
        hashCode += this.mainSection.hashCode();
        return hashCode += this.sections.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null || rhs.getClass() != this.getClass()) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        Manifest rhsManifest = (Manifest)rhs;
        if (this.manifestVersion == null ? rhsManifest.manifestVersion != null : !this.manifestVersion.equals(rhsManifest.manifestVersion)) {
            return false;
        }
        if (!this.mainSection.equals(rhsManifest.mainSection)) {
            return false;
        }
        return this.sections.equals(rhsManifest.sections);
    }

    public String getManifestVersion() {
        return this.manifestVersion;
    }

    public Section getMainSection() {
        return this.mainSection;
    }

    public Section getSection(String name) {
        return this.sections.get(name);
    }

    public List<String> getSectionNames() {
        return new ArrayList<String>(this.sections.keySet());
    }

    public static class Section
    implements Serializable {
        private static final long serialVersionUID = -5947453150897530506L;
        private List<String> warnings = new ArrayList<String>();
        private String name = null;
        private LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String read(BufferedReader reader) throws ManifestException, IOException {
            String nameReadAhead;
            Attribute attribute = null;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null || line.length() == 0) {
                    return null;
                }
                if (line.charAt(0) == ' ') {
                    if (attribute == null) {
                        if (this.name != null) {
                            this.name = this.name + line.substring(1);
                            continue;
                        }
                        throw new ManifestException("Can't start an attribute with a continuation line " + line);
                    }
                    attribute.addContinuation(line);
                    continue;
                }
                attribute = new Attribute(line);
                nameReadAhead = this.addAttributeAndCheck(attribute);
                attribute = this.getAttribute(attribute.getKey());
                if (nameReadAhead != null) break;
            }
            return nameReadAhead;
        }

        public void merge(Section section) throws ManifestException {
            if (this.name == null && section.getName() != null || this.name != null && !this.name.equalsIgnoreCase(section.getName())) {
                throw new ManifestException("Unable to merge sections with different names");
            }
            Attribute classpathAttribute = null;
            for (String attributeName : section.getAttributeKeys()) {
                Attribute attribute = section.getAttribute(attributeName);
                if (attributeName.equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    if (classpathAttribute == null) {
                        classpathAttribute = new Attribute();
                        classpathAttribute.setName(Manifest.ATTRIBUTE_CLASSPATH);
                    }
                    for (String value : attribute.getValues()) {
                        classpathAttribute.addValue(value);
                    }
                    continue;
                }
                this.storeAttribute(attribute);
            }
            if (classpathAttribute != null) {
                this.storeAttribute(classpathAttribute);
            }
            this.warnings.addAll(section.warnings);
        }

        public void write(PrintWriter writer) throws IOException {
            if (this.name != null) {
                Attribute nameAttr = new Attribute(Manifest.ATTRIBUTE_NAME, this.name);
                nameAttr.write(writer);
            }
            for (String attributeName : this.getAttributeKeys()) {
                Attribute attribute = this.getAttribute(attributeName);
                attribute.write(writer);
            }
            writer.print(Manifest.EOL);
        }

        public Attribute getAttribute(String attributeName) {
            return this.attributes.get(attributeName.toLowerCase());
        }

        public List<String> getAttributeKeys() {
            return new ArrayList<String>(this.attributes.keySet());
        }

        public String getAttributeValue(String attributeName) {
            Attribute attribute = this.getAttribute(attributeName.toLowerCase());
            if (attribute == null) {
                return null;
            }
            return attribute.getValue();
        }

        public void removeAttribute(String attributeName) {
            String key = attributeName.toLowerCase();
            this.attributes.remove(key);
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            String check = this.addAttributeAndCheck(attribute);
            if (check != null) {
                throw new ManifestException("Specify the section name using the \"name\" attribute of the <section> element rather than using a \"Name\" manifest attribute");
            }
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            if (attribute.getName() == null || attribute.getValue() == null) {
                throw new ManifestException("Attributes must have name and value");
            }
            if (attribute.getKey().equalsIgnoreCase(Manifest.ATTRIBUTE_NAME)) {
                this.warnings.add("\"Name\" attributes should not occur in the main section and must be the first element in all other sections: \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
                return attribute.getValue();
            }
            if (attribute.getKey().startsWith(Manifest.ATTRIBUTE_FROM.toLowerCase())) {
                this.warnings.add(Manifest.ERROR_FROM_FORBIDDEN + attribute.getName() + ": " + attribute.getValue() + "\"");
            } else {
                String attributeKey = attribute.getKey();
                if (attributeKey.equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    Attribute classpathAttribute = this.attributes.get(attributeKey);
                    if (classpathAttribute == null) {
                        this.storeAttribute(attribute);
                    } else {
                        this.warnings.add("Multiple Class-Path attributes are supported but violate the Jar specification and may not be correctly processed in all environments");
                        for (String value : attribute.getValues()) {
                            classpathAttribute.addValue(value);
                        }
                    }
                } else {
                    if (this.attributes.containsKey(attributeKey)) {
                        throw new ManifestException("The attribute \"" + attribute.getName() + "\" may not occur more " + "than once in the same section");
                    }
                    this.storeAttribute(attribute);
                }
            }
            return null;
        }

        public Object clone() {
            Section cloned = new Section();
            cloned.setName(this.name);
            for (String attributeName : this.getAttributeKeys()) {
                Attribute attribute = this.getAttribute(attributeName);
                cloned.storeAttribute(new Attribute(attribute.getName(), attribute.getValue()));
            }
            return cloned;
        }

        private void storeAttribute(Attribute attribute) {
            if (attribute == null) {
                return;
            }
            String attributeKey = attribute.getKey();
            this.attributes.put(attributeKey, attribute);
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        public int hashCode() {
            return this.attributes.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Section rhsSection = (Section)rhs;
            return this.attributes.equals(rhsSection.attributes);
        }
    }

    public static class Attribute
    implements Serializable {
        private static final long serialVersionUID = 4262047715108012993L;
        private static final int MAX_NAME_VALUE_LENGTH = 68;
        private static final int MAX_NAME_LENGTH = 70;
        private final Separator separator;
        private String name = null;
        private List<String> values = new ArrayList<String>();
        private int currentIndex = 0;

        public Attribute() {
            this.separator = Separator.SPACE;
        }

        public Attribute(Separator separator) {
            this.separator = separator;
        }

        public Attribute(String line) throws ManifestException {
            this.separator = Separator.SPACE;
            this.parse(line);
        }

        public Attribute(String name, String value) {
            this.separator = Separator.SPACE;
            this.name = name;
            this.setValue(value);
        }

        public Attribute(Separator separator, String name, String value) {
            this.separator = separator;
            this.name = name;
            this.setValue(value);
        }

        public Attribute(Separator separator, String name, Collection<String> values) {
            this.separator = separator;
            this.name = name;
            if (values != null) {
                this.values.addAll(values);
                this.currentIndex = this.values.size() - 1;
            }
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.name != null) {
                hashCode += this.getKey().hashCode();
            }
            return hashCode += ((Object)this.values).hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Attribute rhsAttribute = (Attribute)rhs;
            String lhsKey = this.getKey();
            String rhsKey = rhsAttribute.getKey();
            if (lhsKey == null && rhsKey != null || lhsKey != null && !lhsKey.equals(rhsKey)) {
                return false;
            }
            return ((Object)this.values).equals(rhsAttribute.values);
        }

        public void parse(String line) throws ManifestException {
            int index = line.indexOf(": ");
            if (index == -1) {
                throw new ManifestException("Manifest line \"" + line + "\" is not valid as it does not " + "contain a name and a value separated by ': ' ");
            }
            this.name = line.substring(0, index);
            this.setValue(line.substring(index + 2));
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            if (this.name == null) {
                return null;
            }
            return this.name.toLowerCase();
        }

        public void setValue(String value) {
            if (this.currentIndex >= this.values.size()) {
                this.values.add(value);
                this.currentIndex = this.values.size() - 1;
            } else {
                this.values.set(this.currentIndex, value);
            }
        }

        public String getValue() {
            if (this.values.size() == 0) {
                return null;
            }
            StringBuilder fullValue = new StringBuilder();
            for (String value : this.values) {
                fullValue.append(value).append(this.separator.getSeparator());
            }
            return fullValue.substring(0, fullValue.length() - 1);
        }

        public void addValue(String value) {
            ++this.currentIndex;
            this.setValue(value);
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public void addContinuation(String line) {
            String currentValue = this.values.get(this.currentIndex);
            this.setValue(currentValue + line.substring(1));
        }

        public void write(PrintWriter writer) throws IOException {
            this.writeValue(writer, this.getValue());
        }

        private void writeValue(PrintWriter writer, String value) throws IOException {
            String line;
            int nameLength = this.name.getBytes(Manifest.JAR_ENCODING).length;
            if (nameLength > 68) {
                if (nameLength > 70) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + value);
                }
                writer.print(this.name + ": " + Manifest.EOL);
                line = " " + value;
            } else {
                line = this.name + ": " + value;
            }
            while (line.getBytes(Manifest.JAR_ENCODING).length > 70) {
                int breakIndex = 70;
                if (breakIndex >= line.length()) {
                    breakIndex = line.length() - 1;
                }
                String section = line.substring(0, breakIndex);
                while (section.getBytes(Manifest.JAR_ENCODING).length > 70 && breakIndex > 0) {
                    section = line.substring(0, --breakIndex);
                }
                if (breakIndex == 0) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + value);
                }
                writer.print(section + Manifest.EOL);
                line = " " + line.substring(breakIndex);
            }
            writer.print(line + Manifest.EOL);
        }

        public static enum Separator {
            SPACE(" "),
            COMMA(",");

            private final String separator;

            private Separator(String separator) {
                this.separator = separator;
            }

            String getSeparator() {
                return this.separator;
            }
        }
    }
}

