/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class DelegatingClassLoader
extends ClassLoader {
    private Set<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();

    public void addLoader(ClassLoader loader) {
        this.loaders.add(loader);
    }

    public void addLoader(Class<?> clazz) {
        this.loaders.add(clazz.getClassLoader());
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (ClassLoader loader : this.loaders) {
            Enumeration<URL> e = loader.getResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }
}

