/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GBeanDependency {
    private static final Logger log = LoggerFactory.getLogger(GBeanDependency.class);
    private final GBeanInstance gbeanInstance;
    private final AbstractName targetName;
    private final LifecycleListener listener;
    private final Kernel kernel;
    private boolean targetRunning = false;
    private boolean dependencyRegistered = false;

    public GBeanDependency(GBeanInstance gbeanInstance, AbstractName targetName, Kernel kernel) throws InvalidConfigurationException {
        this.gbeanInstance = gbeanInstance;
        this.kernel = kernel;
        this.targetName = targetName;
        this.listener = this.createLifecycleListener();
    }

    public AbstractName getTargetName() {
        return this.targetName;
    }

    public final synchronized void online() {
        AbstractNameQuery query = new AbstractNameQuery(this.targetName, null);
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, query);
        this.targetRunning = this.isRunning(this.kernel, this.targetName);
    }

    public synchronized boolean start() {
        if (this.targetRunning && !this.dependencyRegistered) {
            AbstractName abstractName = this.gbeanInstance.getAbstractName();
            this.kernel.getDependencyManager().addDependency(abstractName, this.targetName);
            this.dependencyRegistered = true;
        }
        return this.targetRunning;
    }

    public synchronized void stop() {
        if (this.dependencyRegistered) {
            AbstractName abstractName = this.gbeanInstance.getAbstractName();
            this.kernel.getDependencyManager().removeDependency(abstractName, this.targetName);
            this.dependencyRegistered = false;
        }
    }

    public final synchronized void offline() {
        this.stop();
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        this.targetRunning = false;
    }

    private synchronized void attemptFullStart() {
        try {
            this.gbeanInstance.start();
        }
        catch (Exception e) {
            log.warn("Exception occured while attempting to fully start: objectName=" + this.gbeanInstance.getObjectName(), (Throwable)e);
        }
    }

    protected LifecycleListener createLifecycleListener() {
        return new LifecycleAdapter(){

            @Override
            public void running(AbstractName abstractName) {
                GBeanDependency.this.addTarget(abstractName);
            }

            @Override
            public void stopped(AbstractName abstractName) {
                GBeanDependency.this.removeTarget(abstractName);
            }

            @Override
            public void failed(AbstractName abstractName) {
                GBeanDependency.this.removeTarget(abstractName);
            }

            @Override
            public void unloaded(AbstractName abstractName) {
                GBeanDependency.this.removeTarget(abstractName);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addTarget(AbstractName abstractName) {
        GBeanDependency gBeanDependency = this;
        synchronized (gBeanDependency) {
            this.targetRunning = true;
            GBeanInstance gbeanInstance1 = this.gbeanInstance;
            if (gbeanInstance1.getStateInstance() == State.RUNNING) {
                log.error("Illegal state: two or more targets are running for a dependency: " + this.getDescription() + ",\n    newTarget=" + abstractName);
            }
            this.attemptFullStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeTarget(AbstractName abstractName) {
        GBeanDependency gBeanDependency = this;
        synchronized (gBeanDependency) {
            this.targetRunning = false;
            GBeanInstance gbeanInstance1 = this.gbeanInstance;
            if (gbeanInstance1.getStateInstance() == State.RUNNING) {
                log.error("Illegal state: current target for a single valued reference stopped: " + this.getDescription() + ",\n    stopped Target=" + abstractName);
                gbeanInstance1.referenceFailed();
            }
        }
    }

    private boolean isRunning(Kernel kernel, AbstractName objectName) {
        try {
            int state = kernel.getGBeanState(objectName);
            return state == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final String getDescription() {
        return "\n    GBeanInstance: " + this.gbeanInstance.getName() + "\n    Target Name: " + this.targetName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GBeanDependency that = (GBeanDependency)o;
        if (this.gbeanInstance != null ? !this.gbeanInstance.equals(that.gbeanInstance) : that.gbeanInstance != null) {
            return false;
        }
        return !(this.targetName == null ? that.targetName != null : !this.targetName.equals(that.targetName));
    }

    public int hashCode() {
        int result = this.gbeanInstance != null ? this.gbeanInstance.hashCode() : 0;
        result = 29 * result + (this.targetName != null ? this.targetName.hashCode() : 0);
        return result;
    }
}

