/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.osgi;

import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class KernelActivator
implements BundleActivator {
    private ServiceRegistration kernelRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(BundleContext bundleContext) throws Exception {
        Kernel kernel = KernelFactory.newInstance(bundleContext).createKernel("geronimo");
        kernel.boot();
        Dictionary dictionary = null;
        this.kernelRegistration = bundleContext.registerService(Kernel.class.getName(), (Object)kernel, dictionary);
        Bundle bundle = bundleContext.getBundle();
        URL plan = bundle.getEntry("META-INF/config.ser");
        InputStream in = plan.openStream();
        try {
            ConfigurationData data = ConfigurationUtil.readConfigurationData(in);
            data.setBundleContext(bundleContext);
            AbstractName name = ConfigurationUtil.loadBootstrapConfiguration(kernel, data, bundleContext, false);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        Kernel kernel = (Kernel)bundleContext.getService(this.kernelRegistration.getReference());
        kernel.shutdown();
        this.kernelRegistration.unregister();
        this.kernelRegistration = null;
    }
}

