/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.osgi;

import java.io.InputStream;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConfigurationActivator
implements BundleActivator {
    private Artifact id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(BundleContext bundleContext) throws Exception {
        ServiceReference kernelReference = null;
        InputStream in = null;
        try {
            kernelReference = bundleContext.getServiceReference(Kernel.class.getName());
            if (kernelReference == null) {
                return;
            }
            Kernel kernel = (Kernel)bundleContext.getService(kernelReference);
            ConfigurationManager manager = ConfigurationUtil.getConfigurationManager(kernel);
            Bundle bundle = bundleContext.getBundle();
            in = bundle.getEntry("META-INF/config.ser").openStream();
            ConfigurationData data = ConfigurationUtil.readConfigurationData(in);
            data.setBundleContext(bundleContext);
            manager.loadConfiguration(data);
            this.id = data.getId();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (kernelReference != null) {
                try {
                    bundleContext.ungetService(kernelReference);
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        ServiceReference kernelReference = null;
        try {
            kernelReference = bundleContext.getServiceReference(Kernel.class.getName());
            if (kernelReference == null) {
                return;
            }
            Kernel kernel = (Kernel)bundleContext.getService(kernelReference);
            AbstractName name = Configuration.getConfigurationAbstractName(this.id);
            try {
                kernel.stopGBean(name);
            }
            catch (GBeanNotFoundException e) {
            }
            catch (InternalKernelException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                kernel.unloadGBean(name);
            }
            catch (GBeanNotFoundException e) {
            }
            catch (InternalKernelException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        finally {
            if (kernelReference != null) {
                try {
                    bundleContext.ungetService(kernelReference);
                }
                catch (Exception e) {}
            }
        }
    }
}

