/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.rmi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class RMIClassLoaderSpiImpl
extends RMIClassLoaderSpi {
    private RMIClassLoaderSpi delegate = RMIClassLoader.getDefaultProviderInstance();
    private ConcurrentHashMap cachedCodebases = new ConcurrentHashMap(100);

    public Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        if (codebase != null) {
            codebase = this.getNormalizedCodebase(codebase);
        }
        return this.delegate.loadClass(codebase, name, defaultLoader);
    }

    public Class loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        if (codebase != null) {
            codebase = this.getNormalizedCodebase(codebase);
        }
        return this.delegate.loadProxyClass(codebase, interfaces, defaultLoader);
    }

    @Override
    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        if (codebase != null) {
            codebase = this.getNormalizedCodebase(codebase);
        }
        return this.delegate.getClassLoader(codebase);
    }

    public String getClassAnnotation(Class type) {
        ClassLoader obj = type.getClassLoader();
        if (obj instanceof ClassLoaderServerAware) {
            ClassLoaderServerAware classLoader = (ClassLoaderServerAware)((Object)obj);
            URL[] urls = classLoader.getClassLoaderServerURLs();
            if (null == urls) {
                return this.delegate.getClassAnnotation(type);
            }
            StringBuffer codebase = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                URL url = RMIClassLoaderSpiImpl.normalizeURL(urls[i]);
                if (codebase.length() != 0) {
                    codebase.append(' ');
                }
                codebase.append(url);
            }
            return codebase.toString();
        }
        String codebase = this.delegate.getClassAnnotation(type);
        if (codebase != null) {
            try {
                codebase = this.getNormalizedCodebase(codebase);
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        return codebase;
    }

    private String getNormalizedCodebase(String codebase) throws MalformedURLException {
        String cachedCodebase = (String)this.cachedCodebases.get(codebase);
        if (cachedCodebase != null) {
            return cachedCodebase;
        }
        String normalizedCodebase = RMIClassLoaderSpiImpl.normalizeCodebase(codebase);
        String oldValue = this.cachedCodebases.put(codebase, normalizedCodebase);
        if (oldValue != null) {
            this.cachedCodebases.remove(codebase);
        }
        return normalizedCodebase;
    }

    static String normalizeCodebase(String input) throws MalformedURLException {
        assert (input != null);
        StringBuffer codebase = new StringBuffer();
        StringBuffer working = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(input, " \t\n\r\f", true);
        while (stok.hasMoreTokens()) {
            String item = stok.nextToken();
            if (item.indexOf(58) != -1) {
                try {
                    URL url = new URL(item);
                    RMIClassLoaderSpiImpl.updateCodebase(working, codebase);
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
            working.append(item);
        }
        RMIClassLoaderSpiImpl.updateCodebase(working, codebase);
        return codebase.toString();
    }

    private static void updateCodebase(StringBuffer working, StringBuffer codebase) throws MalformedURLException {
        if (working.length() != 0) {
            URL url = RMIClassLoaderSpiImpl.normalizeURL(new URL(working.toString()));
            if (codebase.length() != 0) {
                codebase.append(" ");
            }
            codebase.append(url);
            working.setLength(0);
        }
    }

    static URL normalizeURL(URL url) {
        assert (url != null);
        if (url.getProtocol().equals("file")) {
            String filename = url.getFile().replace('/', File.separatorChar);
            File file = new File(filename);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static interface ClassLoaderServerAware {
        public URL[] getClassLoaderServerURLs();
    }
}

