/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.CopyArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.kernel.util.InputUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository
implements WriteableRepository {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ArtifactTypeHandler DEFAULT_TYPE_HANDLER = new CopyArtifactTypeHandler();
    private static final Pattern ILLEGAL_CHARS = Pattern.compile("[\\.]{2}|[()<>,;:\\\\/\"']");
    protected final File rootFile;
    private final Map<String, ArtifactTypeHandler> typeHandlers = new HashMap<String, ArtifactTypeHandler>();

    public AbstractRepository(File rootFile) {
        if (rootFile == null) {
            throw new NullPointerException("root is null");
        }
        if (!(rootFile.exists() && rootFile.isDirectory() && rootFile.canRead())) {
            throw new IllegalStateException("Maven2Repository must have a root that's a valid readable directory (not " + rootFile.getAbsolutePath() + ")");
        }
        this.rootFile = rootFile;
        this.log.debug("Repository root is {}", (Object)rootFile.getAbsolutePath());
    }

    @Override
    public boolean contains(Artifact artifact) {
        File location = this.getLocation(artifact);
        return location.canRead() && (location.isFile() || new File(location, "META-INF").isDirectory());
    }

    public void setTypeHandler(String type, ArtifactTypeHandler handler) {
        this.typeHandlers.put(type, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyToRepository(File source, Artifact destination, FileWriteMonitor monitor) throws IOException {
        InputUtils.validateSafeInput(new ArrayList<String>(Arrays.asList(destination.getGroupId(), destination.getArtifactId(), destination.getVersion().toString(), destination.getType())));
        if (!destination.isResolved()) {
            throw new IllegalArgumentException("Artifact " + destination + " is not fully resolved");
        }
        if (!source.exists() || !source.canRead() || source.isDirectory()) {
            throw new IllegalArgumentException("Cannot read source file at " + source.getAbsolutePath());
        }
        int size = 0;
        ZipFile zip = null;
        try {
            zip = new ZipFile(source);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                size = (int)((long)size + entry.getSize());
            }
        }
        catch (ZipException ze) {
            size = (int)source.length();
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        FileInputStream is = new FileInputStream(source);
        try {
            this.copyToRepository(is, size, destination, monitor);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    public void copyToRepository(InputStream source, int size, Artifact destination, FileWriteMonitor monitor) throws IOException {
        if (!destination.isResolved()) {
            throw new IllegalArgumentException("Artifact " + destination + " is not fully resolved");
        }
        if (!this.rootFile.canWrite()) {
            throw new IllegalStateException("This repository is not writable: " + this.rootFile.getAbsolutePath() + ")");
        }
        File location = this.getLocation(destination);
        if (location.exists()) {
            throw new IllegalArgumentException("Destination " + location.getAbsolutePath() + " already exists!");
        }
        ArtifactTypeHandler typeHandler = this.typeHandlers.get(destination.getType());
        if (typeHandler == null) {
            typeHandler = DEFAULT_TYPE_HANDLER;
        }
        typeHandler.install(source, size, destination, monitor, location);
        if (destination.getType().equalsIgnoreCase("car")) {
            this.log.debug("Installed module configuration; id={}; location={}", (Object)destination, (Object)location);
        }
    }
}

