/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.crypto.encoders.Base64;
import org.apache.geronimo.deployment.plugin.remote.FileUploadClient;
import org.apache.geronimo.deployment.plugin.remote.FileUploadProgress;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadServletClient
implements FileUploadClient {
    private static final Logger log = LoggerFactory.getLogger(FileUploadServletClient.class);
    public static final int REMOTE_DEPLOY_REQUEST_VER_0 = 0;
    public static final int REMOTE_DEPLOY_RESPONSE_VER_0 = 0;
    public static final int REMOTE_DEPLOY_REQUEST_VER = 0;
    public static final int REMOTE_DEPLOY_RESPONSE_VER = 0;

    @Override
    public URL getRemoteDeployUploadURL(Kernel kernel) {
        AbstractName deployerName = this.getDeployerName(kernel);
        try {
            String remoteDeployUpload = (String)kernel.getAttribute(deployerName, "remoteDeployUploadURL");
            return new URL(remoteDeployUpload);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    protected AbstractName getDeployerName(Kernel kernel) {
        Set<AbstractName> deployerNames = kernel.listGBeans(new AbstractNameQuery("org.apache.geronimo.deployment.Deployer"));
        if (1 != deployerNames.size()) {
            throw new IllegalStateException("No Deployer GBean present in running Geronimo server. This usually indicates a serious problem with the configuration of your running Geronimo server.  If the deployer is present but not started, the workaround is to run a deploy command like 'start geronimo/geronimo-gbean-deployer/1.0/car'.  If the deployer service is not present at all (it was undeployed) then you need to either re-install Geronimo or get a deployment plan for the runtime deployer and distribute it while the server is not running and then start the server with a command like the above.  For help on this, write to user@geronimo.apache.org and include the contents of your var/config/config.xml file.");
        }
        return deployerNames.iterator().next();
    }

    @Override
    public void uploadFilesToServer(URL uploadURL, String username, String password, File[] files, FileUploadProgress progress) {
        if (files == null) {
            return;
        }
        LinkedList<Integer> valid = new LinkedList<Integer>();
        for (int i = 0; i < files.length; ++i) {
            File file;
            if (files[i] == null || !(file = files[i]).exists() || !file.canRead()) continue;
            valid.add(new Integer(i));
        }
        if (valid.size() > 0) {
            progress.updateStatus("Uploading " + valid.size() + " file(s) to server");
            if (log.isDebugEnabled()) {
                log.debug("Uploading " + valid.size() + " file(s) to server");
            }
            try {
                URLConnection con = this.connectToServer(uploadURL, username, password);
                this.writeRequest(con, files, valid, progress);
                this.readResponse(con, files, valid, progress);
            }
            catch (Exception e) {
                progress.fail(e);
            }
        }
    }

    protected void readResponse(URLConnection con, File[] files, List valid, FileUploadProgress progress) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(con.getInputStream()));
        int rspVer = in.readInt();
        if (rspVer >= 0 && rspVer <= 0) {
            int count;
            String status = in.readUTF();
            if (!status.equals("OK")) {
                progress.fail("Unable to upload files to server.  Server returned status=" + status);
                log.error("Unable to upload files to server.  Server returned status=" + status);
                return;
            }
            progress.updateStatus("File upload complete (Server status=" + status + ")");
            if (log.isDebugEnabled()) {
                log.debug("File upload complete (Server status=" + status + ")");
            }
            if ((count = in.readInt()) != valid.size()) {
                progress.fail("Server only received " + count + " of " + valid.size() + " files");
                log.warn("Server only received " + count + " of " + valid.size() + " files");
            }
            for (Integer index : valid) {
                String serverFileName = in.readUTF();
                if (serverFileName != null) {
                    files[index.intValue()] = new File(serverFileName);
                } else {
                    log.error("Received an invalid filename from the server");
                    files[index.intValue()] = null;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Server created file=" + serverFileName);
            }
            if (rspVer > 0 && rspVer > 0) {
                log.warn("Received a newer server response (" + rspVer + ") than expected (" + 0 + ").  Ignoring any additional server response data.");
            }
        } else {
            progress.fail("Received unknown server response version=" + rspVer);
            log.warn("Received unknown server response version=" + rspVer);
        }
        in.close();
        progress.updateStatus("File(s) transferred to server.  Resuming deployment operation.");
    }

    protected void writeRequest(URLConnection con, File[] files, List valid, FileUploadProgress progress) throws IOException, FileNotFoundException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(con.getOutputStream()));
        out.writeInt(0);
        out.writeInt(valid.size());
        byte[] buf = new byte[1024];
        for (Integer index : valid) {
            int size;
            long threshold;
            File file = files[index];
            out.writeUTF(file.getName().trim());
            long length = file.length();
            out.writeLong(length);
            long next = threshold = Math.max(length / 100L, 10240L);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            if (log.isDebugEnabled()) {
                log.debug("Uploading " + file.getName());
            }
            long total = 0L;
            while ((size = in.read(buf)) > -1) {
                out.write(buf, 0, size);
                if ((total += (long)size) <= next) continue;
                progress.updateStatus("Uploading " + file.getName() + ": " + total / 1024L + " KB");
                while (total > next) {
                    next += threshold;
                }
            }
            in.close();
        }
        out.flush();
        out.close();
    }

    protected URLConnection connectToServer(URL url, String username, String password) throws IOException {
        URLConnection con = url.openConnection();
        String auth = username + ":" + password;
        byte[] data = auth.getBytes();
        String s = new String(Base64.encode((byte[])data));
        while (s.length() % 4 != 0) {
            s = s + "=";
        }
        con.setRequestProperty("Authorization", "Basic " + s);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        return con;
    }
}

