/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Enumeration;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.ExtendedDeploymentManager;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.deployment.plugin.local.DistributeCommand;
import org.apache.geronimo.deployment.plugin.local.RedeployCommand;
import org.apache.geronimo.deployment.plugin.remote.RemoteDeployUtil;
import org.apache.geronimo.deployment.spi.ModuleConfigurer;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.jmx.KernelDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDeploymentManager
extends ExtendedDeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(RemoteDeploymentManager.class);
    private JMXConnector jmxConnector;
    private boolean isSameMachine;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_MODULE_CONFIGURERS = "ModuleConfigurers";

    public RemoteDeploymentManager(Collection<ModuleConfigurer> moduleConfigurers) {
        super(moduleConfigurers);
    }

    public void init(JMXConnector jmxConnector, String hostname) throws IOException {
        this.jmxConnector = jmxConnector;
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        this.initialize(new KernelDelegate(mbServerConnection));
        this.checkSameMachine(hostname);
    }

    public JMXConnector getJMXConnector() {
        return this.jmxConnector;
    }

    public boolean isSameMachine() {
        return this.isSameMachine;
    }

    private void checkSameMachine(String hostname) {
        this.isSameMachine = false;
        if (hostname.equals("localhost") || hostname.equals("127.0.0.1")) {
            this.isSameMachine = true;
            return;
        }
        try {
            InetAddress dest = InetAddress.getByName(hostname);
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                Enumeration<InetAddress> ine = iface.getInetAddresses();
                while (ine.hasMoreElements()) {
                    InetAddress address = ine.nextElement();
                    if (!address.equals(dest)) continue;
                    this.isSameMachine = true;
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to look up host name '" + hostname + "'; assuming it is a different machine, but this may not get very far.", (Throwable)e);
        }
    }

    @Override
    public void release() {
        super.release();
        try {
            this.jmxConnector.close();
            this.jmxConnector = null;
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException("Unable to close connection").initCause(e);
        }
    }

    @Override
    protected <T> T getImplementation(AbstractName name, Class<T> clazz) {
        return this.kernel.getProxyManager().createProxy(name, clazz);
    }

    @Override
    protected DistributeCommand createDistributeCommand(Target[] targetList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    @Override
    protected DistributeCommand createDistributeCommand(Target[] targetList, ModuleType moduleType, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createDistributeCommand(targetList, moduleType, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.DistributeCommand(this.kernel, targetList, moduleType, moduleArchive, deploymentPlan);
    }

    @Override
    protected RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    @Override
    protected RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.isSameMachine) {
            return super.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        }
        return new org.apache.geronimo.deployment.plugin.remote.RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    @Override
    public Object startInstall(File carFile, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        File[] args = new File[]{carFile};
        if (!this.isSameMachine) {
            AbstractDeployCommand progress = new AbstractDeployCommand(CommandType.DISTRIBUTE, this.kernel, null, null, null, null, null, false){

                @Override
                public void run() {
                }
            };
            progress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    log.info(event.getDeploymentStatus().getMessage());
                }
            });
            progress.setCommandContext(this.commandContext);
            RemoteDeployUtil.uploadFilesToServer(args, progress);
        }
        return super.startInstall(args[0], defaultRepository, restrictToDefaultRepository, username, password);
    }

    @Override
    public Artifact installLibrary(File libFile, String groupId) throws IOException {
        File[] args = new File[]{libFile};
        if (!this.isSameMachine) {
            AbstractDeployCommand progress = new AbstractDeployCommand(CommandType.DISTRIBUTE, this.kernel, null, null, null, null, null, false){

                @Override
                public void run() {
                }
            };
            progress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    log.info(event.getDeploymentStatus().getMessage());
                }
            });
            progress.setCommandContext(this.commandContext);
            RemoteDeployUtil.uploadFilesToServer(args, progress);
        }
        return super.installLibrary(args[0], groupId);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(RemoteDeploymentManager.class, "RemoteDeploymentManager");
        infoFactory.addInterface(GeronimoDeploymentManager.class);
        infoFactory.addReference(GBEAN_REF_MODULE_CONFIGURERS, ModuleConfigurer.class);
        infoFactory.setConstructor(new String[]{GBEAN_REF_MODULE_CONFIGURERS});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

