/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common.propertyeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.propertyeditor.PropertiesEditor;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;

public class MapEditor
extends TextPropertyEditorSupport {
    private static final Log log = LogFactory.getLog(MapEditor.class);

    public void setAsText(String text) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(text == null ? new byte[]{} : text.getBytes());
            Properties p = new Properties();
            p.load(is);
            this.setValue(p);
        }
        catch (IOException e) {
            throw new PropertyEditorException(e.getMessage(), e);
        }
    }

    public String getAsText() {
        Map map = (Map)this.getValue();
        if (!(map instanceof Properties)) {
            Properties p = new Properties();
            if (map != null) {
                if (!map.containsKey(null) && !map.containsValue(null)) {
                    p.putAll((Map<?, ?>)map);
                } else {
                    log.warn((Object)"Map contains null keys or values.  Replacing null values with empty string.");
                    for (Map.Entry entry : map.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key == null) {
                            key = "";
                        }
                        if (value == null) {
                            value = "";
                        }
                        p.put(key, value);
                    }
                }
                map = p;
            }
        }
        PropertiesEditor pe = new PropertiesEditor();
        pe.setValue(map);
        return pe.getAsText();
    }
}

