/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=1)
@Vetoed
public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    public static final LocalDateTimeConverter INSTANCE = new LocalDateTimeConverter();

    public LocalDateTime convert(String value) {
        if (value != null) {
            try {
                return LocalDateTime.parse(value);
            }
            catch (DateTimeParseException dtpe) {
                throw new IllegalArgumentException(dtpe);
            }
        }
        return null;
    }
}

