/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class UriUtils {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String decode(String encodedValue) {
        return UriUtils.decode((String)encodedValue, (String)"UTF-8");
    }

    public static String decode(String encodedValue, String encoding) {
        try {
            if (encodedValue != null) {
                String previousEncodedValue;
                do {
                    previousEncodedValue = encodedValue;
                } while (!(encodedValue = URLDecoder.decode(encodedValue, encoding)).equals(previousEncodedValue));
            }
            return encodedValue;
        }
        catch (UnsupportedEncodingException ignore) {
            return encodedValue;
        }
    }

    public static String[] decode(String[] encodedValues) {
        return UriUtils.decode((String[])encodedValues, (String)"UTF-8");
    }

    public static String[] decode(String[] encodedValues, String encoding) {
        if (encodedValues != null) {
            for (int index = 0; index < encodedValues.length; ++index) {
                encodedValues[index] = UriUtils.decode((String)encodedValues[index], (String)encoding);
            }
        }
        return encodedValues;
    }

    public static Map<String, Object> decode(Map<String, Object> form) {
        return UriUtils.decode(form, (String)"UTF-8");
    }

    public static Map<String, Object> decode(Map<String, Object> form, String encoding) {
        if (form != null) {
            for (String key : form.keySet()) {
                Object value = form.get(key);
                if (!(value instanceof String)) continue;
                form.put(key, UriUtils.decode((String)value.toString(), (String)encoding));
            }
        }
        return form;
    }

    public static String encode(String value) {
        return UriUtils.encode((String)value, (String)"UTF-8");
    }

    public static String encode(String value, String encoding) {
        try {
            return value != null ? URLEncoder.encode(value, encoding) : value;
        }
        catch (UnsupportedEncodingException ignore) {
            return value;
        }
    }

    public static String[] encode(String[] values) {
        return UriUtils.encode((String[])values, (String)"UTF-8");
    }

    public static String[] encode(String[] values, String encoding) {
        if (values != null) {
            for (int index = 0; index < values.length; ++index) {
                values[index] = UriUtils.encode((String)values[index], (String)encoding);
            }
        }
        return values;
    }

    public static Map<String, Object> encode(Map<String, Object> form) {
        return UriUtils.encode(form, (String)"UTF-8");
    }

    public static Map<String, Object> encode(Map<String, Object> form, String encoding) {
        if (form != null) {
            for (String key : form.keySet()) {
                Object value = form.get(key);
                if (!(value instanceof String)) continue;
                form.put(key, UriUtils.encode((String)value.toString(), (String)encoding));
            }
        }
        return form;
    }
}

