/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Optional;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.operation.RestoreRedundancyRequest;
import org.apache.geode.management.runtime.RestoreRedundancyResults;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="restoreRedundancyOperation")
@RequestMapping(value={"/v1"})
public class RestoreRedundancyOperationController
extends AbstractManagementController {
    @Operation(summary="start restore-redundancy")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @PostMapping(value={"/operations/restoreRedundancy"})
    public ResponseEntity<ClusterManagementOperationResult<RestoreRedundancyRequest, RestoreRedundancyResults>> startRestoreRedundancy(@RequestBody RestoreRedundancyRequest operation) {
        operation.setOperator((String)Optional.ofNullable(this.securityService).map(SecurityService::getSubject).map(Object::toString).orElse(null));
        ClusterManagementOperationResult result = this.clusterManagementService.start((ClusterManagementOperation)operation);
        return new ResponseEntity((Object)result, HttpStatus.ACCEPTED);
    }

    @Operation(summary="list restore-redundancy")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @GetMapping(value={"/operations/restoreRedundancy"})
    public ClusterManagementListOperationsResult<RestoreRedundancyRequest, RestoreRedundancyResults> listRestoreRedundancies() {
        return this.clusterManagementService.list((ClusterManagementOperation)new RestoreRedundancyRequest());
    }

    @Operation(summary="get restore-redundancy")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @GetMapping(value={"/operations/restoreRedundancy/{id:.+}"})
    public ClusterManagementOperationResult<RestoreRedundancyRequest, RestoreRedundancyResults> getRestoreRedundancy(@PathVariable String id) {
        ClusterManagementOperationResult result = this.clusterManagementService.get((ClusterManagementOperation)new RestoreRedundancyRequest(), id);
        return result;
    }
}

