/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Optional;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.operation.RebalanceOperation;
import org.apache.geode.management.runtime.RebalanceResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="rebalanceOperation")
@RequestMapping(value={"/v1"})
public class RebalanceOperationController
extends AbstractManagementController {
    @Operation(summary="start rebalance")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @PostMapping(value={"/operations/rebalances"})
    public ResponseEntity<ClusterManagementOperationResult<RebalanceOperation, RebalanceResult>> startRebalance(@RequestBody RebalanceOperation operation) {
        operation.setOperator((String)Optional.ofNullable(this.securityService).map(SecurityService::getSubject).map(Object::toString).orElse(null));
        ClusterManagementOperationResult result = this.clusterManagementService.start((ClusterManagementOperation)operation);
        return new ResponseEntity((Object)result, HttpStatus.ACCEPTED);
    }

    @Operation(summary="list rebalances")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @GetMapping(value={"/operations/rebalances"})
    public ClusterManagementListOperationsResult<RebalanceOperation, RebalanceResult> listRebalances() {
        return this.clusterManagementService.list((ClusterManagementOperation)new RebalanceOperation());
    }

    @Operation(summary="get rebalance")
    @PreAuthorize(value="@securityService.authorize('DATA', 'MANAGE')")
    @GetMapping(value={"/operations/rebalances/{id:.+}"})
    public ClusterManagementOperationResult<RebalanceOperation, RebalanceResult> getRebalance(@PathVariable String id) {
        return this.clusterManagementService.get((ClusterManagementOperation)new RebalanceOperation(), id);
    }
}

