/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Member;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.MemberInformation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="members")
@RequestMapping(value={"/v1"})
public class MemberManagementController
extends AbstractManagementController {
    @Operation(summary="get member", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result | .groups[] | .runtimeInfo[] | {name:.memberName,status:.status}")})})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/members/{id:.+}"})
    public ClusterManagementGetResult<Member, MemberInformation> getMember(@PathVariable(name="id") String id) {
        Member config = new Member();
        config.setId(id);
        return this.clusterManagementService.get((AbstractConfiguration)config);
    }

    @Operation(summary="list members", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result[] | .groups[] | .runtimeInfo[] | {name:.memberName,status:.status}")})})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/members"})
    public ClusterManagementListResult<Member, MemberInformation> listMembers(@RequestParam(required=false) String id, @RequestParam(required=false) String group) {
        Member filter = new Member();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filter.setId(id);
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            filter.setGroup(group);
        }
        return this.clusterManagementService.list((AbstractConfiguration)filter);
    }
}

