/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.controllers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.SerializationException;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.JSONFormatterException;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.rest.internal.web.controllers.support.CacheProvider;
import org.apache.geode.rest.internal.web.controllers.support.JSONTypes;
import org.apache.geode.rest.internal.web.controllers.support.UpdateOp;
import org.apache.geode.rest.internal.web.exception.DataTypeNotSupportedException;
import org.apache.geode.rest.internal.web.exception.GemfireRestException;
import org.apache.geode.rest.internal.web.exception.MalformedJsonException;
import org.apache.geode.rest.internal.web.exception.RegionNotFoundException;
import org.apache.geode.rest.internal.web.exception.ResourceNotFoundException;
import org.apache.geode.rest.internal.web.security.RestSecurityService;
import org.apache.geode.rest.internal.web.util.ArrayUtils;
import org.apache.geode.rest.internal.web.util.IdentifiableUtils;
import org.apache.geode.rest.internal.web.util.JSONUtils;
import org.apache.geode.rest.internal.web.util.NumberUtils;
import org.apache.geode.rest.internal.web.util.ValidationUtils;
import org.apache.geode.util.internal.GeodeConverter;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractBaseController
implements InitializingBean {
    private static final String NEW_META_DATA_PROPERTY = "@new";
    private static final String OLD_META_DATA_PROPERTY = "@old";
    private static final String TYPE_META_DATA_PROPERTY = "@type";
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Logger logger = LogService.getLogger();
    private static final AtomicLong ID_SEQUENCE = new AtomicLong(0L);
    @Autowired
    protected RestSecurityService securityService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private CacheProvider cacheProvider;

    public void afterPropertiesSet() {
        JSONUtils.setObjectMapper(this.objectMapper);
    }

    protected InternalCacheForClientAccess getCache() {
        InternalCacheForClientAccess cache = this.cacheProvider.getCache();
        Assert.state((cache != null ? 1 : 0) != 0, (String)"The Gemfire Cache reference was not properly initialized");
        return cache;
    }

    URI toUri(String ... pathSegments) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path(this.getRestApiVersion()).pathSegment(pathSegments).build().toUri();
    }

    protected abstract String getRestApiVersion();

    String validateQuery(String queryInUrl, String queryInBody) {
        if (!StringUtils.hasText((String)queryInUrl) && !StringUtils.hasText((String)queryInBody)) {
            throw new GemfireRestException("could not process null value specified in query String");
        }
        return StringUtils.hasText((String)queryInUrl) ? this.decode(queryInUrl) : queryInBody;
    }

    String decode(String value) {
        if (value == null) {
            throw new GemfireRestException("could not process null value specified in query String");
        }
        return this.decode(value, "UTF-8");
    }

    protected PdxInstance convert(String json) {
        try {
            return StringUtils.hasText((String)json) ? JSONFormatter.fromJSON((String)json) : null;
        }
        catch (JSONFormatterException jpe) {
            throw new MalformedJsonException("Json doc specified is either not supported or invalid!", jpe);
        }
    }

    protected String convert(PdxInstance pdxObj) {
        try {
            return pdxObj != null ? JSONFormatter.toJSON((PdxInstance)pdxObj) : null;
        }
        catch (JSONFormatterException jpe) {
            throw new GemfireRestException("Requested data could not convert into REST format(JSON)!", jpe);
        }
    }

    protected String convert(Iterable<PdxInstance> pdxObjs) {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        for (PdxInstance pdxObj : pdxObjs) {
            String json = this.convert(pdxObj);
            if (!StringUtils.hasText((String)json)) continue;
            buffer.append(count++ > 0 ? ", " : "").append(json);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private <T> T casValue(String regionNamePath, String key, String jsonData) {
        try {
            JsonNode jsonObject = this.objectMapper.readTree(jsonData);
            JsonNode oldValue = jsonObject.get(OLD_META_DATA_PROPERTY);
            JsonNode newValue = jsonObject.get(NEW_META_DATA_PROPERTY);
            if (oldValue == null || newValue == null) {
                throw new MalformedJsonException("Json doc specified in request body is invalid!");
            }
            return (T)this.casValue(regionNamePath, key, this.convert(oldValue.toString()), this.convert(newValue.toString()));
        }
        catch (IOException je) {
            throw new MalformedJsonException("Json doc specified in request body is invalid!", je);
        }
    }

    ResponseEntity<String> processQueryResponse(Query query, Object[] args, Object queryResult) {
        if (queryResult instanceof Collection) {
            ArrayList<Object> processedResults = new ArrayList<Object>(((Collection)queryResult).size());
            for (Object result : (Collection)queryResult) {
                processedResults.add(this.securityService.postProcess(null, null, result, false));
            }
            String queryResultAsJson = JSONUtils.convertCollectionToJson(processedResults);
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(this.toUri("queries", query.getQueryString()));
            return new ResponseEntity((Object)queryResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
        }
        throw new GemfireRestException("Server has encountered error while generating query result into restful format(JSON)!");
    }

    Collection<PdxInstance> convertJsonArrayIntoPdxCollection(String jsonArray) {
        try {
            JsonNode array = this.objectMapper.readTree(jsonArray);
            if (!array.isArray()) {
                throw new MalformedJsonException("Json document specified in request body is not an array!");
            }
            ArrayList<PdxInstance> pdxInstances = new ArrayList<PdxInstance>();
            for (int index = 0; index < array.size(); ++index) {
                JsonNode object = array.get(index);
                String element = this.objectMapper.writeValueAsString((Object)object);
                PdxInstance pi = this.convert(element);
                pdxInstances.add(pi);
            }
            return pdxInstances;
        }
        catch (IOException je) {
            throw new MalformedJsonException("Json document specified in request body is not valid!", je);
        }
    }

    private Object casValue(String regionNamePath, Object key, Object oldValue, Object newValue) {
        Region region = this.getRegion(regionNamePath);
        try {
            return region.replace(key, oldValue, newValue) ? null : region.get(key);
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    private void replaceValue(String regionNamePath, Object key, PdxInstance value) {
        try {
            if (this.getRegion(regionNamePath).replace(key, (Object)value) == null) {
                throw new ResourceNotFoundException(String.format("No resource at (%1$s) exists!", this.toUri(regionNamePath, String.valueOf(key))));
            }
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    protected void replaceValue(String regionNamePath, Object key, Object value) {
        try {
            if (this.getRegion(regionNamePath).replace(key, value) == null) {
                throw new ResourceNotFoundException(String.format("No resource at (%1$s) exists!", this.toUri(regionNamePath, String.valueOf(key))));
            }
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    private void putValue(String regionNamePath, Object key, Object value) {
        try {
            this.getRegion(regionNamePath).put(key, value);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), npe);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), cce);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    private void deleteQueryId(String regionNamePath, String key) {
        this.getQueryStore(regionNamePath).remove((Object)key);
    }

    void deleteNamedQuery(String regionNamePath, String key) {
        this.checkForQueryIdExist(regionNamePath, key);
        this.deleteQueryId(regionNamePath, key);
    }

    void checkForQueryIdExist(String region, String key) {
        if (!this.getQueryStore(region).containsKey((Object)key)) {
            throw new ResourceNotFoundException(String.format("Named query (%1$s) does not exist!", key));
        }
    }

    Region<String, String> getQueryStore(String namePath) {
        return ValidationUtils.returnValueThrowOnNull(this.getCache().getInternalRegion(namePath), (RuntimeException)((Object)new GemfireRestException(String.format("Query store (%1$s) does not exist!", namePath))));
    }

    protected String getQueryIdValue(String regionNamePath, String key) {
        Assert.notNull((Object)key, (String)"queryId cannot be null!");
        try {
            return (String)this.getQueryStore(regionNamePath).get((Object)key);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("NULL query ID or query string is not supported!", npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException("Server has not allowed to perform the requested operation!", iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException te) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", te);
        }
    }

    void updateNamedQuery(String regionNamePath, String key, String value) {
        try {
            this.getQueryStore(regionNamePath).put((Object)key, (Object)value);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("NULL query ID or query string is not supported!", npe);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("specified queryId or query string is not supported!", cce);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    <T> T createNamedQuery(String regionNamePath, String key, String value) {
        try {
            return (T)this.getQueryStore(regionNamePath).putIfAbsent((Object)key, (Object)value);
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException("Requested operation is not supported!", use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Specified queryId or query string is not supported!", cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("NULL query ID or query string is not supported!", npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException("Configuration does not allow to perform the requested operation!", iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    private void putPdxValues(String regionNamePath, Map<Object, PdxInstance> map) {
        try {
            this.getRegion(regionNamePath).putAll(map);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("low memory condition is detected.", lme);
        }
    }

    private void putValues(String regionNamePath, Map<Object, Object> values) {
        this.getRegion(regionNamePath).putAll(values);
    }

    protected void putValues(String regionNamePath, String[] keys, List<?> values) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (keys.length != values.size()) {
            throw new GemfireRestException("Bad request, Keys and Value size does not match");
        }
        for (int i = 0; i < keys.length; ++i) {
            Object domainObj = this.introspectAndConvert(values.get(i));
            map.put(keys[i], domainObj);
        }
        if (!map.isEmpty()) {
            this.putValues(regionNamePath, map);
        }
    }

    <T> T postValue(String regionNamePath, Object key, Object value) {
        try {
            return (T)this.getRegion(regionNamePath).putIfAbsent(key, value);
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", lme);
        }
    }

    protected Object getActualTypeValue(String value, String valueType) {
        Object actualValue = value;
        if (valueType != null) {
            try {
                actualValue = GeodeConverter.convertToActualType((String)value, (String)valueType);
            }
            catch (IllegalArgumentException ie) {
                throw new GemfireRestException(ie.getMessage(), ie);
            }
        }
        return actualValue;
    }

    String generateKey(String existingKey) {
        return this.generateKey(existingKey, null);
    }

    private String generateKey(String existingKey, Object domainObject) {
        String newKey;
        Object domainObjectId = IdentifiableUtils.getId(domainObject);
        if (StringUtils.hasText((String)existingKey)) {
            Long newId;
            newKey = existingKey;
            if (NumberUtils.isNumeric(newKey) && domainObjectId == null && newKey.equals((newId = IdentifiableUtils.createId(NumberUtils.parseLong(newKey))).toString())) {
                IdentifiableUtils.setId(domainObject, newId);
            }
        } else if (domainObjectId != null) {
            Long domainObjectIdAsLong = NumberUtils.longValue(domainObjectId);
            if (domainObjectIdAsLong != null) {
                Long newId = IdentifiableUtils.createId(domainObjectIdAsLong);
                if (!domainObjectIdAsLong.equals(newId)) {
                    IdentifiableUtils.setId(domainObject, newId);
                }
                newKey = String.valueOf(newId);
            } else {
                newKey = String.valueOf(domainObjectId);
            }
        } else {
            domainObjectId = IdentifiableUtils.createId();
            newKey = String.valueOf(domainObjectId);
            IdentifiableUtils.setId(domainObject, domainObjectId);
        }
        return newKey;
    }

    private String decode(String value, String encoding) {
        try {
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new GemfireRestException("Server has encountered unsupported encoding!");
        }
    }

    protected <T> Region<Object, T> getRegion(String namePath) {
        return ValidationUtils.returnValueThrowOnNull(this.getCache().getRegion(namePath), new RegionNotFoundException(String.format("The Region identified by name (%1$s) could not be found!", namePath)));
    }

    private void checkForKeyExist(String region, String key) {
        if (!this.getRegion(region).containsKey((Object)key)) {
            throw new ResourceNotFoundException(String.format("Key (%1$s) does not exist for region (%2$s) in cache!", key, region));
        }
    }

    List<String> checkForMultipleKeysExist(String region, String ... keys) {
        ArrayList<String> unknownKeys = new ArrayList<String>();
        for (int index = 0; index < keys.length; ++index) {
            if (this.getRegion(region).containsKey((Object)keys[index])) continue;
            unknownKeys.add(keys[index]);
        }
        return unknownKeys;
    }

    protected Object[] getKeys(String regionNamePath, Object[] keys) {
        return keys != null && keys.length != 0 ? keys : this.getRegion(regionNamePath).keySet().toArray();
    }

    protected <T> Map<Object, T> getValues(String regionNamePath, Object ... keys) {
        try {
            Region<Object, T> region = this.getRegion(regionNamePath);
            Map entries = region.getAll(Arrays.asList(this.getKeys(regionNamePath, keys)));
            for (Object key : entries.keySet()) {
                entries.put(key, this.securityService.postProcess(regionNamePath, key, entries.get(key), false));
            }
            return entries;
        }
        catch (SerializationException se) {
            throw new DataTypeNotSupportedException("The resource identified could not convert into the supported content characteristics (JSON)!", se);
        }
    }

    protected <T> Map<Object, T> getValues(String regionNamePath, String ... keys) {
        return this.getValues(regionNamePath, (Object[])keys);
    }

    protected <T extends PdxInstance> Collection<T> getPdxValues(String regionNamePath, Object ... keys) {
        Region<Object, T> region = this.getRegion(regionNamePath);
        Map entries = region.getAll(Arrays.asList(this.getKeys(regionNamePath, keys)));
        return entries.values();
    }

    private void deleteValue(String regionNamePath, Object key) {
        this.getRegion(regionNamePath).remove(key);
    }

    void deleteValues(String regionNamePath, Object ... keys) {
        for (Object key : keys) {
            this.checkForKeyExist(regionNamePath, key.toString());
        }
        for (Object key : keys) {
            this.deleteValue(regionNamePath, key);
        }
    }

    void deleteValues(String regionNamePath) {
        try {
            this.getRegion(regionNamePath).clear();
        }
        catch (UnsupportedOperationException ue) {
            throw new GemfireRestException("Requested operation not allowed on partition region", ue);
        }
    }

    private boolean isForm(Map<Object, Object> rawDataBinding) {
        return !rawDataBinding.containsKey(TYPE_META_DATA_PROPERTY) && rawDataBinding.containsKey(OLD_META_DATA_PROPERTY) && rawDataBinding.containsKey(NEW_META_DATA_PROPERTY);
    }

    private <T> T introspectAndConvert(T value) {
        if (value instanceof Map) {
            Map rawDataBinding = (Map)value;
            if (this.isForm(rawDataBinding)) {
                rawDataBinding.put(OLD_META_DATA_PROPERTY, this.introspectAndConvert(rawDataBinding.get(OLD_META_DATA_PROPERTY)));
                rawDataBinding.put(NEW_META_DATA_PROPERTY, this.introspectAndConvert(rawDataBinding.get(NEW_META_DATA_PROPERTY)));
                return (T)rawDataBinding;
            }
            String typeValue = (String)rawDataBinding.get(TYPE_META_DATA_PROPERTY);
            if (typeValue == null) {
                return (T)new Object();
            }
            if (NumberUtils.isPrimitiveOrObject(typeValue)) {
                Object primitiveValue = rawDataBinding.get("@value");
                try {
                    return (T)GeodeConverter.convertToActualType((String)primitiveValue.toString(), (String)typeValue);
                }
                catch (IllegalArgumentException e) {
                    throw new GemfireRestException("Server has encountered error (illegal or inappropriate arguments).", e);
                }
            }
            Assert.state((boolean)ClassUtils.isPresent((String)typeValue, (ClassLoader)Thread.currentThread().getContextClassLoader()), (String)String.format("Class (%1$s) could not be found!", typeValue));
            return (T)this.objectMapper.convertValue((Object)rawDataBinding, ClassUtils.resolveClassName((String)typeValue, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        return value;
    }

    String convertErrorAsJson(String errorMessage) {
        return "{\"cause\":\"" + errorMessage + "\"}";
    }

    String convertErrorAsJson(Throwable t) {
        return String.format("{\"message\" : \"%1$s\"}", t.getMessage());
    }

    private Map<?, ?> convertJsonToMap(String jsonString) {
        Map map = new HashMap();
        try {
            map = (Map)this.objectMapper.readValue(jsonString, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (JsonParseException e) {
            throw new MalformedJsonException("Bind params specified as JSON document in the request is incorrect!", e);
        }
        catch (JsonMappingException e) {
            throw new MalformedJsonException("Server unable to process bind params specified as JSON document in the request!", e);
        }
        catch (IOException e) {
            throw new GemfireRestException("Server has encountered error while process this request!", e);
        }
        return map;
    }

    private Object jsonToObject(String jsonString) {
        return this.introspectAndConvert(this.convertJsonToMap(jsonString));
    }

    Object[] jsonToObjectArray(String arguments) {
        JsonNode node;
        try {
            node = this.objectMapper.readTree(arguments);
        }
        catch (IOException e) {
            throw new MalformedJsonException("Json document specified in request body is not valid!");
        }
        if (node.isArray()) {
            try {
                Object[] args = new Object[node.size()];
                for (int index = 0; index < node.size(); ++index) {
                    args[index] = this.jsonToObject(this.objectMapper.writeValueAsString((Object)node.get(index)));
                }
                return args;
            }
            catch (JsonProcessingException je) {
                throw new MalformedJsonException("Json document specified in request body is not valid!", je);
            }
        }
        if (node.isObject()) {
            return new Object[]{this.jsonToObject(arguments)};
        }
        throw new MalformedJsonException("Json document specified in request body is not valid!");
    }

    ResponseEntity<String> updateSingleKey(String region, String key, String json, String opValue) {
        JSONTypes jsonType = this.validateJsonAndFindType(json);
        UpdateOp op = UpdateOp.valueOf(opValue.toUpperCase());
        String existingValue = null;
        switch (op) {
            case CAS: {
                PdxInstance existingPdxObj = (PdxInstance)this.casValue(region, key, json);
                existingValue = this.convert(existingPdxObj);
                break;
            }
            case REPLACE: {
                this.replaceValue(region, (Object)key, this.convert(json));
                break;
            }
            default: {
                if (JSONTypes.JSON_ARRAY.equals((Object)jsonType)) {
                    this.putValue(region, key, this.convertJsonArrayIntoPdxCollection(json));
                    break;
                }
                this.putValue(region, key, this.convert(json));
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(region, key));
        return new ResponseEntity((Object)existingValue, (MultiValueMap)headers, existingValue == null ? HttpStatus.OK : HttpStatus.CONFLICT);
    }

    ResponseEntity<String> updateMultipleKeys(String region, String[] keys, String json) {
        JsonNode jsonArr;
        try {
            jsonArr = this.objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new MalformedJsonException("JSON document specified in the request is incorrect", e);
        }
        if (!jsonArr.isArray() || jsonArr.size() != keys.length) {
            throw new MalformedJsonException("Each key must have corresponding value (JSON document) specified in the request");
        }
        HashMap<Object, PdxInstance> map = new HashMap<Object, PdxInstance>();
        for (int i = 0; i < keys.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating (put) Json document ({}) having key ({}) in Region ({})", (Object)json, (Object)keys[i], (Object)region);
            }
            try {
                PdxInstance pdxObj = this.convert(this.objectMapper.writeValueAsString((Object)jsonArr.get(i)));
                map.put(keys[i], pdxObj);
                continue;
            }
            catch (JsonProcessingException e) {
                throw new MalformedJsonException(String.format("JSON document at index (%1$s) in the request body is incorrect", i), e);
            }
        }
        if (!CollectionUtils.isEmpty(map)) {
            this.putPdxValues(region, map);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(region, StringUtils.arrayToCommaDelimitedString((Object[])keys)));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    JSONTypes validateJsonAndFindType(String json) {
        try {
            JsonParser jp = new JsonFactory().createParser(json);
            JsonToken token = jp.nextToken();
            if (token == JsonToken.START_OBJECT) {
                return JSONTypes.JSON_OBJECT;
            }
            if (token == JsonToken.START_ARRAY) {
                return JSONTypes.JSON_ARRAY;
            }
            return JSONTypes.UNRECOGNIZED_JSON;
        }
        catch (IOException je) {
            throw new MalformedJsonException("JSON document specified in the request is incorrect", je);
        }
    }

    protected QueryService getQueryService() {
        return this.getCache().getQueryService();
    }

    protected <T> T getValue(String regionNamePath, Object key) {
        return this.getValue(regionNamePath, key, true);
    }

    protected <T> T getValue(String regionNamePath, Object key, boolean postProcess) {
        Assert.notNull((Object)key, (String)"The Cache Region key to read the value for cannot be null!");
        Region<Object, T> r = this.getRegion(regionNamePath);
        try {
            Object value = r.get(key);
            if (postProcess) {
                return (T)this.securityService.postProcess(regionNamePath, key, value, false);
            }
            return (T)value;
        }
        catch (SerializationException se) {
            throw new DataTypeNotSupportedException("The resource identified could not convert into the supported content characteristics (JSON)!", se);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys!", regionNamePath), npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow requested operation on specified key!", regionNamePath), iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", lee);
        }
        catch (TimeoutException te) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", te);
        }
        catch (CacheLoaderException cle) {
            throw new GemfireRestException("Server has encountered CacheLoader error while processing this request!", cle);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("CacheLoader could not be invoked on partitioned region!", prse);
        }
    }

    protected Set<DistributedMember> getMembers(String ... memberIdNames) {
        ValidationUtils.returnValueThrowOnNull(memberIdNames, (RuntimeException)((Object)new GemfireRestException("No member found to run function")));
        HashSet<DistributedMember> targetedMembers = new HashSet<DistributedMember>(ArrayUtils.length(memberIdNames));
        List<String> memberIdNameList = Arrays.asList(memberIdNames);
        InternalCacheForClientAccess cache = this.getCache();
        Set distMembers = cache.getDistributedSystem().getAllOtherMembers();
        distMembers.add(cache.getDistributedSystem().getDistributedMember());
        for (DistributedMember member : distMembers) {
            if (!memberIdNameList.contains(member.getId()) && !memberIdNameList.contains(member.getName())) continue;
            targetedMembers.add(member);
        }
        return targetedMembers;
    }

    Set<DistributedMember> getAllMembersInDS() {
        InternalCacheForClientAccess cache = this.getCache();
        Set distMembers = cache.getDistributedSystem().getAllOtherMembers();
        HashSet<DistributedMember> targetedMembers = new HashSet<DistributedMember>();
        for (DistributedMember member : distMembers) {
            InternalDistributedMember idm = (InternalDistributedMember)member;
            if (idm.getVmKind() != 10) continue;
            targetedMembers.add(member);
        }
        targetedMembers.add(cache.getDistributedSystem().getDistributedMember());
        return targetedMembers;
    }
}

