/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal.parallel;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.wan.internal.GatewaySenderEventRemoteDispatcher;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemoteParallelGatewaySenderEventProcessor
extends ParallelGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();

    protected RemoteParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, Set<Region<?, ?>> userRegions, int id, int nDispatcher, ThreadsMonitoring tMonitoring, boolean cleanQueues) {
        super(sender, id, nDispatcher, tMonitoring, cleanQueues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            GatewaySenderEventRemoteDispatcher remoteDispatcher;
            if (this.dispatcher.isRemoteDispatcher() && (remoteDispatcher = (GatewaySenderEventRemoteDispatcher)this.dispatcher).isConnectedToRemote()) {
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }

    public void initializeEventDispatcher() {
        if (logger.isDebugEnabled()) {
            logger.debug(" Creating the GatewayEventRemoteDispatcher");
        }
        if (this.sender.getRemoteDSId() != -1) {
            this.dispatcher = new GatewaySenderEventRemoteDispatcher((AbstractGatewaySenderEventProcessor)this);
        }
    }
}

