/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.wan.internal.WanCopyRegionFunctionServiceAlreadyRunningException;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.lang.SystemProperty;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class WanCopyRegionFunctionService
implements CacheService {
    private static final String WAN_COPY_REGION_FUNCTION_EXECUTION_PROCESSOR_THREAD_PREFIX = "WAN Copy Region Function Execution Processor";
    private volatile ExecutorService wanCopyRegionFunctionExecutionPool;
    private final Map<String, Future<CliFunctionResult>> executions = new ConcurrentHashMap<String, Future<CliFunctionResult>>();

    public boolean init(Cache cache) {
        int maxConcurrentThreads = SystemProperty.getProductIntegerProperty((String)"geode.wan.copy-region.max-threads", (int)10);
        return this.init(maxConcurrentThreads);
    }

    boolean init(int maxConcurrentThreads) {
        this.wanCopyRegionFunctionExecutionPool = LoggingExecutors.newFixedThreadPool((int)maxConcurrentThreads, (String)WAN_COPY_REGION_FUNCTION_EXECUTION_PROCESSOR_THREAD_PREFIX, (boolean)true);
        return true;
    }

    public Class<? extends CacheService> getInterface() {
        return WanCopyRegionFunctionService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    public void close() {
        this.wanCopyRegionFunctionExecutionPool.shutdownNow();
        try {
            if (!this.wanCopyRegionFunctionExecutionPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.wanCopyRegionFunctionExecutionPool.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.wanCopyRegionFunctionExecutionPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CliFunctionResult execute(Callable<CliFunctionResult> callable, String regionName, String senderId) throws InterruptedException, ExecutionException, WanCopyRegionFunctionServiceAlreadyRunningException {
        String executionName = this.getExecutionName(regionName, senderId);
        Future<CliFunctionResult> future = null;
        try {
            CliFunctionResult cliFunctionResult = this.executions;
            synchronized (cliFunctionResult) {
                if (this.executions.containsKey(executionName)) {
                    throw new WanCopyRegionFunctionServiceAlreadyRunningException("There is already an execution running for " + regionName + " and " + senderId);
                }
                future = this.wanCopyRegionFunctionExecutionPool.submit(callable);
                this.executions.put(executionName, future);
            }
            cliFunctionResult = future.get();
            return cliFunctionResult;
        }
        finally {
            if (future != null) {
                this.executions.remove(executionName);
            }
        }
    }

    public boolean cancel(String regionName, String senderId) {
        Future<CliFunctionResult> execution = this.executions.remove(this.getExecutionName(regionName, senderId));
        if (execution == null) {
            return false;
        }
        execution.cancel(true);
        return true;
    }

    public String cancelAll() {
        String executionsString = this.executions.keySet().toString();
        for (Future<CliFunctionResult> execution : this.executions.values()) {
            execution.cancel(true);
        }
        this.executions.clear();
        return executionsString;
    }

    public int getNumberOfCurrentExecutions() {
        return this.executions.size();
    }

    private String getExecutionName(String regionName, String senderId) {
        return "(" + regionName + "," + senderId + ")";
    }
}

