/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.net.BindException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.AvailablePort;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.wan.GatewayReceiverException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GatewayReceiverImpl
implements GatewayReceiver {
    private static final Logger logger = LogService.getLogger();
    private String host;
    private int startPort;
    private int endPort;
    private int port;
    private int timeBetPings;
    private int socketBufferSize;
    private boolean manualStart;
    private final List<GatewayTransportFilter> filters;
    private String bindAdd;
    private CacheServer receiver;
    private final GemFireCacheImpl cache;

    public GatewayReceiverImpl(Cache cache, int startPort, int endPort, int timeBetPings, int buffSize, String bindAdd, List<GatewayTransportFilter> filters, String hostnameForSenders, boolean manualStart) {
        this.cache = (GemFireCacheImpl)cache;
        if (hostnameForSenders == null || hostnameForSenders.isEmpty()) {
            if (bindAdd == null || bindAdd.isEmpty()) {
                try {
                    logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayReceiverImpl_USING_LOCAL_HOST));
                    this.host = SocketCreator.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException(LocalizedStrings.GatewayReceiverImpl_COULD_NOT_GET_HOST_NAME.toLocalizedString(), e);
                }
            } else {
                this.host = bindAdd;
            }
        } else {
            this.host = hostnameForSenders;
        }
        this.startPort = startPort;
        this.endPort = endPort;
        this.timeBetPings = timeBetPings;
        this.socketBufferSize = buffSize;
        this.bindAdd = bindAdd;
        this.filters = filters;
        this.manualStart = manualStart;
    }

    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.filters;
    }

    public int getMaximumTimeBetweenPings() {
        return this.timeBetPings;
    }

    public int getPort() {
        return this.port;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public boolean isManualStart() {
        return this.manualStart;
    }

    public CacheServer getServer() {
        return this.receiver;
    }

    public void start() throws IOException {
        if (this.receiver == null) {
            this.receiver = this.cache.addCacheServer(true);
        }
        if (this.receiver.isRunning()) {
            logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayReceiver_IS_ALREADY_RUNNING));
            return;
        }
        boolean started = false;
        this.port = this.getPortToStart();
        while (!started && this.port != -1) {
            this.receiver.setPort(this.port);
            this.receiver.setSocketBufferSize(this.socketBufferSize);
            this.receiver.setMaximumTimeBetweenPings(this.timeBetPings);
            this.receiver.setHostnameForClients(this.host);
            this.receiver.setBindAddress(this.bindAdd);
            this.receiver.setGroups(new String[]{"__recv__group"});
            ((CacheServerImpl)this.receiver).setGatewayTransportFilter(this.filters);
            try {
                ((CacheServerImpl)this.receiver).start();
                started = true;
            }
            catch (BindException be) {
                if (be.getCause() != null && be.getCause().getMessage().contains("assign requested address")) {
                    throw new GatewayReceiverException(LocalizedStrings.SocketCreator_FAILED_TO_CREATE_SERVER_SOCKET_ON_0_1.toLocalizedString(new Object[]{this.bindAdd, this.port}));
                }
                logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayReceiver_Address_Already_In_Use, (Object)this.port));
                this.port = this.getPortToStart();
            }
            catch (SocketException se) {
                if (se.getMessage().contains("Address already in use")) {
                    logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayReceiver_Address_Already_In_Use, (Object)this.port));
                    this.port = this.getPortToStart();
                    continue;
                }
                throw se;
            }
        }
        if (!started) {
            throw new IllegalStateException("No available free port found in the given range.");
        }
        logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayReceiver_STARTED_ON_PORT, (Object)this.port));
        InternalDistributedSystem system = this.cache.getDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_START, (Object)this);
    }

    private int getPortToStart() {
        int rPort = this.startPort == this.endPort ? this.startPort : AvailablePort.getRandomAvailablePortInRange((int)this.startPort, (int)this.endPort, (int)0);
        return rPort;
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new GatewayReceiverException(LocalizedStrings.GatewayReceiver_IS_NOT_RUNNING.toLocalizedString());
        }
        this.receiver.stop();
    }

    public String getHost() {
        return this.host;
    }

    public String getBindAddress() {
        return this.bindAdd;
    }

    public boolean isRunning() {
        if (this.receiver != null) {
            return this.receiver.isRunning();
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("Gateway Receiver").append("@").append(Integer.toHexString(this.hashCode())).append(" [").append("host='").append(this.getHost()).append("'; port=").append(this.getPort()).append("; bindAddress=").append(this.getBindAddress()).append("; maximumTimeBetweenPings=").append(this.getMaximumTimeBetweenPings()).append("; socketBufferSize=").append(this.getSocketBufferSize()).append("; isManualStart=").append(this.isManualStart()).append("; group=").append(Arrays.toString(new String[]{"__recv__group"})).append("]").toString();
    }
}

