/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorHelper;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorJoinMessage;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorResponse;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LocatorMembershipListenerImpl
implements LocatorMembershipListener {
    private ConcurrentMap<Integer, Set<DistributionLocatorId>> allLocatorsInfo = new ConcurrentHashMap<Integer, Set<DistributionLocatorId>>();
    private ConcurrentMap<Integer, Set<String>> allServerLocatorsInfo = new ConcurrentHashMap<Integer, Set<String>>();
    private static final Logger logger = LogService.getLogger();
    private DistributionConfig config;
    private int port;

    public void setPort(int port) {
        this.port = port;
    }

    public void setConfig(DistributionConfig config) {
        this.config = config;
    }

    public void locatorJoined(final int distributedSystemId, final DistributionLocatorId locator, final DistributionLocatorId sourceLocator) {
        Thread distributeLocator = new Thread(new Runnable(){

            @Override
            public void run() {
                ConcurrentMap<Integer, Set<DistributionLocatorId>> remoteLocators = LocatorMembershipListenerImpl.this.getAllLocatorsInfo();
                ArrayList<DistributionLocatorId> locatorsToRemove = new ArrayList<DistributionLocatorId>();
                String localLocator = LocatorMembershipListenerImpl.this.config.getStartLocator();
                DistributionLocatorId localLocatorId = null;
                localLocatorId = localLocator.equals("") ? new DistributionLocatorId(LocatorMembershipListenerImpl.this.port, LocatorMembershipListenerImpl.this.config.getBindAddress()) : new DistributionLocatorId(localLocator);
                locatorsToRemove.add(localLocatorId);
                locatorsToRemove.add(locator);
                locatorsToRemove.add(sourceLocator);
                HashMap localCopy = new HashMap();
                for (Map.Entry entry : remoteLocators.entrySet()) {
                    CopyOnWriteHashSet value = new CopyOnWriteHashSet((Set)entry.getValue());
                    localCopy.put(entry.getKey(), value);
                }
                for (Map.Entry entry : localCopy.entrySet()) {
                    for (DistributionLocatorId removeLocId : locatorsToRemove) {
                        if (!((Set)entry.getValue()).contains(removeLocId)) continue;
                        ((Set)entry.getValue()).remove(removeLocId);
                    }
                    for (DistributionLocatorId value : (Set)entry.getValue()) {
                        block8: {
                            try {
                                TcpClient.requestToServer((InetAddress)value.getHost(), (int)value.getPort(), (Object)((Object)new LocatorJoinMessage(distributedSystemId, locator, localLocatorId, "")), (int)1000, (boolean)false);
                            }
                            catch (Exception e) {
                                if (!logger.isDebugEnabled()) break block8;
                                logger.debug((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_MEMBERSHIP_LISTENER_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_1_WIHT_2_3, (Object[])new Object[]{locator.getHost(), locator.getPort(), value.getHost(), value.getPort()}));
                            }
                        }
                        try {
                            TcpClient.requestToServer((InetAddress)locator.getHost(), (int)locator.getPort(), (Object)((Object)new LocatorJoinMessage((Integer)entry.getKey(), value, localLocatorId, "")), (int)1000, (boolean)false);
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_MEMBERSHIP_LISTENER_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_1_WIHT_2_3, (Object[])new Object[]{value.getHost(), value.getPort(), locator.getHost(), locator.getPort()}));
                        }
                    }
                }
            }
        });
        distributeLocator.setDaemon(true);
        distributeLocator.start();
    }

    public Object handleRequest(Object request) {
        Object response = null;
        if (request instanceof RemoteLocatorJoinRequest) {
            response = this.updateAllLocatorInfo((RemoteLocatorJoinRequest)request);
        } else if (request instanceof LocatorJoinMessage) {
            response = this.informAboutRemoteLocators((LocatorJoinMessage)((Object)request));
        } else if (request instanceof RemoteLocatorPingRequest) {
            response = this.getPingResponse((RemoteLocatorPingRequest)request);
        } else if (request instanceof RemoteLocatorRequest) {
            response = this.getRemoteLocators((RemoteLocatorRequest)request);
        }
        return response;
    }

    private synchronized Object updateAllLocatorInfo(RemoteLocatorJoinRequest request) {
        int distributedSystemId = request.getDistributedSystemId();
        DistributionLocatorId locator = request.getLocator();
        LocatorHelper.addLocator(distributedSystemId, locator, this, null);
        return new RemoteLocatorJoinResponse(this.getAllLocatorsInfo());
    }

    private Object getPingResponse(RemoteLocatorPingRequest request) {
        return new RemoteLocatorPingResponse();
    }

    private Object informAboutRemoteLocators(LocatorJoinMessage request) {
        int distributedSystemId = request.getDistributedSystemId();
        DistributionLocatorId locator = request.getLocator();
        DistributionLocatorId sourceLocatorId = request.getSourceLocator();
        LocatorHelper.addLocator(distributedSystemId, locator, this, sourceLocatorId);
        return null;
    }

    private Object getRemoteLocators(RemoteLocatorRequest request) {
        int dsId = request.getDsId();
        Set<String> locators = this.getRemoteLocatorInfo(dsId);
        return new RemoteLocatorResponse(locators);
    }

    public Set<String> getRemoteLocatorInfo(int dsId) {
        return (Set)this.allServerLocatorsInfo.get(dsId);
    }

    public ConcurrentMap<Integer, Set<DistributionLocatorId>> getAllLocatorsInfo() {
        return this.allLocatorsInfo;
    }

    public ConcurrentMap<Integer, Set<String>> getAllServerLocatorsInfo() {
        return this.allServerLocatorsInfo;
    }

    public void clearLocatorInfo() {
        this.allLocatorsInfo.clear();
        this.allServerLocatorsInfo.clear();
    }
}

