/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationRequest;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocatorJoinMessage
extends ServerLocationRequest {
    private DistributionLocatorId locator;
    private int distributedSystemId;
    private DistributionLocatorId sourceLocator;

    public LocatorJoinMessage() {
    }

    public LocatorJoinMessage(int distributedSystemId, DistributionLocatorId locator, DistributionLocatorId sourceLocator, String serverGroup) {
        super(serverGroup);
        this.locator = locator;
        this.distributedSystemId = distributedSystemId;
        this.sourceLocator = sourceLocator;
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.locator = (DistributionLocatorId)DataSerializer.readObject((DataInput)in);
        this.distributedSystemId = in.readInt();
        this.sourceLocator = (DistributionLocatorId)DataSerializer.readObject((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject((Object)this.locator, (DataOutput)out);
        out.writeInt(this.distributedSystemId);
        DataSerializer.writeObject((Object)this.sourceLocator, (DataOutput)out);
    }

    public DistributionLocatorId getLocator() {
        return this.locator;
    }

    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public DistributionLocatorId getSourceLocator() {
        return this.sourceLocator;
    }

    public int getDSFID() {
        return 2139;
    }

    public String toString() {
        return "LocatorJoinMessage{distributedSystemId=" + this.distributedSystemId + " locators=" + this.locator + " Source Locator : " + this.sourceLocator + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocatorJoinMessage)) {
            return false;
        }
        LocatorJoinMessage myObject = (LocatorJoinMessage)((Object)obj);
        return this.distributedSystemId == myObject.getDistributedSystemId() && this.locator.equals((Object)myObject.getLocator());
    }

    public int hashCode() {
        if (this.locator == null) {
            return 0;
        }
        return this.locator.hashCode();
    }
}

