/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.geode.distributed.internal.tcpserver.InetSocketWrapper;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class HostAndPort
extends InetSocketWrapper
implements DataSerializableFixedID {
    public HostAndPort() {
    }

    public HostAndPort(String hostName, int port) {
        super(hostName, port);
    }

    public int getPort() {
        return this.inetSocketAddress.getPort();
    }

    public int getDSFID() {
        return 2185;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        if (this.inetSocketAddress.isUnresolved()) {
            out.writeByte(0);
            StaticSerialization.writeString((String)this.getHostName(), (DataOutput)out);
            out.writeInt(this.getPort());
        } else {
            out.writeByte(1);
            StaticSerialization.writeInetAddress((InetAddress)this.inetSocketAddress.getAddress(), (DataOutput)out);
            out.writeInt(this.getPort());
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if ((flags & 1) == 0) {
            String hostName = StaticSerialization.readString((DataInput)in);
            int port = in.readInt();
            this.inetSocketAddress = hostName == null || hostName.isEmpty() ? new InetSocketAddress(port) : InetSocketAddress.createUnresolved(hostName, port);
        } else {
            InetAddress address = StaticSerialization.readInetAddress((DataInput)in);
            int port = in.readInt();
            this.inetSocketAddress = new InetSocketAddress(address, port);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

