/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.serialization.filter.FilterConfiguration;
import org.apache.geode.internal.serialization.filter.JmxSerialFilterConfiguration;
import org.apache.geode.internal.serialization.filter.JmxSerialFilterConfigurationFactory;
import org.apache.geode.internal.serialization.filter.OpenMBeanFilterPattern;

public class SystemPropertyJmxSerialFilterConfigurationFactory
implements JmxSerialFilterConfigurationFactory {
    private static final String PROPERTY_NAME = "jmx.remote.rmi.server.serial.filter.pattern";
    private final boolean enabled;
    private final String pattern;

    public SystemPropertyJmxSerialFilterConfigurationFactory() {
        this(SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9) && StringUtils.isBlank((CharSequence)System.getProperty(PROPERTY_NAME)), new OpenMBeanFilterPattern().pattern());
    }

    @VisibleForTesting
    SystemPropertyJmxSerialFilterConfigurationFactory(boolean enabled, String pattern) {
        this.enabled = enabled;
        this.pattern = pattern;
    }

    @Override
    public FilterConfiguration create() {
        if (this.enabled) {
            return new JmxSerialFilterConfiguration(PROPERTY_NAME, this.pattern);
        }
        return () -> false;
    }
}

