/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.serialization.filter.FilterConfiguration;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class JmxSerialFilterConfiguration
implements FilterConfiguration {
    private static final Logger LOGGER = LogService.getLogger();
    private final String key;
    private final String value;
    private final Logger logger;

    JmxSerialFilterConfiguration(String property, String pattern) {
        this(property, pattern, LOGGER);
    }

    @VisibleForTesting
    JmxSerialFilterConfiguration(String property, String pattern, Logger logger) {
        this.key = property;
        this.value = pattern;
        this.logger = logger;
    }

    @Override
    public boolean configure() {
        if (StringUtils.isBlank((CharSequence)System.getProperty(this.key))) {
            System.setProperty(this.key, this.value);
            this.logger.info("System property '" + this.key + "' is now configured with '" + this.value + "'.");
            return true;
        }
        this.logger.info("System property '" + this.key + "' is already configured.");
        return false;
    }
}

