/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.support.CronExpression;

@Experimental(value="The autobalancer may be removed or the API may change in future releases")
public class AutoBalancer
implements Declarable {
    public static final String SCHEDULE = "schedule";
    public static final String SIZE_THRESHOLD_PERCENT = "size-threshold-percent";
    public static final int DEFAULT_SIZE_THRESHOLD_PERCENT = 10;
    public static final String MINIMUM_SIZE = "minimum-size";
    public static final int DEFAULT_MINIMUM_SIZE = 0x6400000;
    public static final String AUTO_BALANCER_LOCK_SERVICE_NAME = "__AUTO_B";
    public static final Object AUTO_BALANCER_LOCK = "__AUTO_B_LOCK";
    private final AuditScheduler scheduler;
    private final OOBAuditor auditor;
    private final TimeProvider clock;
    private final CacheOperationFacade cacheFacade;
    private boolean initialized;
    private static final Logger logger = LogService.getLogger();

    public AutoBalancer() {
        this(null, null, null, null);
    }

    public AutoBalancer(AuditScheduler scheduler, OOBAuditor auditor, TimeProvider clock, CacheOperationFacade cacheFacade) {
        this.cacheFacade = cacheFacade == null ? new GeodeCacheFacade() : cacheFacade;
        this.scheduler = scheduler == null ? new CronScheduler() : scheduler;
        this.auditor = auditor == null ? new SizeBasedOOBAuditor(this.cacheFacade) : auditor;
        this.clock = clock == null ? new SystemClockTimeProvider() : clock;
    }

    public void initialize(Cache cache, Properties props) {
        this.cacheFacade.setCache(cache);
        this.internalInitialize(props);
    }

    @Deprecated
    public void init(Properties props) {
        this.internalInitialize(props);
    }

    private void internalInitialize(Properties props) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing " + this.getClass().getSimpleName() + " with " + String.valueOf(props));
        }
        this.auditor.init(props);
        String schedule = null;
        if (props != null) {
            schedule = props.getProperty(SCHEDULE);
        }
        this.scheduler.init(schedule);
    }

    OOBAuditor getOOBAuditor() {
        return this.auditor;
    }

    public CacheOperationFacade getCacheOperationFacade() {
        return this.cacheFacade;
    }

    public void destroy() {
        this.scheduler.destroy();
    }

    static interface AuditScheduler {
        public void init(String var1);

        public void destroy();
    }

    static interface OOBAuditor {
        public void init(Properties var1);

        public void execute();
    }

    static interface TimeProvider {
        public long currentTimeMillis();
    }

    static interface CacheOperationFacade {
        public boolean acquireAutoBalanceLock();

        public void setCache(Cache var1);

        public DistributedLockService getDLS();

        public void rebalance();

        public void incrementAttemptCounter();

        public Map<PartitionedRegion, InternalPRInfo> getRegionMemberDetails();

        public long getTotalDataSize(Map<PartitionedRegion, InternalPRInfo> var1);

        public long getTotalTransferSize();
    }

    static class GeodeCacheFacade
    implements CacheOperationFacade {
        private final AtomicBoolean isLockAcquired = new AtomicBoolean(false);
        private InternalCache cache;

        public GeodeCacheFacade() {
            this(null);
        }

        public GeodeCacheFacade(InternalCache cache) {
            this.cache = cache;
        }

        @Override
        public Map<PartitionedRegion, InternalPRInfo> getRegionMemberDetails() {
            InternalCache cache = this.getCache();
            HashMap<PartitionedRegion, InternalPRInfo> detailsMap = new HashMap<PartitionedRegion, InternalPRInfo>();
            for (PartitionedRegion region : cache.getPartitionedRegions()) {
                LoadProbe probe = cache.getInternalResourceManager().getLoadProbe();
                InternalPRInfo info = region.getRedundancyProvider().buildPartitionedRegionInfo(true, probe);
                detailsMap.put(region, info);
            }
            return detailsMap;
        }

        @Override
        public long getTotalDataSize(Map<PartitionedRegion, InternalPRInfo> details) {
            long totalSize = 0L;
            if (details != null) {
                for (PartitionedRegion region : details.keySet()) {
                    InternalPRInfo info = details.get(region);
                    Set membersInfo = info.getPartitionMemberInfo();
                    for (PartitionMemberInfo member : membersInfo) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Region:{}, Member: {}, Size: {}", (Object)region.getFullPath(), (Object)member, (Object)member.getSize());
                        }
                        totalSize += member.getSize();
                    }
                }
            }
            return totalSize;
        }

        @Override
        public long getTotalTransferSize() {
            try {
                RebalanceOperation operation = this.getCache().getResourceManager().createRebalanceFactory().simulate();
                RebalanceResults result = operation.getResults();
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalance estimate: RebalanceResultsImpl [TotalBucketCreateBytes=" + result.getTotalBucketCreateBytes() + ", TotalBucketCreatesCompleted=" + result.getTotalBucketCreatesCompleted() + ", TotalBucketTransferBytes=" + result.getTotalBucketTransferBytes() + ", TotalBucketTransfersCompleted=" + result.getTotalBucketTransfersCompleted() + ", TotalPrimaryTransfersCompleted=" + result.getTotalPrimaryTransfersCompleted() + "]");
                }
                return result.getTotalBucketTransferBytes();
            }
            catch (CancellationException e) {
                logger.info("Error while trying to estimate rebalance cost ", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.info("Error while trying to estimate rebalance cost ", (Throwable)e);
            }
            return 0L;
        }

        @Override
        public void incrementAttemptCounter() {
            InternalCache cache = this.getCache();
            try {
                cache.getInternalResourceManager().getStats().incAutoRebalanceAttempts();
            }
            catch (Exception e) {
                logger.warn("Failed to increment AutoBalanceAttempts counter");
            }
        }

        @Override
        public void rebalance() {
            try {
                RebalanceOperation operation = this.getCache().getResourceManager().createRebalanceFactory().start();
                RebalanceResults result = operation.getResults();
                logger.info("Rebalance result: [TotalBucketCreateBytes=" + result.getTotalBucketCreateBytes() + ", TotalBucketCreateTime=" + result.getTotalBucketCreateTime() + ", TotalBucketCreatesCompleted=" + result.getTotalBucketCreatesCompleted() + ", TotalBucketTransferBytes=" + result.getTotalBucketTransferBytes() + ", TotalBucketTransferTime=" + result.getTotalBucketTransferTime() + ", TotalBucketTransfersCompleted=" + result.getTotalBucketTransfersCompleted() + ", TotalPrimaryTransferTime=" + result.getTotalPrimaryTransferTime() + ", TotalPrimaryTransfersCompleted=" + result.getTotalPrimaryTransfersCompleted() + ", TotalTime=" + result.getTotalTime() + "]");
            }
            catch (CancellationException e) {
                logger.info("Error rebalancing the cluster", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.info("Error rebalancing the cluster", (Throwable)e);
            }
        }

        InternalCache getCache() {
            InternalCache result = this.cache;
            if (result == null) {
                throw new IllegalStateException("Missing cache instance.");
            }
            if (result.isClosed()) {
                throw new CacheClosedException();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acquireAutoBalanceLock() {
            if (!this.isLockAcquired.get()) {
                AtomicBoolean atomicBoolean = this.isLockAcquired;
                synchronized (atomicBoolean) {
                    if (!this.isLockAcquired.get()) {
                        DistributedLockService dls = this.getDLS();
                        boolean result = dls.lock(AUTO_BALANCER_LOCK, 0L, -1L);
                        if (result) {
                            this.isLockAcquired.set(true);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Grabbed AutoBalancer lock");
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Another member owns auto-balance lock. Skip this attempt to rebalance the cluster");
                        }
                    }
                }
            }
            return this.isLockAcquired.get();
        }

        @Override
        public DistributedLockService getDLS() {
            InternalCache cache = this.getCache();
            DistributedLockService dls = DistributedLockService.getServiceNamed((String)AutoBalancer.AUTO_BALANCER_LOCK_SERVICE_NAME);
            if (dls == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating DistributeLockService");
                }
                dls = DLockService.create((String)AutoBalancer.AUTO_BALANCER_LOCK_SERVICE_NAME, (InternalDistributedSystem)cache.getInternalDistributedSystem(), (boolean)true, (boolean)true);
            }
            return dls;
        }

        @Override
        public void setCache(Cache cache) {
            this.cache = (InternalCache)cache;
        }
    }

    private class CronScheduler
    implements AuditScheduler {
        final ScheduledExecutorService trigger = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "AutoBalancer");
            thread.setDaemon(true);
            return thread;
        });
        CronExpression generator;

        CronScheduler() {
        }

        @Override
        public void init(String schedule) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing " + this.getClass().getSimpleName() + " with " + schedule);
            }
            if (schedule == null || schedule.isEmpty()) {
                throw new GemFireConfigException("Missing configuration: schedule");
            }
            try {
                this.generator = CronExpression.parse((String)schedule);
            }
            catch (Exception e) {
                throw new GemFireConfigException("Cron expression could not be parsed: " + schedule, (Throwable)e);
            }
            this.submitNext();
        }

        private void submitNext() {
            long currentTime = AutoBalancer.this.clock.currentTimeMillis();
            Instant currentInstant = new Date(currentTime).toInstant();
            ZoneId localTimeZone = ZoneId.systemDefault();
            LocalDateTime now = currentInstant.atZone(localTimeZone).toLocalDateTime();
            LocalDateTime next = (LocalDateTime)this.generator.next((Temporal)now);
            long nextSchedule = 1000L * next.toEpochSecond(localTimeZone.getRules().getOffset(next));
            long delay = nextSchedule - currentTime;
            if (logger.isDebugEnabled()) {
                logger.debug("Now={}, next audit time={}, delay={} ms", (Object)new Date(currentTime), (Object)nextSchedule, (Object)delay);
            }
            this.trigger.schedule(() -> {
                try {
                    AutoBalancer.this.auditor.execute();
                }
                catch (CacheClosedException e) {
                    logger.warn("Cache closed while attempting to rebalance the cluster. Abort future jobs", (Throwable)e);
                    return;
                }
                catch (Exception e) {
                    logger.warn("Error while executing out-of-balance audit.", (Throwable)e);
                }
                this.submitNext();
            }, delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public void destroy() {
            this.trigger.shutdownNow();
        }
    }

    static class SizeBasedOOBAuditor
    implements OOBAuditor {
        private int sizeThreshold = 10;
        private int sizeMinimum = 0x6400000;
        final CacheOperationFacade cache;

        public SizeBasedOOBAuditor(CacheOperationFacade cache) {
            this.cache = cache;
        }

        @Override
        public void init(Properties props) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing " + this.getClass().getSimpleName());
            }
            if (props != null) {
                if (props.getProperty(AutoBalancer.SIZE_THRESHOLD_PERCENT) != null) {
                    this.sizeThreshold = Integer.parseInt(props.getProperty(AutoBalancer.SIZE_THRESHOLD_PERCENT));
                    if (this.sizeThreshold <= 0 || this.sizeThreshold >= 100) {
                        throw new GemFireConfigException("size-threshold-percent should be integer, 1 to 99");
                    }
                }
                if (props.getProperty(AutoBalancer.MINIMUM_SIZE) != null) {
                    this.sizeMinimum = Integer.parseInt(props.getProperty(AutoBalancer.MINIMUM_SIZE));
                    if (this.sizeMinimum <= 0) {
                        throw new GemFireConfigException("minimum-size should be greater than 0");
                    }
                }
            }
        }

        @Override
        public void execute() {
            boolean result = this.cache.acquireAutoBalanceLock();
            if (!result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Another member owns auto-balance lock. Skip this attempt to rebalance the cluster");
                }
                return;
            }
            this.cache.incrementAttemptCounter();
            result = this.needsRebalancing();
            if (!result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing is not needed");
                }
                return;
            }
            this.cache.rebalance();
        }

        boolean needsRebalancing() {
            long transferSize = this.cache.getTotalTransferSize();
            if (transferSize <= (long)this.sizeMinimum) {
                return false;
            }
            Map<PartitionedRegion, InternalPRInfo> details = this.cache.getRegionMemberDetails();
            long totalSize = this.cache.getTotalDataSize(details);
            if (totalSize > 0L) {
                int transferPercent = (int)(100.0 * (double)transferSize / (double)totalSize);
                return transferPercent >= this.sizeThreshold;
            }
            return false;
        }

        int getSizeThreshold() {
            return this.sizeThreshold;
        }

        public long getSizeMinimum() {
            return this.sizeMinimum;
        }
    }

    private static class SystemClockTimeProvider
    implements TimeProvider {
        private SystemClockTimeProvider() {
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

