/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.IClusterUpdater;
import org.apache.geode.tools.pulse.internal.data.JmxManagerFinder;
import org.apache.geode.tools.pulse.internal.data.PulseConstants;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JMXDataUpdater
implements IClusterUpdater,
NotificationListener {
    private static final Logger logger = LogManager.getLogger();
    private final ResourceBundle resourceBundle = Repository.get().getResourceBundle();
    private JMXConnector conn = null;
    private MBeanServerConnection mbs = null;
    private final String serverName;
    private final String port;
    private Boolean isAddedNotiListner = false;
    private final Cluster cluster;
    private ObjectName MBEAN_OBJECT_NAME_SYSTEM_DISTRIBUTED;
    private ObjectName MBEAN_OBJECT_NAME_REGION_DISTRIBUTED;
    private ObjectName MBEAN_OBJECT_NAME_MEMBER;
    private ObjectName MBEAN_OBJECT_NAME_MEMBER_MANAGER;
    private ObjectName MBEAN_OBJECT_NAME_STATEMENT_DISTRIBUTED;
    private Set<ObjectName> systemMBeans = null;
    private final String[] opSignature = new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName()};
    private final ObjectMapper mapper = new ObjectMapper();

    public JMXDataUpdater(String server, String port, Cluster cluster) {
        this.serverName = server;
        this.port = port;
        this.cluster = cluster;
        try {
            this.MBEAN_OBJECT_NAME_SYSTEM_DISTRIBUTED = new ObjectName("GemFire:service=System,type=Distributed");
            this.MBEAN_OBJECT_NAME_REGION_DISTRIBUTED = new ObjectName("GemFire:service=Region,type=Distributed,*");
            this.MBEAN_OBJECT_NAME_MEMBER_MANAGER = new ObjectName("GemFire:service=Manager,type=Member,*");
            this.MBEAN_OBJECT_NAME_MEMBER = new ObjectName("GemFire:type=Member,*");
            this.MBEAN_OBJECT_NAME_STATEMENT_DISTRIBUTED = new ObjectName("GemFireXD:service=Statement,type=Aggregate,*");
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            logger.fatal((Object)e);
        }
    }

    private JmxManagerFinder.JmxManagerInfo getManagerInfoFromLocator(Repository repository) {
        try {
            String locatorHost = repository.getHost();
            int locatorPort = Integer.parseInt(repository.getPort());
            logger.info("{}={} & {}={}", (Object)this.resourceBundle.getString("LOG_MSG_HOST"), (Object)locatorHost, (Object)this.resourceBundle.getString("LOG_MSG_PORT"), (Object)locatorPort);
            InetAddress inetAddr = InetAddress.getByName(locatorHost);
            if (inetAddr instanceof Inet4Address || inetAddr instanceof Inet6Address) {
                if (inetAddr instanceof Inet4Address) {
                    logger.info("{}: {}", (Object)this.resourceBundle.getString("LOG_MSG_LOCATOR_IPV4_ADDRESS"), (Object)inetAddr);
                } else {
                    logger.info("{}: {}", (Object)this.resourceBundle.getString("LOG_MSG_LOCATOR_IPV6_ADDRESS"), (Object)inetAddr);
                }
                JmxManagerFinder.JmxManagerInfo jmxManagerInfo = JmxManagerFinder.askLocatorForJmxManager(inetAddr, locatorPort, 15000, repository.isUseSSLLocator());
                if (jmxManagerInfo.port == 0) {
                    logger.info(this.resourceBundle.getString("LOG_MSG_LOCATOR_COULD_NOT_FIND_MANAGER"));
                }
                return jmxManagerInfo;
            }
            logger.info(this.resourceBundle.getString("LOG_MSG_LOCATOR_BAD_ADDRESS"));
            this.cluster.setConnectionErrorMsg(this.resourceBundle.getString("LOG_MSG_JMX_CONNECTION_BAD_ADDRESS"));
            this.cluster.setConnectionErrorMsg(this.resourceBundle.getString("LOG_MSG_JMX_CONNECTION_BAD_ADDRESS"));
            return null;
        }
        catch (IOException e) {
            StringWriter swBuffer = new StringWriter();
            PrintWriter prtWriter = new PrintWriter(swBuffer);
            e.printStackTrace(prtWriter);
            logger.fatal("Exception Details : {}\n", (Object)swBuffer);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMXConnector connect(String username, String password) {
        block13: {
            Repository repository = Repository.get();
            try {
                String jmxSerURL = "";
                logger.info("{}:{}", (Object)this.resourceBundle.getString("LOG_MSG_USE_LOCATOR_VALUE"), (Object)repository.getJmxUseLocator());
                if (repository.getJmxUseLocator().booleanValue()) {
                    JmxManagerFinder.JmxManagerInfo jmxManagerInfo = this.getManagerInfoFromLocator(repository);
                    if (jmxManagerInfo.port == 0) {
                        logger.info(this.resourceBundle.getString("LOG_MSG_LOCATOR_COULD_NOT_FIND_MANAGER"));
                    } else {
                        logger.info("{}: {}={} & {}={}, {}", (Object)this.resourceBundle.getString("LOG_MSG_LOCATOR_FOUND_MANAGER"), (Object)this.resourceBundle.getString("LOG_MSG_HOST"), (Object)jmxManagerInfo.host, (Object)this.resourceBundle.getString("LOG_MSG_PORT"), (Object)jmxManagerInfo.port, (Object)(jmxManagerInfo.ssl ? this.resourceBundle.getString("LOG_MSG_WITH_SSL") : this.resourceBundle.getString("LOG_MSG_WITHOUT_SSL")));
                        jmxSerURL = this.formJMXServiceURLString(jmxManagerInfo.host, String.valueOf(jmxManagerInfo.port));
                    }
                } else {
                    logger.info("{}={} & {}={}", (Object)this.resourceBundle.getString("LOG_MSG_HOST"), (Object)this.serverName, (Object)this.resourceBundle.getString("LOG_MSG_PORT"), (Object)this.port);
                    jmxSerURL = this.formJMXServiceURLString(this.serverName, this.port);
                }
                if (!StringUtils.isNotBlank((CharSequence)jmxSerURL)) break block13;
                JMXServiceURL url = new JMXServiceURL(jmxSerURL);
                String[] creds = new String[]{username, password};
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("jmx.remote.credentials", creds);
                Properties originalProperties = System.getProperties();
                try {
                    Properties updatedProperties = new Properties(originalProperties);
                    if (repository.isUseSSLManager()) {
                        for (String sslProperty : repository.getJavaSslProperties().stringPropertyNames()) {
                            updatedProperties.setProperty(sslProperty, repository.getJavaSslProperties().getProperty(sslProperty));
                        }
                        System.setProperties(updatedProperties);
                        env.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
                    }
                    logger.info("Connecting to jmxURL : {}", (Object)jmxSerURL);
                    this.conn = JMXConnectorFactory.connect(url, env);
                    this.mbs = this.conn.getMBeanServerConnection();
                    this.cluster.setConnectedFlag(true);
                }
                finally {
                    System.setProperties(originalProperties);
                }
            }
            catch (Exception e) {
                this.cluster.setConnectedFlag(false);
                this.cluster.setConnectionErrorMsg(e.getMessage());
                logger.fatal(e.getMessage(), (Throwable)e);
                if (this.conn == null) break block13;
                try {
                    this.conn.close();
                }
                catch (Exception e1) {
                    logger.fatal(e1.getMessage(), (Throwable)e1);
                }
                this.conn = null;
            }
        }
        return this.conn;
    }

    private String formJMXServiceURLString(String host, String port) throws UnknownHostException {
        String jmxSerURL = "";
        if (host.equalsIgnoreCase("localhost")) {
            jmxSerURL = "service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + port + "/jmxrmi";
        } else {
            InetAddress inetAddr = InetAddress.getByName(host);
            if (inetAddr instanceof Inet4Address) {
                jmxSerURL = "service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + port + "/jmxrmi";
            } else if (inetAddr instanceof Inet6Address) {
                jmxSerURL = "service:jmx:rmi://[" + host + "]/jndi/rmi://[" + host + "]:" + port + "/jmxrmi";
            }
        }
        return jmxSerURL;
    }

    @Override
    public boolean updateData() {
        try {
            String service;
            if (this.conn == null) {
                return false;
            }
            this.cluster.getDeletedMembers().clear();
            for (Map.Entry<String, Cluster.Member> entry : this.cluster.getMembersHMap().entrySet()) {
                this.cluster.getDeletedMembers().add(entry.getKey());
            }
            this.cluster.getDeletedRegions().clear();
            for (Cluster.Region region : this.cluster.getClusterRegions().values()) {
                this.cluster.getDeletedRegions().add(region.getFullPath());
            }
            this.systemMBeans = this.mbs.queryNames(this.MBEAN_OBJECT_NAME_SYSTEM_DISTRIBUTED, null);
            for (ObjectName objectName : this.systemMBeans) {
                this.updateClusterSystem(objectName);
            }
            Set<ObjectName> regionMBeans = this.mbs.queryNames(this.MBEAN_OBJECT_NAME_REGION_DISTRIBUTED, null);
            for (ObjectName regMBean : regionMBeans) {
                this.updateClusterRegion(regMBean);
            }
            Iterator<String> iterator = this.cluster.getDeletedRegions().iterator();
            while (iterator.hasNext()) {
                this.cluster.removeClusterRegion(iterator.next());
            }
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            ArrayList<ObjectName> nonServiceMBeans = new ArrayList<ObjectName>();
            Set<ObjectName> memberMBeans = this.mbs.queryNames(this.MBEAN_OBJECT_NAME_MEMBER, null);
            for (ObjectName mBean : memberMBeans) {
                service = mBean.getKeyProperty("service");
                if (service == null) {
                    nonServiceMBeans.add(mBean);
                    continue;
                }
                arrayList.add(mBean);
            }
            for (ObjectName mBean : nonServiceMBeans) {
                this.updateClusterMember(mBean);
            }
            for (ObjectName serviceMBean : arrayList) {
                switch (service = serviceMBean.getKeyProperty("service")) {
                    case "Region": {
                        this.updateMemberRegion(serviceMBean);
                        break;
                    }
                    case "CacheServer": {
                        this.updateMemberClient(serviceMBean);
                        break;
                    }
                    case "GatewayReceiver": {
                        this.updateGatewayReceiver(serviceMBean);
                        break;
                    }
                    case "GatewaySender": {
                        this.updateGatewaySender(serviceMBean);
                        break;
                    }
                    case "AsyncEventQueue": {
                        this.updateAsyncEventQueue(serviceMBean);
                        break;
                    }
                    case "Locator": {
                        this.updateClusterMember(serviceMBean);
                    }
                }
            }
            Set<ObjectName> statementObjectNames = this.mbs.queryNames(this.MBEAN_OBJECT_NAME_STATEMENT_DISTRIBUTED, null);
            for (ObjectName stmtObjectName : statementObjectNames) {
                this.updateClusterStatement(stmtObjectName);
            }
        }
        catch (IOException ioe) {
            logger.fatal(ioe.getMessage(), (Throwable)ioe);
            this.mbs = null;
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (IOException iOException) {
                    logger.fatal(iOException.getMessage(), (Throwable)iOException);
                }
                this.conn = null;
            }
            return false;
        }
        for (String string : this.cluster.getDeletedMembers()) {
            if (!this.cluster.getMembersHMap().containsKey(string)) continue;
            Cluster.Member member = this.cluster.getMembersHMap().get(string);
            List<Cluster.Member> memberArrList = this.cluster.getPhysicalToMember().get(member.getHost());
            if (memberArrList != null && memberArrList.contains(member)) {
                String host = member.getHost();
                this.cluster.getPhysicalToMember().get(member.getHost()).remove(member);
                if (this.cluster.getPhysicalToMember().get(member.getHost()).size() == 0) {
                    this.cluster.getPhysicalToMember().remove(host);
                }
            }
            this.cluster.getMembersHMap().remove(string);
        }
        return true;
    }

    private void updateClusterSystem(ObjectName mbeanName) throws IOException {
        try {
            if (!this.isAddedNotiListner.booleanValue()) {
                this.mbs.addNotificationListener(mbeanName, this, null, new Object());
                this.isAddedNotiListner = true;
            }
            String[] serverCnt = (String[])this.mbs.invoke(mbeanName, "listServers", null, null);
            this.cluster.setServerCount(serverCnt.length);
            TabularData table = (TabularData)this.mbs.invoke(mbeanName, "viewRemoteClusterStatus", null, null);
            Collection<?> rows = table.values();
            this.cluster.getWanInformationObject().clear();
            for (CompositeData row : rows) {
                Object key = row.get("key");
                Object value = row.get("value");
                this.cluster.getWanInformationObject().put((String)key, (Boolean)value);
            }
            AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.CLUSTER_MBEAN_ATTRIBUTES);
            block59: for (int i = 0; i < attributeList.size(); ++i) {
                String name;
                Attribute attribute = (Attribute)attributeList.get(i);
                switch (name = attribute.getName()) {
                    case "MemberCount": {
                        this.cluster.setMemberCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "NumClients": {
                        this.cluster.setClientConnectionCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()).intValue());
                        continue block59;
                    }
                    case "DistributedSystemId": {
                        this.cluster.setClusterId(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "LocatorCount": {
                        this.cluster.setLocatorCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "NumRunningFunctions": {
                        try {
                            this.cluster.setRunningFunctionCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        }
                        catch (Exception e) {
                            this.cluster.setRunningFunctionCount(0);
                        }
                        continue block59;
                    }
                    case "RegisteredCQCount": {
                        this.cluster.setRegisteredCQCount(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "NumSubscriptions": {
                        this.cluster.setSubscriptionCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "TransactionCommitted": {
                        this.cluster.setTxnCommittedCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "TransactionRolledBack": {
                        this.cluster.setTxnRollbackCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "TotalHeapSize": {
                        this.cluster.setTotalHeapSize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "UsedHeapSize": {
                        try {
                            this.cluster.setUsedHeapSize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        }
                        catch (Exception e) {
                            this.cluster.setUsedHeapSize(0L);
                            continue block59;
                        }
                        this.cluster.getMemoryUsageTrend().add((Object)this.cluster.getUsedHeapSize());
                        continue block59;
                    }
                    case "TotalRegionEntryCount": {
                        this.cluster.setTotalRegionEntryCount(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "CurrentQueryCount": {
                        this.cluster.setCurrentQueryCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block59;
                    }
                    case "TotalDiskUsage": {
                        try {
                            this.cluster.setTotalBytesOnDisk(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        }
                        catch (Exception e) {
                            this.cluster.setTotalBytesOnDisk(0L);
                            continue block59;
                        }
                        this.cluster.getTotalBytesOnDiskTrend().add((Object)this.cluster.getTotalBytesOnDisk());
                        continue block59;
                    }
                    case "DiskWritesRate": {
                        this.cluster.setDiskWritesRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        this.cluster.getThroughoutWritesTrend().add((Object)this.cluster.getDiskWritesRate());
                        continue block59;
                    }
                    case "AverageWrites": {
                        try {
                            this.cluster.setWritePerSec(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        }
                        catch (Exception e) {
                            this.cluster.setWritePerSec(0.0);
                            continue block59;
                        }
                        this.cluster.getWritePerSecTrend().add((Object)this.cluster.getWritePerSec());
                        continue block59;
                    }
                    case "AverageReads": {
                        try {
                            this.cluster.setReadPerSec(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        }
                        catch (Exception e) {
                            this.cluster.setReadPerSec(0.0);
                            continue block59;
                        }
                        this.cluster.getReadPerSecTrend().add((Object)this.cluster.getReadPerSec());
                        continue block59;
                    }
                    case "QueryRequestRate": {
                        this.cluster.setQueriesPerSec(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        this.cluster.getQueriesPerSecTrend().add((Object)this.cluster.getQueriesPerSec());
                        continue block59;
                    }
                    case "DiskReadsRate": {
                        this.cluster.setDiskReadsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        this.cluster.getThroughoutReadsTrend().add((Object)this.cluster.getDiskReadsRate());
                        continue block59;
                    }
                    case "JVMPauses": {
                        long trendVal = this.determineCurrentJVMPauses("cluster", "", this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        this.cluster.setGarbageCollectionCount(trendVal);
                        this.cluster.getGarbageCollectionTrend().add((Object)this.cluster.getGarbageCollectionCount());
                        continue block59;
                    }
                    case "TotalRegionCount": {
                        this.cluster.setTotalRegionCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    }
                }
            }
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private Cluster.GatewayReceiver initGatewayReceiver(ObjectName mbeanName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, AttributeNotFoundException, MBeanException {
        Cluster.GatewayReceiver gatewayReceiver = new Cluster.GatewayReceiver();
        AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.GATEWAY_MBEAN_ATTRIBUTES);
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            if (attribute.getName().equals("Port")) {
                gatewayReceiver.setListeningPort(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                continue;
            }
            if (attribute.getName().equals("EventsReceivedRate")) {
                gatewayReceiver.setLinkThroughput(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                continue;
            }
            if (attribute.getName().equals("AverageBatchProcessingTime")) {
                gatewayReceiver.setAvgBatchProcessingTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                continue;
            }
            if (!attribute.getName().equals("Running")) continue;
            gatewayReceiver.setStatus(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
        }
        return gatewayReceiver;
    }

    private Cluster.GatewaySender initGatewaySender(ObjectName mbeanName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, AttributeNotFoundException, MBeanException {
        Cluster.GatewaySender gatewaySender = new Cluster.GatewaySender();
        AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.GATEWAYSENDER_MBEAN_ATTRIBUTES);
        block24: for (int i = 0; i < attributeList.size(); ++i) {
            String name;
            Attribute attribute = (Attribute)attributeList.get(i);
            switch (name = attribute.getName()) {
                case "EventsReceivedRate": {
                    gatewaySender.setLinkThroughput(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "BatchSize": {
                    gatewaySender.setBatchSize(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "SenderId": {
                    gatewaySender.setId(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "EventQueueSize": {
                    gatewaySender.setQueueSize(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "Running": {
                    gatewaySender.setStatus(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "Primary": {
                    gatewaySender.setPrimary(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "PersistenceEnabled": {
                    gatewaySender.setPersistenceEnabled(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "Parallel": {
                    gatewaySender.setSenderType(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "RemoteDSId": {
                    gatewaySender.setRemoteDSId(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block24;
                }
                case "EventsExceedingAlertThreshold": {
                    gatewaySender.setEventsExceedingAlertThreshold(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                }
            }
        }
        return gatewaySender;
    }

    private void updateGatewaySender(ObjectName mbeanName) throws IOException {
        try {
            String memberName = mbeanName.getKeyProperty("member");
            if (this.cluster.getMembersHMap().containsKey(memberName)) {
                Cluster.Member existingMember = this.cluster.getMembersHMap().get(memberName);
                Cluster.GatewaySender gatewaySender = this.initGatewaySender(mbeanName);
                Iterator<Cluster.GatewaySender> it = existingMember.getGatewaySenderList().iterator();
                while (it.hasNext()) {
                    Cluster.GatewaySender exisGatewaySender = it.next();
                    if (!exisGatewaySender.getId().equals(gatewaySender.getId())) continue;
                    it.remove();
                    break;
                }
                existingMember.getGatewaySenderList().add(gatewaySender);
            } else {
                Cluster.Member member = new Cluster.Member();
                member.setName(memberName);
                member.setId(memberName);
                Cluster.GatewaySender gatewaySender = this.initGatewaySender(mbeanName);
                member.getGatewaySenderList().add(gatewaySender);
                this.cluster.getMembersHMap().put(memberName, member);
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | IntrospectionException | MBeanException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private Cluster.AsyncEventQueue initAsyncEventQueue(ObjectName mbeanName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, AttributeNotFoundException, MBeanException {
        Cluster.AsyncEventQueue asyncEventQueue = new Cluster.AsyncEventQueue();
        AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.ASYNC_EVENT_QUEUE_MBEAN_ATTRIBUTES);
        block20: for (int i = 0; i < attributeList.size(); ++i) {
            String name;
            Attribute attribute = (Attribute)attributeList.get(i);
            switch (name = attribute.getName()) {
                case "Id": {
                    asyncEventQueue.setId(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "AsyncEventListener": {
                    asyncEventQueue.setAsyncEventListener(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "BatchConflationEnabled": {
                    asyncEventQueue.setBatchConflationEnabled(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "BatchTimeInterval": {
                    asyncEventQueue.setBatchTimeInterval(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "BatchSize": {
                    asyncEventQueue.setBatchSize(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "EventQueueSize": {
                    asyncEventQueue.setEventQueueSize(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "Parallel": {
                    asyncEventQueue.setParallel(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block20;
                }
                case "Primary": {
                    asyncEventQueue.setPrimary(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                }
            }
        }
        return asyncEventQueue;
    }

    private void updateAsyncEventQueue(ObjectName mbeanName) throws IOException {
        try {
            String memberName = mbeanName.getKeyProperty("member");
            if (this.cluster.getMembersHMap().containsKey(memberName)) {
                Cluster.Member existingMember = this.cluster.getMembersHMap().get(memberName);
                Cluster.AsyncEventQueue asyncQ = this.initAsyncEventQueue(mbeanName);
                Iterator<Cluster.AsyncEventQueue> it = existingMember.getAsyncEventQueueList().iterator();
                while (it.hasNext()) {
                    Cluster.AsyncEventQueue exisAsyncEventQueue = it.next();
                    if (!exisAsyncEventQueue.getId().equals(asyncQ.getId())) continue;
                    it.remove();
                    break;
                }
                existingMember.getAsyncEventQueueList().add(asyncQ);
            } else {
                Cluster.Member member = new Cluster.Member();
                member.setName(memberName);
                member.setId(memberName);
                Cluster.AsyncEventQueue asyncQ = this.initAsyncEventQueue(mbeanName);
                member.getAsyncEventQueueList().add(asyncQ);
                this.cluster.getMembersHMap().put(memberName, member);
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | IntrospectionException | MBeanException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private void updateGatewayReceiver(ObjectName mbeanName) throws IOException {
        try {
            String memberName = mbeanName.getKeyProperty("member");
            if (this.cluster.getMembersHMap().containsKey(memberName)) {
                Cluster.Member existingMember = this.cluster.getMembersHMap().get(memberName);
                Cluster.GatewayReceiver gatewayReceiver = this.initGatewayReceiver(mbeanName);
                existingMember.setGatewayReceiver(gatewayReceiver);
            } else {
                Cluster.Member member = new Cluster.Member();
                member.setName(memberName);
                member.setId(memberName);
                Cluster.GatewayReceiver gatewayReceiver = this.initGatewayReceiver(mbeanName);
                member.setGatewayReceiver(gatewayReceiver);
                this.cluster.getMembersHMap().put(memberName, member);
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | IntrospectionException | MBeanException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private void updateMemberClient(ObjectName mbeanName) throws IOException {
        try {
            String memberName = mbeanName.getKeyProperty("member");
            if (this.cluster.getMembersHMap().containsKey(memberName)) {
                CompositeData[] compositeData;
                Cluster.Member existingMember = this.cluster.getMembersHMap().get(memberName);
                HashMap<String, Cluster.Client> memberClientsHM = new HashMap<String, Cluster.Client>();
                existingMember.setMemberPort("" + this.mbs.getAttribute(mbeanName, "Port"));
                this.mbs.getAttribute(mbeanName, "HostNameForClients");
                existingMember.setHostnameForClients((String)this.mbs.getAttribute(mbeanName, "HostNameForClients"));
                existingMember.setBindAddress((String)this.mbs.getAttribute(mbeanName, "BindAddress"));
                for (CompositeData cmd : compositeData = (CompositeData[])this.mbs.invoke(mbeanName, "showAllClientStats", null, null)) {
                    Cluster.Client client = new Cluster.Client();
                    if (cmd.containsKey("clientId")) {
                        client.setId((String)cmd.get("clientId"));
                    }
                    if (cmd.containsKey("name")) {
                        client.setName((String)cmd.get("name"));
                    }
                    if (cmd.containsKey("hostName")) {
                        client.setHost((String)cmd.get("hostName"));
                    }
                    if (cmd.containsKey("queueSize")) {
                        client.setQueueSize((Integer)cmd.get("queueSize"));
                    }
                    if (cmd.containsKey("processCpuTime")) {
                        client.setProcessCpuTime((Long)cmd.get("processCpuTime"));
                    }
                    if (cmd.containsKey("upTime")) {
                        client.setUptime((Long)cmd.get("upTime"));
                    }
                    if (cmd.containsKey("numOfThreads")) {
                        client.setThreads((Integer)cmd.get("numOfThreads"));
                    }
                    if (cmd.containsKey("numOfGets")) {
                        client.setGets((Integer)cmd.get("numOfGets"));
                    }
                    if (cmd.containsKey("numOfPuts")) {
                        client.setPuts((Integer)cmd.get("numOfPuts"));
                    }
                    if (cmd.containsKey("cpus")) {
                        client.setCpus((Integer)cmd.get("cpus"));
                    }
                    if (cmd.containsKey("cpus")) {
                        client.setCpuUsage(0.0);
                    }
                    if (cmd.containsKey("connected")) {
                        client.setConnected((Boolean)cmd.get("connected"));
                    }
                    if (cmd.containsKey("clientCQCount")) {
                        client.setClientCQCount((Integer)cmd.get("clientCQCount"));
                    }
                    if (cmd.containsKey("subscriptionEnabled")) {
                        client.setSubscriptionEnabled((Boolean)cmd.get("subscriptionEnabled"));
                    }
                    memberClientsHM.put(client.getId(), client);
                }
                existingMember.updateMemberClientsHMap(memberClientsHM);
            }
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private void updateRegionOnMembers(String regionObjectName, String regionFullPath, Cluster.Region region) throws IOException {
        try {
            List<String> memberNamesTemp = region.getMemberName();
            ArrayList<String> memberNames = new ArrayList<String>(memberNamesTemp);
            ArrayList<Object> regionOnMemberList = new ArrayList();
            ArrayList<Cluster.RegionOnMember> regionOnMemberListNew = new ArrayList<Cluster.RegionOnMember>();
            Cluster.RegionOnMember[] regionOnMemberNames = region.getRegionOnMembers();
            if (regionOnMemberNames != null && regionOnMemberNames.length > 0) {
                regionOnMemberList = new ArrayList<Cluster.RegionOnMember>(Arrays.asList(regionOnMemberNames));
            }
            logger.debug("updateRegionOnMembers : # regionOnMembers objects in region = {}", (Object)regionOnMemberList.size());
            block38: for (Cluster.RegionOnMember regionOnMember : regionOnMemberList) {
                for (String memberName : memberNames) {
                    if (!regionOnMember.getMemberName().equals(memberName)) continue;
                    regionOnMemberListNew.add(regionOnMember);
                    logger.debug("updateRegionOnMembers : Processing existing Member name = {}", (Object)regionOnMember.getMemberName());
                    String objectNameROM = "GemFire:service=Region,name=" + regionObjectName + ",type=Member,member=" + regionOnMember.getMemberName();
                    ObjectName regionOnMemberMBean = new ObjectName(objectNameROM);
                    logger.debug("updateRegionOnMembers : Object name = {}", (Object)regionOnMemberMBean.getCanonicalName());
                    AttributeList attributeList = this.mbs.getAttributes(regionOnMemberMBean, PulseConstants.REGION_ON_MEMBER_MBEAN_ATTRIBUTES);
                    block40: for (int i = 0; i < attributeList.size(); ++i) {
                        String name;
                        Attribute attribute = (Attribute)attributeList.get(i);
                        switch (name = attribute.getName()) {
                            case "EntrySize": {
                                regionOnMember.setEntrySize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getEntrySize() = {}", (Object)regionOnMember.getEntrySize());
                                continue block40;
                            }
                            case "EntryCount": {
                                regionOnMember.setEntryCount(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getEntryCount() = {}", (Object)regionOnMember.getEntryCount());
                                continue block40;
                            }
                            case "PutsRate": {
                                regionOnMember.setPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getPutsRate() = {}", (Object)regionOnMember.getPutsRate());
                                continue block40;
                            }
                            case "GetsRate": {
                                regionOnMember.setGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getGetsRate() = {}", (Object)regionOnMember.getGetsRate());
                                continue block40;
                            }
                            case "DiskReadsRate": {
                                regionOnMember.setDiskGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getDiskGetsRate() = {}", (Object)regionOnMember.getDiskGetsRate());
                                continue block40;
                            }
                            case "DiskWritesRate": {
                                regionOnMember.setDiskPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getDiskPutsRate() = {}", (Object)regionOnMember.getDiskPutsRate());
                                continue block40;
                            }
                            case "LocalMaxMemory": {
                                regionOnMember.setLocalMaxMemory(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                                logger.debug("updateRegionOnMembers : anRom.getLocalMaxMemory() = {}", (Object)regionOnMember.getLocalMaxMemory());
                            }
                        }
                    }
                    regionOnMember.getGetsPerSecTrend().add((Object)regionOnMember.getGetsRate());
                    regionOnMember.getPutsPerSecTrend().add((Object)regionOnMember.getPutsRate());
                    regionOnMember.getDiskReadsPerSecTrend().add((Object)regionOnMember.getDiskGetsRate());
                    regionOnMember.getDiskWritesPerSecTrend().add((Object)regionOnMember.getDiskPutsRate());
                    logger.debug("updateRegionOnMembers : Existing member on region : getGetsRate() = {}, getPutsRate() = {}, getDiskGetsRate() = {}, getDiskPutsRate() = {}", (Object)regionOnMember.getGetsPerSecTrend().size(), (Object)regionOnMember.getPutsPerSecTrend().size(), (Object)regionOnMember.getDiskReadsPerSecTrend().size(), (Object)regionOnMember.getDiskWritesPerSecTrend().size());
                    memberNames.remove(regionOnMember.getMemberName());
                    continue block38;
                }
            }
            logger.debug("updateRegionOnMembers : Loop over remaining member names and adding new member in region. Existing count = {}", (Object)regionOnMemberList.size());
            logger.debug("updateRegionOnMembers : Remaining new members in this region = {}", (Object)memberNames.size());
            for (String string : memberNames) {
                String objectNameROM = "GemFire:service=Region,name=" + regionObjectName + ",type=Member,member=" + string;
                ObjectName regionOnMemberMBean = new ObjectName(objectNameROM);
                Cluster.RegionOnMember regionOnMember = new Cluster.RegionOnMember();
                regionOnMember.setMemberName(string);
                regionOnMember.setRegionFullPath(regionFullPath);
                AttributeList attributeList = this.mbs.getAttributes(regionOnMemberMBean, PulseConstants.REGION_ON_MEMBER_MBEAN_ATTRIBUTES);
                block42: for (int i = 0; i < attributeList.size(); ++i) {
                    String name;
                    Attribute attribute = (Attribute)attributeList.get(i);
                    switch (name = attribute.getName()) {
                        case "EntrySize": {
                            regionOnMember.setEntrySize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                            continue block42;
                        }
                        case "EntryCount": {
                            regionOnMember.setEntryCount(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                            continue block42;
                        }
                        case "PutsRate": {
                            regionOnMember.setPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                            continue block42;
                        }
                        case "GetsRate": {
                            regionOnMember.setGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                            continue block42;
                        }
                        case "DiskReadsRate": {
                            regionOnMember.setDiskGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                            continue block42;
                        }
                        case "DiskWritesRate": {
                            regionOnMember.setDiskPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                            continue block42;
                        }
                        case "LocalMaxMemory": {
                            regionOnMember.setLocalMaxMemory(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        }
                    }
                }
                regionOnMember.getGetsPerSecTrend().add((Object)regionOnMember.getGetsRate());
                regionOnMember.getPutsPerSecTrend().add((Object)regionOnMember.getPutsRate());
                regionOnMember.getDiskReadsPerSecTrend().add((Object)regionOnMember.getDiskGetsRate());
                regionOnMember.getDiskWritesPerSecTrend().add((Object)regionOnMember.getDiskPutsRate());
                logger.debug("updateRegionOnMembers : Adding New member on region : getGetsRate() = {}, getPutsRate() = {}, getDiskGetsRate() = {}, getDiskPutsRate() = {}", (Object)regionOnMember.getGetsRate(), (Object)regionOnMember.getPutsRate(), (Object)regionOnMember.getDiskGetsRate(), (Object)regionOnMember.getDiskPutsRate());
                regionOnMemberListNew.add(regionOnMember);
            }
            region.setRegionOnMembers(regionOnMemberListNew);
            logger.debug("updateRegionOnMembers : Total regions on member in region after update = {}", (Object)region.getFullPath(), (Object)region.getRegionOnMembers().length);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException | ReflectionException e) {
            logger.warn((Object)e);
        }
    }

    private void updateClusterRegion(ObjectName mbeanName) throws IOException {
        try {
            Cluster.Region region;
            AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.REGION_MBEAN_ATTRIBUTES);
            String regionObjectName = mbeanName.getKeyProperty("name");
            String regionFullPath = null;
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                if (!attribute.getName().equals("FullPath")) continue;
                regionFullPath = this.getStringAttribute(attribute.getValue(), attribute.getName());
                break;
            }
            if (null == (region = this.cluster.getClusterRegions().get(regionFullPath))) {
                region = new Cluster.Region();
            }
            block39: for (int i = 0; i < attributeList.size(); ++i) {
                String name;
                Attribute attribute = (Attribute)attributeList.get(i);
                switch (name = attribute.getName()) {
                    case "Members": {
                        String[] memName = (String[])attribute.getValue();
                        region.getMemberName().clear();
                        for (int k = 0; k < memName.length; ++k) {
                            region.getMemberName().add(memName[k]);
                        }
                        continue block39;
                    }
                    case "FullPath": {
                        region.setFullPath(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "DiskReadsRate": {
                        region.setDiskReadsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "DiskWritesRate": {
                        region.setDiskWritesRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "EmptyNodes": {
                        region.setEmptyNode(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "GetsRate": {
                        region.setGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "LruEvictionRate": {
                        region.setLruEvictionRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "PutsRate": {
                        region.setPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "RegionType": {
                        region.setRegionType(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "EntrySize": {
                        region.setEntrySize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "SystemRegionEntryCount": {
                        region.setSystemRegionEntryCount(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "MemberCount": {
                        region.setMemberCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "PersistentEnabled": {
                        region.setPersistentEnabled(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "Name": {
                        region.setName(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "GatewayEnabled": {
                        region.setWanEnabled(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                        continue block39;
                    }
                    case "DiskUsage": {
                        region.setDiskUsage(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    }
                }
            }
            this.updateRegionOnMembers(regionObjectName, regionFullPath, region);
            this.cluster.addClusterRegion(regionFullPath, region);
            this.cluster.getDeletedRegions().remove(region.getFullPath());
            region.getPutsPerSecTrend().add((Object)region.getPutsRate());
            region.getGetsPerSecTrend().add((Object)region.getGetsRate());
            region.getDiskReadsPerSecTrend().add((Object)region.getDiskReadsRate());
            region.getDiskWritesPerSecTrend().add((Object)region.getDiskWritesRate());
        }
        catch (InstanceNotFoundException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private static boolean isQuoted(String value) {
        int len = value.length();
        return len >= 2 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"';
    }

    private void updateClusterStatement(ObjectName mbeanName) throws IOException {
        try {
            Cluster.Statement statement;
            AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.STATEMENT_MBEAN_ATTRIBUTES);
            String statementDefinition = mbeanName.getKeyProperty("name");
            if (JMXDataUpdater.isQuoted(statementDefinition)) {
                statementDefinition = ObjectName.unquote(statementDefinition);
            }
            if (null == (statement = this.cluster.getClusterStatements().get(statementDefinition))) {
                statement = new Cluster.Statement();
                statement.setQueryDefinition(statementDefinition);
            }
            block44: for (int i = 0; i < attributeList.size(); ++i) {
                String name;
                Attribute attribute = (Attribute)attributeList.get(i);
                switch (name = attribute.getName()) {
                    case "NumTimesCompiled": {
                        statement.setNumTimesCompiled(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "NumExecution": {
                        statement.setNumExecution(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "NumExecutionsInProgress": {
                        statement.setNumExecutionsInProgress(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "NumTimesGlobalIndexLookup": {
                        statement.setNumTimesGlobalIndexLookup(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "NumRowsModified": {
                        statement.setNumRowsModified(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "ParseTime": {
                        statement.setParseTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "BindTime": {
                        statement.setBindTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "OptimizeTime": {
                        statement.setOptimizeTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "RoutingInfoTime": {
                        statement.setRoutingInfoTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "GenerateTime": {
                        statement.setGenerateTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "TotalCompilationTime": {
                        statement.setTotalCompilationTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "ExecutionTime": {
                        statement.setExecutionTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "ProjectionTime": {
                        statement.setProjectionTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "TotalExecutionTime": {
                        statement.setTotalExecutionTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "RowsModificationTime": {
                        statement.setRowsModificationTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "QNNumRowsSeen": {
                        statement.setqNNumRowsSeen(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "QNMsgSendTime": {
                        statement.setqNMsgSendTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "QNMsgSerTime": {
                        statement.setqNMsgSerTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block44;
                    }
                    case "QNRespDeSerTime": {
                        statement.setqNRespDeSerTime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    }
                }
            }
            this.cluster.addClusterStatement(statementDefinition, statement);
        }
        catch (InstanceNotFoundException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private Cluster.Member initializeMember(ObjectName mbeanName, Cluster.Member member) throws InstanceNotFoundException, ReflectionException, IOException, IntrospectionException {
        MBeanAttributeInfo[] mbeanAttributes = this.mbs.getMBeanInfo(mbeanName).getAttributes();
        Set<String> mbeanAttributeNames = Arrays.stream(mbeanAttributes).map(MBeanFeatureInfo::getName).collect(Collectors.toSet());
        AttributeList attributeList = this.mbs.getAttributes(mbeanName, mbeanAttributeNames.toArray(new String[0]));
        block62: for (int i = 0; i < attributeList.size(); ++i) {
            String name;
            Attribute attribute = (Attribute)attributeList.get(i);
            switch (name = attribute.getName()) {
                case "Version": {
                    if (member.getGemfireVersion() != null) continue block62;
                    String gemfireVersion = this.obtainGemfireVersion(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    member.setGemfireVersion(gemfireVersion);
                    continue block62;
                }
                case "Manager": {
                    member.setManager(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "TotalRegionCount": {
                    member.setTotalRegionCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "Locator": {
                    member.setLocator(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "TotalDiskUsage": {
                    member.setTotalDiskUsage(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "Server": {
                    member.setServer(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "TotalFileDescriptorOpen": {
                    member.setTotalFileDescriptorOpen(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "LoadAverage": {
                    member.setLoadAverage(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "DiskWritesRate": {
                    member.setThroughputWrites(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    member.getThroughputWritesTrend().add((Object)member.getThroughputWrites());
                    continue block62;
                }
                case "DiskReadsRate": {
                    member.setThroughputReads(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    member.getThroughputReadsTrend().add((Object)member.getThroughputReads());
                    continue block62;
                }
                case "JVMPauses": {
                    long trendVal = this.determineCurrentJVMPauses("member", member.getName(), this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    member.setGarbageCollectionCount(trendVal);
                    member.getGarbageCollectionSamples().add((Object)member.getGarbageCollectionCount());
                    continue block62;
                }
                case "UsedMemory": {
                    member.setCurrentHeapSize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    member.getHeapUsageSamples().add((Object)member.getCurrentHeapSize());
                    continue block62;
                }
                case "MaxMemory": {
                    member.setMaxHeapSize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "NumThreads": {
                    member.setNumThreads(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "MemberUpTime": {
                    member.setUptime(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "Host": {
                    member.setHost(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "HostnameForClients": {
                    member.setHostnameForClients(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "BindAddress": {
                    member.setBindAddress(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "TotalBytesOnDisk": {
                    member.setTotalBytesOnDisk(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    member.getTotalBytesOnDiskSamples().add((Object)member.getTotalBytesOnDisk());
                    continue block62;
                }
                case "CpuUsage": {
                    member.setCpuUsage(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    member.getCpuUsageSamples().add((Object)member.getCpuUsage());
                    continue block62;
                }
                case "HostCpuUsage": {
                    member.setHostCpuUsage(this.getIntegerAttribute(attribute.getValue(), attribute.getName()).intValue());
                    continue block62;
                }
                case "Member": {
                    member.setName(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "Id": {
                    member.setId(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "AverageReads": {
                    member.setGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    member.getGetsPerSecond().add((Object)member.getGetsRate());
                    continue block62;
                }
                case "AverageWrites": {
                    member.setPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                    member.getPutsPerSecond().add((Object)member.getPutsRate());
                    continue block62;
                }
                case "OffHeapFreeSize": {
                    member.setOffHeapFreeSize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "OffHeapUsedSize": {
                    member.setOffHeapUsedSize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                    continue block62;
                }
                case "Groups": {
                    String[] sgValues = (String[])attribute.getValue();
                    member.getServerGroups().clear();
                    for (int k = 0; k < sgValues.length; ++k) {
                        member.getServerGroups().add(sgValues[k]);
                    }
                    continue block62;
                }
                case "RedundancyZone": {
                    String rzValue = "";
                    if (null != attribute.getValue()) {
                        rzValue = this.getStringAttribute(attribute.getValue(), attribute.getName());
                    }
                    member.getRedundancyZones().clear();
                    if (rzValue.isEmpty()) continue block62;
                    member.getRedundancyZones().add(rzValue);
                }
            }
        }
        return member;
    }

    private void updateClusterMember(ObjectName mbeanName) throws IOException {
        try {
            String memberName = mbeanName.getKeyProperty("member");
            Cluster.Member clusterMember = this.cluster.getMembersHMap().get(memberName);
            if (clusterMember != null) {
                this.cluster.getDeletedMembers().remove(memberName);
            } else {
                clusterMember = new Cluster.Member();
                this.cluster.getMembersHMap().put(memberName, clusterMember);
            }
            clusterMember = this.initializeMember(mbeanName, clusterMember);
            ArrayList memberArrList = (ArrayList)this.cluster.getPhysicalToMember().get(clusterMember.getHost());
            if (memberArrList != null) {
                if (!memberArrList.contains(clusterMember)) {
                    memberArrList.add(clusterMember);
                }
            } else {
                ArrayList<Cluster.Member> memberList = new ArrayList<Cluster.Member>();
                memberList.add(clusterMember);
                this.cluster.getPhysicalToMember().put(clusterMember.getHost(), memberList);
            }
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    private Float getFloatAttribute(Object object, String name) {
        if (object == null) {
            return Float.valueOf(0.0f);
        }
        try {
            if (!object.getClass().equals(Float.class)) {
                logger.info("************************Unexpected type for attribute: {}; Expected type: {}; Received type: {}************************", (Object)name, (Object)Float.class.getName(), (Object)object.getClass().getName());
                return Float.valueOf(0.0f);
            }
            return (Float)object;
        }
        catch (Exception e) {
            logger.info("Exception occurred: ", (Throwable)e);
            return Float.valueOf(0.0f);
        }
    }

    private Integer getIntegerAttribute(Object object, String name) {
        if (object == null) {
            return 0;
        }
        try {
            if (!object.getClass().equals(Integer.class)) {
                logger.info("************************Unexpected type for attribute: {}; Expected type: {}; Received type: {}************************", (Object)name, (Object)Integer.class.getName(), (Object)object.getClass().getName());
                return 0;
            }
            return (Integer)object;
        }
        catch (Exception e) {
            logger.info("Exception occurred: ", (Throwable)e);
            return 0;
        }
    }

    private Long getLongAttribute(Object object, String name) {
        if (object == null) {
            return 0L;
        }
        try {
            if (!object.getClass().equals(Long.class)) {
                logger.info("************************Unexpected type for attribute: {}; Expected type: {}; Received type: {}************************", (Object)name, (Object)Long.class.getName(), (Object)object.getClass().getName());
                return 0L;
            }
            return (Long)object;
        }
        catch (Exception e) {
            logger.info("Exception occurred: ", (Throwable)e);
            return 0L;
        }
    }

    private String getStringAttribute(Object object, String name) {
        if (object == null) {
            return "";
        }
        try {
            if (!object.getClass().equals(String.class)) {
                logger.info("************************Unexpected type for attribute: {}; Expected type: {}; Received type: {}************************", (Object)name, (Object)String.class.getName(), (Object)object.getClass().getName());
                return "";
            }
            return (String)object;
        }
        catch (Exception e) {
            logger.info("Exception occurred: ", (Throwable)e);
            return "";
        }
    }

    private Boolean getBooleanAttribute(Object object, String name) {
        if (object == null) {
            return Boolean.FALSE;
        }
        try {
            if (!object.getClass().equals(Boolean.class)) {
                logger.info("************************Unexpected type for attribute: {}; Expected type: {}; Received type: {}************************", (Object)name, (Object)Boolean.class.getName(), (Object)object.getClass().getName());
                return Boolean.FALSE;
            }
            return (Boolean)object;
        }
        catch (Exception e) {
            logger.info("Exception Occurred: ", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    Double getDoubleAttribute(Object object, String name) {
        if (object == null) {
            return 0.0;
        }
        try {
            if (object instanceof Float) {
                return BigDecimal.valueOf(((Float)object).floatValue()).doubleValue();
            }
            if (object instanceof Double) {
                return (Double)object;
            }
            logger.info("************************Unexpected type for attribute: {}; Expected type: {}; Received type: {}************************", (Object)name, (Object)Double.class.getName(), (Object)object.getClass().getName());
            return 0.0;
        }
        catch (Exception e) {
            logger.info("Exception occurred: ", (Throwable)e);
            return 0.0;
        }
    }

    private void updateMemberRegion(ObjectName mbeanName) throws IOException {
        try {
            Cluster.Region region;
            String memberName = mbeanName.getKeyProperty("member");
            Cluster.Member member = this.cluster.getMembersHMap().get(memberName);
            AttributeList attributeList = this.mbs.getAttributes(mbeanName, PulseConstants.REGION_MBEAN_ATTRIBUTES);
            String regionFullPathKey = null;
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                if (!attribute.getName().equals("FullPath")) continue;
                regionFullPathKey = this.getStringAttribute(attribute.getValue(), attribute.getName());
                break;
            }
            if (null == member) {
                member = new Cluster.Member();
                member.setName(memberName);
                this.cluster.getMembersHMap().put(memberName, member);
            }
            if (null == (region = member.getMemberRegions().get(regionFullPathKey))) {
                region = new Cluster.Region();
                member.getMemberRegions().put(regionFullPathKey, region);
                member.setTotalRegionCount(member.getTotalRegionCount() + 1);
            }
            region.setFullPath(regionFullPathKey);
            block33: for (int i = 0; i < attributeList.size(); ++i) {
                String name;
                Attribute attribute = (Attribute)attributeList.get(i);
                switch (name = attribute.getName()) {
                    case "FullPath": {
                        region.setFullPath(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "DiskReadsRate": {
                        region.setDiskReadsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "DiskWritesRate": {
                        region.setDiskWritesRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "GetsRate": {
                        region.setGetsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "LruEvictionRate": {
                        region.setLruEvictionRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "PutsRate": {
                        region.setPutsRate(this.getDoubleAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "RegionType": {
                        region.setRegionType(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "MemberCount": {
                        region.setMemberCount(this.getIntegerAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "EntrySize": {
                        region.setEntrySize(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "EntryCount": {
                        region.setSystemRegionEntryCount(this.getLongAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "Name": {
                        region.setName(this.getStringAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "PersistentEnabled": {
                        region.setPersistentEnabled(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                        continue block33;
                    }
                    case "GatewayEnabled": {
                        region.setWanEnabled(this.getBooleanAttribute(attribute.getValue(), attribute.getName()));
                    }
                }
            }
        }
        catch (InstanceNotFoundException | ReflectionException infe) {
            logger.warn((Object)infe);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("system.alert".equals(type)) {
            Cluster.Alert alert = new Cluster.Alert();
            long timeStamp = notification.getTimeStamp();
            Date date = new Date(timeStamp);
            alert.setTimestamp(date);
            String notificationSource = (String)notification.getUserData();
            alert.setMemberName(notificationSource);
            String alertDescription = notification.getMessage();
            if (alertDescription.startsWith("[error")) {
                alert.setSeverity(1);
            } else if (alertDescription.startsWith("[warning")) {
                alert.setSeverity(2);
            } else if (alertDescription.startsWith("[severe")) {
                alert.setSeverity(0);
            } else {
                alert.setSeverity(3);
            }
            alert.setDescription(notification.getMessage());
            alert.setAcknowledged(false);
            alert.setId(Cluster.Alert.nextID());
            this.cluster.addAlert(alert);
        } else {
            Cluster.Alert alert = new Cluster.Alert();
            long timeStamp = notification.getTimeStamp();
            Date date = new Date(timeStamp);
            alert.setTimestamp(date);
            String notificationSource = (String)notification.getSource();
            alert.setMemberName(notificationSource);
            String alertDescription = notification.getMessage();
            alert.setDescription(alertDescription);
            alert.setSeverity(3);
            alert.setAcknowledged(false);
            alert.setId(Cluster.Alert.nextID());
            this.cluster.addAlert(alert);
            if ("gemfire.distributedsystem.cache.region.closed".equals(type)) {
                String msg = notification.getMessage();
                String deletedRegion = msg.substring(msg.indexOf("Name ") + "Name ".length());
                String memberName = notificationSource;
                Cluster.Member member = this.cluster.getMembersHMap().get(memberName);
                if (member.getMemberRegions().get(deletedRegion) != null) {
                    member.getMemberRegions().remove(deletedRegion);
                    member.setTotalRegionCount(member.getMemberRegions().size());
                }
            }
        }
    }

    @Override
    public ObjectNode executeQuery(String queryText, String members, int limit) {
        ObjectNode queryResult = this.mapper.createObjectNode();
        if (this.mbs != null && this.systemMBeans != null) {
            Object[] opParams = new Object[]{queryText, members, limit};
            for (ObjectName sysMBean : this.systemMBeans) {
                try {
                    String resultString = (String)this.mbs.invoke(sysMBean, "queryData", opParams, this.opSignature);
                    queryResult = (ObjectNode)this.mapper.readTree(resultString);
                }
                catch (Exception e) {
                    queryResult.put("error", e.getMessage());
                    logger.debug((Object)e);
                }
            }
        }
        return queryResult;
    }

    private long determineCurrentJVMPauses(String type, String key, long totalJVMPauses) {
        long currentJVMPausesCount = 0L;
        if (type.equalsIgnoreCase("cluster")) {
            long prevJVMPausesCount = this.cluster.getPreviousJVMPauseCount();
            if (totalJVMPauses > prevJVMPausesCount) {
                currentJVMPausesCount = totalJVMPauses - prevJVMPausesCount;
            }
            this.cluster.setPreviousJVMPauseCount(totalJVMPauses);
        } else {
            Cluster.Member clusterMember = this.cluster.getMembersHMap().get(key);
            if (clusterMember != null) {
                long prevJVMPausesCount = clusterMember.getPreviousJVMPauseCount();
                if (totalJVMPauses > prevJVMPausesCount) {
                    currentJVMPausesCount = totalJVMPauses - prevJVMPausesCount;
                }
                clusterMember.setPreviousJVMPauseCount(totalJVMPauses);
            }
        }
        return currentJVMPausesCount;
    }

    private String obtainGemfireVersion(String version) {
        String versionText = "Java version:   ";
        String gemfireVersion = "";
        int startIndex = version.indexOf("Java version:   ") + "Java version:   ".length();
        gemfireVersion = version.substring(startIndex);
        gemfireVersion = gemfireVersion.substring(0, gemfireVersion.indexOf(" "));
        return gemfireVersion;
    }
}

