/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.PulseConstants;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberRegions")
@Scope(value="singleton")
public class MemberRegionsService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String NAME = "name";
    private final String ENTRY_SIZE = "entrySize";
    private final String DISC_STORE_NAME = "diskStoreName";
    private final String DISC_SYNCHRONOUS = "diskSynchronous";

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberRegions").get("memberName").textValue();
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName(memberName));
        if (clusterMember != null) {
            responseJSON.put("memberId", clusterMember.getId());
            responseJSON.put(this.NAME, clusterMember.getName());
            responseJSON.put("host", clusterMember.getHost());
            Cluster.Region[] memberRegions = clusterMember.getMemberRegionsList();
            ArrayNode regionsListJson = this.mapper.createArrayNode();
            for (Cluster.Region memberRegion : memberRegions) {
                ObjectNode regionJSON = this.mapper.createObjectNode();
                regionJSON.put(this.NAME, memberRegion.getName());
                regionJSON.put("fullPath", memberRegion.getFullPath());
                regionJSON.put("type", memberRegion.getRegionType());
                regionJSON.put("entryCount", memberRegion.getSystemRegionEntryCount());
                Long entrySize = memberRegion.getEntrySize();
                String entrySizeInMB = PulseConstants.FOUR_PLACE_DECIMAL_FORMAT.format((float)entrySize.longValue() / 1048576.0f);
                if (entrySize < 0L) {
                    regionJSON.put(this.ENTRY_SIZE, "NA");
                } else {
                    regionJSON.put(this.ENTRY_SIZE, entrySizeInMB);
                }
                regionJSON.put("scope", memberRegion.getScope());
                String diskStoreName = memberRegion.getDiskStoreName();
                if (StringUtils.isNotBlank((String)diskStoreName)) {
                    regionJSON.put(this.DISC_STORE_NAME, diskStoreName);
                    regionJSON.put(this.DISC_SYNCHRONOUS, memberRegion.isDiskSynchronous());
                } else {
                    regionJSON.put(this.DISC_SYNCHRONOUS, "NA");
                    regionJSON.put(this.DISC_STORE_NAME, "");
                }
                regionJSON.put("gatewayEnabled", memberRegion.getWanEnabled());
                regionsListJson.add((JsonNode)regionJSON);
            }
            responseJSON.put("memberRegions", (JsonNode)regionsListJson);
            responseJSON.put("status", "Normal");
        }
        return responseJSON;
    }
}

