/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina.callback;

import jakarta.servlet.http.HttpSession;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.CacheWriterAdapter;

public class LocalSessionCacheWriter
extends CacheWriterAdapter<String, HttpSession>
implements Declarable {
    private final Region<String, HttpSession> backingRegion;

    public LocalSessionCacheWriter(Region<String, HttpSession> backingRegion) {
        this.backingRegion = backingRegion;
    }

    public void beforeCreate(EntryEvent<String, HttpSession> event) throws CacheWriterException {
        this.backingRegion.put((Object)((String)event.getKey()), (Object)((HttpSession)event.getNewValue()), event.getCallbackArgument());
    }

    public void beforeUpdate(EntryEvent<String, HttpSession> event) throws CacheWriterException {
        this.backingRegion.put((Object)((String)event.getKey()), (Object)((HttpSession)event.getNewValue()), event.getCallbackArgument());
    }

    public void beforeDestroy(EntryEvent<String, HttpSession> event) throws CacheWriterException {
        try {
            this.backingRegion.destroy(event.getKey(), event.getCallbackArgument());
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
    }

    public void close() {
    }
}

