/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.bootstrap;

import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.modules.session.bootstrap.AbstractCache;

public class ClientServerCache
extends AbstractCache {
    private static final String DEFAULT_CACHE_XML_FILE_NAME = "cache-client.xml";

    private ClientServerCache() {
    }

    public static AbstractCache getInstance() {
        return instance;
    }

    @Override
    protected void createOrRetrieveCache() {
        String message;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(this) + ": Creating cache");
        }
        try {
            this.cache = ClientCacheFactory.getAnyInstance();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        if (this.cache == null || this.cache.isClosed()) {
            this.cache = new ClientCacheFactory(this.createDistributedSystemProperties()).create();
            message = "Created ";
        } else {
            message = "Retrieved ";
        }
        this.getLogger().info(message + String.valueOf(this.cache));
    }

    @Override
    protected void rebalanceCache() {
        this.getLogger().warn("The client cannot rebalance the server's cache.");
    }

    @Override
    protected String getDefaultCacheXmlFileName() {
        return DEFAULT_CACHE_XML_FILE_NAME;
    }

    static {
        instance = new ClientServerCache();
    }
}

