/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Collections;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.security.ResourcePermission;

public class RegionSizeFunction
implements Function,
Declarable,
DataSerializable {
    private static final long serialVersionUID = -2791590491585777990L;
    public static final String ID = "region-size-function";

    public void execute(FunctionContext context) {
        RegionFunctionContext rfc = (RegionFunctionContext)context;
        context.getResultSender().lastResult((Object)rfc.getDataSet().size());
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName));
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return true;
    }

    public void toData(DataOutput out) {
    }

    public void fromData(DataInput in) {
    }
}

