/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.modules.gatewaydelta.AbstractGatewayDeltaEvent;

public class GatewayDeltaCreateEvent
extends AbstractGatewayDeltaEvent {
    private byte[] gatewayDelta;

    GatewayDeltaCreateEvent(String regionName, String key, byte[] gatewayDelta) {
        super(regionName, key);
        this.gatewayDelta = gatewayDelta;
    }

    @Override
    public void apply(Cache cache) {
        Region region = this.getRegion(cache);
        region.put((Object)this.key, (Object)CachedDeserializableFactory.create((byte[])this.gatewayDelta, (InternalCache)((InternalCache)cache)), (Object)true);
        if (cache.getLogger().fineEnabled()) {
            cache.getLogger().fine("Applied " + this);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.gatewayDelta = DataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeByteArray((byte[])this.gatewayDelta, (DataOutput)out);
    }

    public String toString() {
        return "GatewayDeltaCreateEvent[regionName=" + this.regionName + "; key=" + this.key + "; gatewayDelta=" + Arrays.toString(this.gatewayDelta) + "]";
    }
}

