/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.modules.session.catalina.AbstractSessionCache;
import org.apache.geode.modules.session.catalina.SessionManager;
import org.apache.geode.modules.session.catalina.callback.LocalSessionCacheLoader;
import org.apache.geode.modules.session.catalina.callback.LocalSessionCacheWriter;
import org.apache.geode.modules.session.catalina.callback.SessionExpirationCacheListener;
import org.apache.geode.modules.util.RegionConfiguration;
import org.apache.geode.modules.util.RegionHelper;
import org.apache.geode.modules.util.SessionCustomExpiry;
import org.apache.geode.modules.util.TouchPartitionedRegionEntriesFunction;
import org.apache.geode.modules.util.TouchReplicatedRegionEntriesFunction;

public class PeerToPeerSessionCache
extends AbstractSessionCache {
    private Cache cache;
    protected static final String DEFAULT_REGION_ATTRIBUTES_ID = RegionShortcut.REPLICATE.toString();
    protected static final boolean DEFAULT_ENABLE_LOCAL_CACHE = false;

    public PeerToPeerSessionCache(SessionManager sessionManager, Cache cache) {
        super(sessionManager);
        this.cache = cache;
        this.addReconnectListener();
    }

    @Override
    public void initialize() {
        this.registerFunctions();
        this.createOrRetrieveRegion();
        this.operatingRegion = this.getSessionManager().getEnableLocalCache() ? this.createOrRetrieveLocalRegion() : this.sessionRegion;
        this.createStatistics();
    }

    @Override
    public String getDefaultRegionAttributesId() {
        return DEFAULT_REGION_ATTRIBUTES_ID;
    }

    @Override
    public boolean getDefaultEnableLocalCache() {
        return false;
    }

    @Override
    public void touchSessions(Set<String> sessionIds) {
        Execution execution;
        String regionAttributesID = this.getSessionManager().getRegionAttributesId().toLowerCase();
        ResultCollector collector = null;
        if (regionAttributesID.startsWith("partition")) {
            execution = this.getExecutionForFunctionOnRegionWithFilter(sessionIds);
            collector = execution.execute("touch-partitioned-region-entries");
        } else {
            execution = this.getExecutionForFunctionOnMembersWithArguments(new Object[]{this.sessionRegion.getFullPath(), sessionIds});
            collector = execution.execute("touch-replicated-region-entries");
        }
        try {
            collector.getResult();
        }
        catch (Exception e) {
            this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
        }
    }

    @Override
    public boolean isPeerToPeer() {
        return true;
    }

    @Override
    public boolean isClientServer() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return this.getSessionRegion().keySet();
    }

    @Override
    public int size() {
        return this.getSessionRegion().size();
    }

    @Override
    public GemFireCache getCache() {
        return this.cache;
    }

    @Override
    public boolean isBackingCacheAvailable() {
        return true;
    }

    private void registerFunctions() {
        if (!this.isFunctionRegistered("touch-partitioned-region-entries")) {
            this.registerFunctionWithFunctionService(new TouchPartitionedRegionEntriesFunction());
        }
        if (!this.isFunctionRegistered("touch-replicated-region-entries")) {
            this.registerFunctionWithFunctionService(new TouchReplicatedRegionEntriesFunction());
        }
    }

    protected void createOrRetrieveRegion() {
        RegionConfiguration configuration = this.createRegionConfiguration();
        configuration.setSessionExpirationCacheListener(true);
        Region region = this.cache.getRegion(this.getSessionManager().getRegionName());
        if (region == null) {
            region = this.createRegionUsingHelper(configuration);
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Created new session region: " + region));
            }
        } else {
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Retrieved existing session region: " + region));
            }
            this.validateRegionUsingRegionhelper(configuration, region);
        }
        this.sessionRegion = region;
    }

    void validateRegionUsingRegionhelper(RegionConfiguration configuration, Region region) {
        RegionHelper.validateRegion((Cache)this.getCache(), configuration, region);
    }

    Region createRegionUsingHelper(RegionConfiguration configuration) {
        return RegionHelper.createRegion((Cache)this.getCache(), configuration);
    }

    private Region<String, HttpSession> createOrRetrieveLocalRegion() {
        String frontingRegionName = this.sessionRegion.getName() + "_local";
        Region frontingRegion = this.cache.getRegion(frontingRegionName);
        if (frontingRegion == null) {
            RegionFactory factory = this.cache.createRegionFactory(RegionShortcut.LOCAL_HEAP_LRU);
            factory.setCacheLoader((CacheLoader)new LocalSessionCacheLoader((Region<String, HttpSession>)this.sessionRegion));
            factory.setCacheWriter((CacheWriter)new LocalSessionCacheWriter((Region<String, HttpSession>)this.sessionRegion));
            int maxInactiveInterval = this.getSessionManager().getMaxInactiveInterval();
            if (maxInactiveInterval != -1) {
                factory.setStatisticsEnabled(true);
                factory.setCustomEntryIdleTimeout((CustomExpiry)new SessionCustomExpiry());
                factory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
            }
            frontingRegion = factory.create(frontingRegionName);
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Created new local session region: " + frontingRegion));
            }
        } else if (this.getSessionManager().getLogger().isDebugEnabled()) {
            this.getSessionManager().getLogger().debug((Object)("Retrieved existing local session region: " + frontingRegion));
        }
        return frontingRegion;
    }

    void registerFunctionWithFunctionService(Function function) {
        FunctionService.registerFunction((Function)function);
    }

    boolean isFunctionRegistered(String id) {
        return FunctionService.isRegistered((String)id);
    }

    Execution getExecutionForFunctionOnRegionWithFilter(Set<String> sessionIds) {
        return FunctionService.onRegion(this.getSessionRegion()).withFilter(sessionIds);
    }

    Execution getExecutionForFunctionOnMembersWithArguments(Object[] arguments) {
        return FunctionService.onMembers((String[])new String[0]).setArguments((Object)arguments);
    }

    private void addReconnectListener() {
        InternalDistributedSystem.addReconnectListener((InternalDistributedSystem.ReconnectListener)new InternalDistributedSystem.ReconnectListener(){

            public void onReconnect(InternalDistributedSystem oldSystem, InternalDistributedSystem newSystem) {
                PeerToPeerSessionCache.this.reinitialize(newSystem.getCache());
            }
        });
    }

    private void reinitialize(InternalCache reconnectedCache) {
        this.cache = reconnectedCache;
        this.initialize();
    }
}

