/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.StandardSession;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.lru.Sizeable;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.modules.gatewaydelta.GatewayDelta;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEvent;
import org.apache.geode.modules.session.catalina.DeltaSessionFacade;
import org.apache.geode.modules.session.catalina.DeltaSessionInterface;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;
import org.apache.geode.modules.session.catalina.SessionManager;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEvent;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEventBatch;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionDestroyAttributeEvent;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionUpdateAttributeEvent;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DeltaSession
extends StandardSession
implements DataSerializable,
Delta,
GatewayDelta,
Sizeable,
DeltaSessionInterface {
    private transient Region<String, HttpSession> operatingRegion;
    private String sessionRegionName;
    private String contextName;
    private boolean hasDelta;
    private boolean applyRemotely;
    private boolean enableGatewayDeltaReplication;
    private final transient Object changeLock = new Object();
    private final List<DeltaSessionAttributeEvent> eventQueue = new ArrayList<DeltaSessionAttributeEvent>();
    private transient GatewayDeltaEvent currentGatewayDeltaEvent;
    private transient boolean expired = false;
    private transient boolean preferDeserializedForm = true;
    private byte[] serializedPrincipal;
    private final Log LOG = LogFactory.getLog((String)DeltaSession.class.getName());

    public DeltaSession() {
        super(null);
    }

    public DeltaSession(Manager manager) {
        super(manager);
        this.setOwner(manager);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final DeltaSession fsession = this;
                this.facade = (DeltaSessionFacade)((Object)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new DeltaSessionFacade(fsession);
                    }
                }));
            } else {
                this.facade = new DeltaSessionFacade(this);
            }
        }
        return this.facade;
    }

    public Principal getPrincipal() {
        if (this.principal == null && this.serializedPrincipal != null) {
            DeltaSessionManager mgr;
            SerializablePrincipal sp = null;
            try {
                sp = (SerializablePrincipal)BlobHelper.deserializeBlob((byte[])this.serializedPrincipal);
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                builder.append(this).append(": Serialized principal contains a byte[] that cannot be deserialized due to the following exception");
                ((DeltaSessionManager)this.getManager()).getLogger().warn((Object)builder.toString(), (Throwable)e);
                return null;
            }
            this.principal = sp.getPrincipal(((DeltaSessionManager)this.manager).getTheContext().getRealm());
            if (this.getManager() != null && (mgr = (DeltaSessionManager)this.getManager()).getLogger().isDebugEnabled()) {
                mgr.getLogger().debug((Object)(this + ": Deserialized principal: " + this.principal));
            }
        }
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        super.setPrincipal(principal);
        if (this.getManager() != null) {
            this.getManager().add((Session)this);
            DeltaSessionManager mgr = (DeltaSessionManager)this.getManager();
            if (mgr.getLogger().isDebugEnabled()) {
                mgr.getLogger().debug((Object)(this + ": Cached principal: " + principal));
            }
        }
    }

    private byte[] getSerializedPrincipal() {
        if (this.serializedPrincipal == null && this.principal != null && this.principal instanceof GenericPrincipal) {
            DeltaSessionManager mgr;
            GenericPrincipal gp = (GenericPrincipal)this.principal;
            SerializablePrincipal sp = SerializablePrincipal.createPrincipal((GenericPrincipal)gp);
            this.serializedPrincipal = this.serialize(sp);
            if (this.manager != null && (mgr = (DeltaSessionManager)this.getManager()).getLogger().isDebugEnabled()) {
                mgr.getLogger().debug((Object)(this + ": Serialized principal: " + sp));
            }
        }
        return this.serializedPrincipal;
    }

    protected Region<String, HttpSession> getOperatingRegion() {
        return this.operatingRegion;
    }

    public boolean isCommitEnabled() {
        DeltaSessionManager mgr = (DeltaSessionManager)this.getManager();
        return mgr.isCommitValveEnabled();
    }

    @Override
    public GatewayDeltaEvent getCurrentGatewayDeltaEvent() {
        return this.currentGatewayDeltaEvent;
    }

    @Override
    public void setCurrentGatewayDeltaEvent(GatewayDeltaEvent currentGatewayDeltaEvent) {
        this.currentGatewayDeltaEvent = currentGatewayDeltaEvent;
    }

    @Override
    public void setOwner(Object manager) {
        if (manager instanceof DeltaSessionManager) {
            DeltaSessionManager sessionManager = (DeltaSessionManager)manager;
            this.manager = sessionManager;
            this.initializeRegion(sessionManager);
            this.hasDelta = false;
            this.applyRemotely = false;
            this.enableGatewayDeltaReplication = sessionManager.getEnableGatewayDeltaReplication();
            this.preferDeserializedForm = sessionManager.getPreferDeserializedForm();
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (this.notes == null) {
                this.notes = new Hashtable();
            }
        } else {
            throw new IllegalArgumentException(this + ": The Manager must be an AbstractManager");
        }
        this.contextName = ((DeltaSessionManager)manager).getContextName();
    }

    private void checkBackingCacheAvailable() {
        if (!((SessionManager)this.getManager()).isBackingCacheAvailable()) {
            throw new IllegalStateException("No backing cache server is available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value, boolean notify) {
        this.checkBackingCacheAvailable();
        Object object = this.changeLock;
        synchronized (object) {
            byte[] serializedValue = this.serialize(value);
            if (this.preferDeserializedForm) {
                super.setAttribute(name, value, true);
            } else {
                super.setAttribute(name, (Object)serializedValue, true);
            }
            if (serializedValue == null) {
                return;
            }
            DeltaSessionUpdateAttributeEvent event = new DeltaSessionUpdateAttributeEvent(name, serializedValue);
            this.queueAttributeEvent(event, true);
            if (!this.isCommitEnabled()) {
                this.putInRegion(this.getOperatingRegion(), true, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name, boolean notify) {
        this.checkBackingCacheAvailable();
        Object object = this.changeLock;
        synchronized (object) {
            super.removeAttribute(name, true);
            DeltaSessionDestroyAttributeEvent event = new DeltaSessionDestroyAttributeEvent(name);
            this.queueAttributeEvent(event, true);
            if (!this.isCommitEnabled()) {
                this.putInRegion(this.getOperatingRegion(), true, null);
            }
        }
    }

    public Object getAttribute(String name) {
        this.checkBackingCacheAvailable();
        Object value = super.getAttribute(name);
        if (value instanceof byte[]) {
            try {
                value = BlobHelper.deserializeBlob((byte[])((byte[])value));
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                builder.append(this).append(": Attribute named ").append(name).append(" contains a byte[] that cannot be deserialized due to the following exception");
                ((DeltaSessionManager)this.getManager()).getLogger().warn((Object)builder.toString(), (Throwable)e);
            }
            if (this.preferDeserializedForm) {
                this.localUpdateAttribute(name, value);
            }
        }
        ((DeltaSessionManager)this.getManager()).addSessionToTouch(this.getId());
        return value;
    }

    public void invalidate() {
        super.invalidate();
        ((DeltaSessionManager)this.getManager()).getStatistics().incSessionsInvalidated();
    }

    @Override
    public void processExpired() {
        DeltaSessionManager manager = (DeltaSessionManager)this.getManager();
        if (manager != null && manager.getLogger() != null && manager.getLogger().isDebugEnabled()) {
            ((DeltaSessionManager)this.getManager()).getLogger().debug((Object)(this + ": Expired"));
        }
        this.setExpired(true);
        this.expire();
        if (manager != null) {
            manager.getStatistics().incSessionsExpired();
        }
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
    }

    @Override
    public void localUpdateAttribute(String name, Object value) {
        super.setAttribute(name, value, false);
    }

    @Override
    public void localDestroyAttribute(String name) {
        super.removeAttribute(name, false);
    }

    @Override
    public void applyAttributeEvents(Region<String, DeltaSessionInterface> region, List<DeltaSessionAttributeEvent> events) {
        for (DeltaSessionAttributeEvent event : events) {
            event.apply(this);
            this.queueAttributeEvent(event, false);
        }
        this.putInRegion(region, false, true);
    }

    private void initializeRegion(DeltaSessionManager sessionManager) {
        this.sessionRegionName = sessionManager.getRegionName();
        this.operatingRegion = sessionManager.getSessionCache().getOperatingRegion();
        if (sessionManager.getLogger().isDebugEnabled()) {
            sessionManager.getLogger().debug((Object)(this + ": Set operating region: " + this.operatingRegion));
        }
    }

    private void queueAttributeEvent(DeltaSessionAttributeEvent event, boolean checkAddToCurrentGatewayDelta) {
        if (checkAddToCurrentGatewayDelta) {
            DeltaSessionManager mgr = (DeltaSessionManager)this.manager;
            if (this.enableGatewayDeltaReplication && mgr.isPeerToPeer() && !this.isCommitEnabled()) {
                ArrayList<DeltaSessionAttributeEvent> events = new ArrayList<DeltaSessionAttributeEvent>();
                events.add(event);
                this.currentGatewayDeltaEvent = new DeltaSessionAttributeEventBatch(this.sessionRegionName, this.id, events);
            }
        }
        this.eventQueue.add(event);
    }

    private void putInRegion(Region region, boolean applyRemotely, Object callbackArgument) {
        this.hasDelta = true;
        this.applyRemotely = applyRemotely;
        region.put((Object)this.id, (Object)this, callbackArgument);
        this.eventQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException("commit: Session " + this.getId() + " already invalidated");
        }
        Object object = this.changeLock;
        synchronized (object) {
            DeltaSessionManager mgr = (DeltaSessionManager)this.manager;
            if (this.enableGatewayDeltaReplication && mgr.isPeerToPeer()) {
                this.setCurrentGatewayDeltaEvent(new DeltaSessionAttributeEventBatch(this.sessionRegionName, this.id, this.eventQueue));
            }
            this.hasDelta = true;
            this.applyRemotely = true;
            this.putInRegion(this.getOperatingRegion(), true, null);
            this.eventQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.changeLock;
        synchronized (object) {
            this.eventQueue.clear();
        }
    }

    private void setExpired(boolean expired) {
        this.expired = expired;
    }

    @Override
    public boolean getExpired() {
        return this.expired;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    public boolean hasDelta() {
        return this.hasDelta;
    }

    public void toDelta(DataOutput out) throws IOException {
        out.writeBoolean(this.applyRemotely);
        DataSerializer.writeArrayList((ArrayList)((ArrayList)this.eventQueue), (DataOutput)out);
        out.writeLong(this.lastAccessedTime);
        out.writeInt(this.maxInactiveInterval);
    }

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        this.applyRemotely = in.readBoolean();
        ArrayList events = null;
        try {
            events = DataSerializer.readArrayList((DataInput)in);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidDeltaException((Throwable)e);
        }
        if (((InputStream)((Object)in)).available() > 0) {
            this.lastAccessedTime = in.readLong();
            this.maxInactiveInterval = in.readInt();
        }
        for (DeltaSessionAttributeEvent event : events) {
            event.apply(this);
        }
        if (this.enableGatewayDeltaReplication && this.applyRemotely) {
            this.setCurrentGatewayDeltaEvent(new DeltaSessionAttributeEventBatch(this.sessionRegionName, this.id, events));
        }
        this.access();
        this.endAccess();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.id, (DataOutput)out);
        out.writeLong(this.creationTime);
        out.writeLong(this.lastAccessedTime);
        out.writeLong(this.thisAccessedTime);
        out.writeInt(this.maxInactiveInterval);
        out.writeBoolean(this.isNew);
        out.writeBoolean(this.isValid);
        DataSerializer.writeObject(this.getSerializedAttributes(), (DataOutput)out);
        DataSerializer.writeByteArray((byte[])this.getSerializedPrincipal(), (DataOutput)out);
        out.writeBoolean(this.enableGatewayDeltaReplication);
        DataSerializer.writeString((String)this.sessionRegionName, (DataOutput)out);
        DataSerializer.writeString((String)this.contextName, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = DataSerializer.readString((DataInput)in);
        this.creationTime = in.readLong();
        this.lastAccessedTime = in.readLong();
        this.thisAccessedTime = in.readLong();
        this.maxInactiveInterval = in.readInt();
        this.isNew = in.readBoolean();
        this.isValid = in.readBoolean();
        this.attributes = this.readInAttributes(in);
        this.serializedPrincipal = DataSerializer.readByteArray((DataInput)in);
        this.enableGatewayDeltaReplication = in.readBoolean();
        this.sessionRegionName = DataSerializer.readString((DataInput)in);
        if (((InputStream)((Object)in)).available() > 0) {
            this.contextName = DataSerializer.readString((DataInput)in);
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable();
        }
    }

    protected Map readInAttributes(DataInput in) throws IOException, ClassNotFoundException {
        return (Map)DataSerializer.readObject((DataInput)in);
    }

    public int getSizeInBytes() {
        int size = 0;
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            Object value = super.getAttribute((String)e.nextElement());
            if (!(value instanceof byte[])) continue;
            size += ((byte[])value).length;
        }
        return size;
    }

    protected Map<String, byte[]> getSerializedAttributes() {
        ConcurrentHashMap<String, byte[]> serializedAttributes = new ConcurrentHashMap<String, byte[]>();
        for (Map.Entry entry : this.attributes.entrySet()) {
            Object value = entry.getValue();
            byte[] serializedValue = value instanceof byte[] ? (byte[])value : this.serialize(value);
            serializedAttributes.put((String)entry.getKey(), serializedValue);
        }
        return serializedAttributes;
    }

    protected byte[] serialize(Object obj) {
        byte[] serializedValue = null;
        try {
            serializedValue = BlobHelper.serializeToBlob((Object)obj);
        }
        catch (IOException e) {
            StringBuilder builder = new StringBuilder();
            builder.append(this).append(": Object ").append(obj).append(" cannot be serialized due to the following exception");
            ((DeltaSessionManager)this.getManager()).getLogger().warn((Object)builder.toString(), (Throwable)e);
        }
        return serializedValue;
    }

    public String toString() {
        return "DeltaSession[" + "id=" + this.getId() + "; context=" + this.contextName + "; sessionRegionName=" + this.sessionRegionName + "; operatingRegionName=" + (this.getOperatingRegion() == null ? "unset" : this.getOperatingRegion().getFullPath()) + "]";
    }
}

