/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;

public class TouchReplicatedRegionEntriesFunction
implements Function,
Declarable {
    private static final long serialVersionUID = -7424895036162243564L;
    private final Cache cache;
    public static final String ID = "touch-replicated-region-entries";

    public TouchReplicatedRegionEntriesFunction() {
        this(CacheFactory.getAnyInstance());
    }

    public TouchReplicatedRegionEntriesFunction(Cache cache) {
        this.cache = cache;
    }

    public void execute(FunctionContext context) {
        Region region;
        Object[] arguments = (Object[])context.getArguments();
        String regionName = (String)arguments[0];
        Set keys = (Set)arguments[1];
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Function ").append(ID).append(" received request to touch ").append(regionName).append("->").append(keys);
            this.cache.getLogger().fine(builder.toString());
        }
        if ((region = this.cache.getRegion(regionName)) != null) {
            region.getAll((Collection)keys);
        }
        context.getResultSender().lastResult((Object)true);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }

    public boolean hasResult() {
        return true;
    }

    public void init(Properties properties) {
    }
}

