/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class ModuleStatistics {
    private static final StatisticsType type;
    private static final int cacheHitsId;
    private static final int cacheMissesId;
    private static final int hibernateEntityDestroyJobsScheduledId;
    private final Statistics stats;
    private static ModuleStatistics instance;

    private ModuleStatistics(StatisticsFactory factory) {
        this.stats = factory.createAtomicStatistics(type, "PluginStatistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleStatistics getInstance(DistributedSystem system) {
        Class<ModuleStatistics> clazz = ModuleStatistics.class;
        synchronized (ModuleStatistics.class) {
            if (instance == null) {
                instance = new ModuleStatistics((StatisticsFactory)system);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void incCacheHit() {
        this.stats.incLong(cacheHitsId, 1L);
    }

    public long getCacheHits() {
        return this.stats.getLong(cacheHitsId);
    }

    public void incCacheMiss() {
        this.stats.incLong(cacheMissesId, 1L);
    }

    public long getCacheMiss() {
        return this.stats.getLong(cacheMissesId);
    }

    public void incHibernateDestroyJobsScheduled() {
        this.stats.incLong(hibernateEntityDestroyJobsScheduledId, 1L);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType("pluginStats", "statistics for hibernate plugin and hibernate L2 cache", new StatisticDescriptor[]{f.createLongCounter("cacheHits", "number of times an entity was found in L2 cache", "count"), f.createLongCounter("cacheMisses", "number of times an entity was NOT found in l2 cache", "count"), f.createLongCounter("hibernateEntityDestroyJobsScheduled", "number of entities scheduled for destroy because of version conflict with a remote member", "jobs")});
        cacheHitsId = type.nameToId("cacheHits");
        cacheMissesId = type.nameToId("cacheMisses");
        hibernateEntityDestroyJobsScheduledId = type.nameToId("hibernateEntityDestroyJobsScheduled");
    }
}

