/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.catalina;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.modules.session.catalina.AbstractSessionCache;
import com.gemstone.gemfire.modules.session.catalina.SessionManager;
import com.gemstone.gemfire.modules.session.catalina.callback.LocalSessionCacheLoader;
import com.gemstone.gemfire.modules.session.catalina.callback.LocalSessionCacheWriter;
import com.gemstone.gemfire.modules.session.catalina.callback.SessionExpirationCacheListener;
import com.gemstone.gemfire.modules.util.RegionConfiguration;
import com.gemstone.gemfire.modules.util.RegionHelper;
import com.gemstone.gemfire.modules.util.SessionCustomExpiry;
import com.gemstone.gemfire.modules.util.TouchPartitionedRegionEntriesFunction;
import com.gemstone.gemfire.modules.util.TouchReplicatedRegionEntriesFunction;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class PeerToPeerSessionCache
extends AbstractSessionCache {
    private Cache cache;
    protected static final String DEFAULT_REGION_ATTRIBUTES_ID = RegionShortcut.REPLICATE.toString();
    protected static final boolean DEFAULT_ENABLE_LOCAL_CACHE = false;

    public PeerToPeerSessionCache(SessionManager sessionManager, Cache cache) {
        super(sessionManager);
        this.cache = cache;
    }

    @Override
    public void initialize() {
        this.registerFunctions();
        this.createOrRetrieveRegion();
        this.operatingRegion = this.getSessionManager().getEnableLocalCache() ? this.createOrRetrieveLocalRegion() : this.sessionRegion;
        this.createStatistics();
    }

    @Override
    public String getDefaultRegionAttributesId() {
        return DEFAULT_REGION_ATTRIBUTES_ID;
    }

    @Override
    public boolean getDefaultEnableLocalCache() {
        return false;
    }

    @Override
    public void touchSessions(Set<String> sessionIds) {
        Execution execution;
        String regionAttributesID = this.getSessionManager().getRegionAttributesId().toLowerCase();
        ResultCollector collector = null;
        if (regionAttributesID.startsWith("partition")) {
            execution = FunctionService.onRegion(this.getSessionRegion()).withFilter(sessionIds);
            collector = execution.execute("touch-partitioned-region-entries", true, false, true);
        } else {
            execution = FunctionService.onMembers((DistributedSystem)this.getCache().getDistributedSystem()).withArgs((Object)new Object[]{this.sessionRegion.getFullPath(), sessionIds});
            collector = execution.execute("touch-replicated-region-entries", true, false, false);
        }
        try {
            collector.getResult();
        }
        catch (Exception e) {
            this.getSessionManager().getLogger().warn((Object)"Caught unexpected exception:", (Throwable)e);
        }
    }

    @Override
    public boolean isPeerToPeer() {
        return true;
    }

    @Override
    public boolean isClientServer() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return this.getSessionRegion().keySet();
    }

    @Override
    public int size() {
        return this.getSessionRegion().size();
    }

    @Override
    public GemFireCache getCache() {
        return this.cache;
    }

    @Override
    public boolean isBackingCacheAvailable() {
        return true;
    }

    private void registerFunctions() {
        if (!FunctionService.isRegistered((String)"touch-partitioned-region-entries")) {
            FunctionService.registerFunction((Function)new TouchPartitionedRegionEntriesFunction());
        }
        if (!FunctionService.isRegistered((String)"touch-replicated-region-entries")) {
            FunctionService.registerFunction((Function)new TouchReplicatedRegionEntriesFunction());
        }
    }

    protected void createOrRetrieveRegion() {
        RegionConfiguration configuration = this.createRegionConfiguration();
        configuration.setSessionExpirationCacheListener(true);
        Region region = this.cache.getRegion(this.getSessionManager().getRegionName());
        if (region == null) {
            region = RegionHelper.createRegion((Cache)this.getCache(), configuration);
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Created new session region: " + region));
            }
        } else {
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Retrieved existing session region: " + region));
            }
            RegionHelper.validateRegion((Cache)this.getCache(), configuration, region);
        }
        this.sessionRegion = region;
    }

    private Region<String, HttpSession> createOrRetrieveLocalRegion() {
        String frontingRegionName = this.sessionRegion.getName() + "_local";
        Region frontingRegion = this.cache.getRegion(frontingRegionName);
        if (frontingRegion == null) {
            RegionFactory factory = this.cache.createRegionFactory(RegionShortcut.LOCAL_HEAP_LRU);
            factory.setCacheLoader((CacheLoader)new LocalSessionCacheLoader((Region<String, HttpSession>)this.sessionRegion));
            factory.setCacheWriter((CacheWriter)new LocalSessionCacheWriter((Region<String, HttpSession>)this.sessionRegion));
            int maxInactiveInterval = this.getSessionManager().getMaxInactiveInterval();
            if (maxInactiveInterval != -1) {
                factory.setStatisticsEnabled(true);
                factory.setCustomEntryIdleTimeout((CustomExpiry)new SessionCustomExpiry());
                factory.addCacheListener((CacheListener)new SessionExpirationCacheListener());
            }
            frontingRegion = factory.create(frontingRegionName);
            if (this.getSessionManager().getLogger().isDebugEnabled()) {
                this.getSessionManager().getLogger().debug((Object)("Created new local session region: " + frontingRegion));
            }
        } else if (this.getSessionManager().getLogger().isDebugEnabled()) {
            this.getSessionManager().getLogger().debug((Object)("Retrieved existing local session region: " + frontingRegion));
        }
        return frontingRegion;
    }
}

