/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.bootstrap;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.modules.session.bootstrap.AbstractCache;
import com.gemstone.gemfire.modules.util.RegionHelper;

public class PeerToPeerCache
extends AbstractCache {
    protected static final String DEFAULT_CACHE_XML_FILE_NAME = "cache-peer.xml";

    private PeerToPeerCache() {
    }

    public static AbstractCache getInstance() {
        return instance;
    }

    @Override
    protected void createOrRetrieveCache() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating cache");
        }
        try {
            this.cache = CacheFactory.getAnyInstance();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        String message = null;
        if (this.cache == null) {
            this.cache = new CacheFactory(this.createDistributedSystemProperties()).create();
            message = "Created ";
        } else {
            message = "Retrieved ";
        }
        this.getLogger().info(message + this.cache);
    }

    @Override
    protected void rebalanceCache() {
        try {
            this.getLogger().info("Rebalancing: " + this.cache);
            RebalanceResults results = RegionHelper.rebalanceCache(this.cache);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Done rebalancing: " + this.cache);
                this.getLogger().debug(RegionHelper.getRebalanceResultsMessage(results));
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Rebalance failed because of the following exception:", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultCacheXmlFileName() {
        return DEFAULT_CACHE_XML_FILE_NAME;
    }

    static {
        instance = new PeerToPeerCache();
    }
}

