/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.gatewaydelta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.modules.gatewaydelta.GatewayDeltaEvent;
import java.util.Properties;

public class GatewayDeltaEventApplicationCacheListener
extends CacheListenerAdapter<String, GatewayDeltaEvent>
implements Declarable {
    private final Cache cache = CacheFactory.getAnyInstance();

    public void afterCreate(EntryEvent<String, GatewayDeltaEvent> event) {
        System.out.println("GatewayDeltaApplierCacheListener event: " + event);
        EntryEventImpl eventImpl = (EntryEventImpl)event;
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaApplierCacheListener: Received event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(".");
            this.cache.getLogger().fine(builder.toString());
        }
        Object callbackArgument = eventImpl.getRawCallbackArgument();
        System.out.println("GatewayDeltaApplierCacheListener callbackArgument: " + callbackArgument);
        if (callbackArgument instanceof GatewaySenderEventCallbackArgument) {
            GatewayDeltaEvent delta = (GatewayDeltaEvent)event.getNewValue();
            delta.apply(this.cache);
            System.out.println("Applied " + delta);
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaApplierCacheListener: Applied ").append(delta);
                this.cache.getLogger().fine(builder.toString());
            }
        }
    }

    public void init(Properties p) {
    }
}

