/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.catalina;

import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.modules.session.catalina.SessionCache;
import com.gemstone.gemfire.modules.session.catalina.SessionManager;
import com.gemstone.gemfire.modules.session.catalina.internal.DeltaSessionStatistics;
import com.gemstone.gemfire.modules.util.RegionConfiguration;
import com.gemstone.gemfire.modules.util.SessionCustomExpiry;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;

public abstract class AbstractSessionCache
implements SessionCache {
    protected SessionManager sessionManager;
    protected Region<String, HttpSession> sessionRegion;
    protected Region<String, HttpSession> operatingRegion;
    protected DeltaSessionStatistics statistics;

    public AbstractSessionCache(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public String getSessionRegionName() {
        return this.getSessionRegion().getFullPath();
    }

    @Override
    public String getOperatingRegionName() {
        return this.getOperatingRegion().getFullPath();
    }

    @Override
    public void putSession(Session session) {
        this.getOperatingRegion().put((Object)session.getId(), (Object)((HttpSession)session));
    }

    @Override
    public HttpSession getSession(String sessionId) {
        return (HttpSession)this.getOperatingRegion().get((Object)sessionId);
    }

    @Override
    public void destroySession(String sessionId) {
        try {
            this.getOperatingRegion().destroy((Object)sessionId);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public DeltaSessionStatistics getStatistics() {
        return this.statistics;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public Region<String, HttpSession> getSessionRegion() {
        return this.sessionRegion;
    }

    @Override
    public Region<String, HttpSession> getOperatingRegion() {
        return this.operatingRegion;
    }

    protected void createStatistics() {
        this.statistics = new DeltaSessionStatistics((StatisticsFactory)this.getCache().getDistributedSystem(), this.getSessionManager().getStatisticsName());
    }

    protected RegionConfiguration createRegionConfiguration() {
        RegionConfiguration configuration = new RegionConfiguration();
        configuration.setRegionName(this.getSessionManager().getRegionName());
        configuration.setRegionAttributesId(this.getSessionManager().getRegionAttributesId());
        if (this.getSessionManager().getMaxInactiveInterval() != -1) {
            configuration.setMaxInactiveInterval(this.getSessionManager().getMaxInactiveInterval());
            configuration.setCustomExpiry(new SessionCustomExpiry());
        }
        configuration.setEnableGatewayDeltaReplication(this.getSessionManager().getEnableGatewayDeltaReplication());
        configuration.setEnableGatewayReplication(this.getSessionManager().getEnableGatewayReplication());
        configuration.setEnableDebugListener(this.getSessionManager().getEnableDebugListener());
        return configuration;
    }
}

