/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.KeyWrapper;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ResponseStatus;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.AbstractCommand;
import org.apache.geode.memcached.GemFireMemcachedServer;

public class DeleteCommand
extends AbstractCommand {
    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request.getRequest(), cache);
        }
        return this.processBinaryCommand(request, cache);
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        assert ("delete".equals(firstLineElements[0]));
        String key = this.stripNewline(firstLineElements[1]);
        boolean noReply = firstLineElements.length > 2;
        Region<Object, ValueWrapper> r = DeleteCommand.getMemcachedRegion(cache);
        String reply = null;
        try {
            r.destroy((Object)key);
            reply = Reply.DELETED.toString();
        }
        catch (EntryNotFoundException e) {
            reply = Reply.NOT_FOUND.toString();
        }
        return noReply ? null : asciiCharset.encode(reply);
    }

    private ByteBuffer processBinaryCommand(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        ByteBuffer response = request.getResponse();
        KeyWrapper key = this.getKey(buffer, 24);
        Region<Object, ValueWrapper> r = DeleteCommand.getMemcachedRegion(cache);
        try {
            r.destroy((Object)key);
            if (this.isQuiet()) {
                return null;
            }
            response.putShort(6, ResponseStatus.NO_ERROR.asShort());
        }
        catch (EntryNotFoundException e) {
            response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
        }
        catch (Exception e) {
            response = this.handleBinaryException(key, request, response, "delete", e);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("delete:key:" + String.valueOf(key));
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

