/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import java.nio.ByteBuffer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ResponseStatus;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.StorageCommand;

public class AppendCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key, byte[] value, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = AppendCommand.getMemcachedRegion(cache);
        ValueWrapper oldValWrapper = (ValueWrapper)r.get((Object)key);
        String retVal = Reply.NOT_FOUND.toString();
        if (oldValWrapper != null) {
            byte[] appendVal = value;
            byte[] oldVal = oldValWrapper.getValue();
            byte[] newVal = new byte[oldVal.length + appendVal.length];
            System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
            System.arraycopy(appendVal, 0, newVal, oldVal.length, appendVal.length);
            r.put((Object)key, (Object)ValueWrapper.getWrappedValue(newVal, flags));
            retVal = Reply.STORED.toString();
        }
        return asciiCharset.encode(retVal);
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key, byte[] value, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = AppendCommand.getMemcachedRegion(cache);
        try {
            ValueWrapper oldValWrapper = (ValueWrapper)r.get(key);
            if (oldValWrapper != null) {
                byte[] appendVal = value;
                byte[] oldVal = oldValWrapper.getValue();
                byte[] newVal = new byte[oldVal.length + appendVal.length];
                System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
                System.arraycopy(appendVal, 0, newVal, oldVal.length, appendVal.length);
                ValueWrapper val = ValueWrapper.getWrappedValue(newVal, flags);
                try {
                    r.put(key, (Object)val);
                    if (this.isQuiet()) {
                        return null;
                    }
                    response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                    response.putLong(16, val.getVersion());
                }
                catch (Exception e) {
                    response = this.handleBinaryException(key, request, response, "append", e);
                }
            } else {
                response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key, request, response, "append", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

