/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import java.nio.ByteBuffer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ResponseStatus;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.StorageCommand;

public class AddCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key, byte[] value, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = AddCommand.getMemcachedRegion(cache);
        Object oldVal = r.putIfAbsent((Object)key, (Object)ValueWrapper.getWrappedValue(value, flags));
        String reply = null;
        reply = oldVal == null ? Reply.STORED.toString() : Reply.NOT_STORED.toString();
        return asciiCharset.encode(reply);
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key, byte[] value, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = AddCommand.getMemcachedRegion(cache);
        ValueWrapper val = ValueWrapper.getWrappedValue(value, flags);
        try {
            Object oldVal = r.putIfAbsent(key, (Object)val);
            if (oldVal == null) {
                if (this.getLogger().fineEnabled()) {
                    this.getLogger().fine("added key: " + key);
                }
                if (this.isQuiet()) {
                    return null;
                }
                response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                response.putLong(16, val.getVersion());
            } else {
                if (this.getLogger().fineEnabled()) {
                    this.getLogger().fine("key: " + key + " not added as is already exists");
                }
                response.putShort(6, ResponseStatus.KEY_EXISTS.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key, request, response, "add", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

