/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.AbstractCommand;
import org.apache.geode.memcached.GemFireMemcachedServer;

public class CASCommand
extends AbstractCommand {
    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request.getRequest(), cache);
        }
        throw new IllegalStateException();
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        ValueWrapper expected;
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        String key = firstLineElements[1];
        int flags = Integer.parseInt(firstLineElements[2]);
        long expTime = Long.parseLong(firstLineElements[3]);
        int numBytes = Integer.parseInt(firstLineElements[4]);
        long casVersion = Long.parseLong(this.stripNewline(firstLineElements[5]));
        byte[] value = new byte[numBytes];
        buffer.position(firstLine.length());
        for (int i = 0; i < numBytes; ++i) {
            value[i] = buffer.get();
        }
        String reply = Reply.EXISTS.toString();
        Region<Object, ValueWrapper> r = CASCommand.getMemcachedRegion(cache);
        if (r.replace((Object)key, (Object)(expected = ValueWrapper.getDummyValue(casVersion)), (Object)ValueWrapper.getWrappedValue(value, flags))) {
            reply = Reply.STORED.toString();
        }
        return asciiCharset.encode(reply);
    }
}

