/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class FindCoordinatorResponse<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID>
implements DataSerializableFixedID {
    private ID coordinator;
    private ID senderId;
    private boolean fromView;
    private GMSMembershipView<ID> view;
    private Set<ID> registrants;
    private boolean networkPartitionDetectionEnabled;
    private boolean usePreferredCoordinators;
    private boolean isShortForm;
    private byte[] coordinatorPublicKey;
    private String rejectionMessage;
    private int requestId;

    public FindCoordinatorResponse(ID coordinator, ID senderId, boolean fromView, GMSMembershipView<ID> view, HashSet<ID> registrants, boolean networkPartitionDectionEnabled, boolean usePreferredCoordinators, byte[] pk) {
        this.coordinator = coordinator;
        this.senderId = senderId;
        this.fromView = fromView;
        this.view = view;
        this.registrants = registrants;
        this.networkPartitionDetectionEnabled = networkPartitionDectionEnabled;
        this.usePreferredCoordinators = usePreferredCoordinators;
        this.isShortForm = false;
        this.coordinatorPublicKey = pk;
    }

    public FindCoordinatorResponse(ID coordinator, ID senderId, byte[] pk, int requestId) {
        this.coordinator = coordinator;
        this.senderId = senderId;
        this.isShortForm = true;
        this.coordinatorPublicKey = pk;
        this.requestId = requestId;
    }

    public FindCoordinatorResponse(String m) {
        this.rejectionMessage = m;
    }

    public FindCoordinatorResponse() {
    }

    public byte[] getCoordinatorPublicKey() {
        return this.coordinatorPublicKey;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public boolean isUsePreferredCoordinators() {
        return this.usePreferredCoordinators;
    }

    public ID getCoordinator() {
        return this.coordinator;
    }

    public ID getSenderId() {
        return this.senderId;
    }

    public boolean isFromView() {
        return this.fromView;
    }

    public GMSMembershipView<ID> getView() {
        return this.view;
    }

    public Set<ID> getRegistrants() {
        return this.registrants;
    }

    public String toString() {
        if (this.isShortForm) {
            return "FindCoordinatorResponse(coordinator=" + String.valueOf(this.coordinator) + "; senderId=" + String.valueOf(this.senderId) + ")";
        }
        return "FindCoordinatorResponse(coordinator=" + String.valueOf(this.coordinator) + ", fromView=" + this.fromView + ", viewId=" + String.valueOf(this.view == null ? "null" : Integer.valueOf(this.view.getViewId())) + ", registrants=" + String.valueOf(this.registrants == null ? "none" : this.registrants) + ", senderId=" + String.valueOf(this.senderId) + ", network partition detection enabled=" + this.networkPartitionDetectionEnabled + ", locators preferred as coordinators=" + this.usePreferredCoordinators + ", view=" + String.valueOf(this.view) + ")";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return -144;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.coordinator, out);
        context.getSerializer().writeObject(this.senderId, out);
        StaticSerialization.writeByteArray((byte[])this.coordinatorPublicKey, (DataOutput)out);
        StaticSerialization.writeString((String)this.rejectionMessage, (DataOutput)out);
        out.writeBoolean(this.isShortForm);
        out.writeBoolean(this.fromView);
        out.writeBoolean(this.networkPartitionDetectionEnabled);
        out.writeBoolean(this.usePreferredCoordinators);
        context.getSerializer().writeObject(this.view, out);
        GMSUtil.writeSetOfMemberIDs(this.registrants, out, context);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.coordinator = (MemberIdentifier)context.getDeserializer().readObject(in);
        this.senderId = (MemberIdentifier)context.getDeserializer().readObject(in);
        this.coordinatorPublicKey = StaticSerialization.readByteArray((DataInput)in);
        this.rejectionMessage = StaticSerialization.readString((DataInput)in);
        this.isShortForm = in.readBoolean();
        if (!this.isShortForm) {
            this.fromView = in.readBoolean();
            this.networkPartitionDetectionEnabled = in.readBoolean();
            this.usePreferredCoordinators = in.readBoolean();
            this.view = (GMSMembershipView)context.getDeserializer().readObject(in);
            this.registrants = GMSUtil.readHashSetOfMemberIDs(in, context);
        }
    }

    public int hashCode() {
        return Objects.hash(this.senderId, this.view, this.registrants, this.requestId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FindCoordinatorResponse other = (FindCoordinatorResponse)obj;
        if (this.coordinator == null ? other.coordinator != null : !this.coordinator.equals(other.coordinator)) {
            return false;
        }
        if (!Arrays.equals(this.coordinatorPublicKey, other.coordinatorPublicKey)) {
            return false;
        }
        if (this.fromView != other.fromView) {
            return false;
        }
        if (this.isShortForm != other.isShortForm) {
            return false;
        }
        if (this.networkPartitionDetectionEnabled != other.networkPartitionDetectionEnabled) {
            return false;
        }
        if (this.registrants == null ? other.registrants != null : !this.registrants.equals(other.registrants)) {
            return false;
        }
        if (this.senderId == null ? other.senderId != null : !this.senderId.equals(other.senderId)) {
            return false;
        }
        if (this.usePreferredCoordinators != other.usePreferredCoordinators) {
            return false;
        }
        if (this.view == null) {
            return other.view == null;
        }
        return this.view.equals(other.view);
    }
}

