/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.messenger.JGroupsMessenger;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.UDP;
import org.jgroups.util.AsciiString;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.LazyThreadFactory;

public class Transport<ID extends MemberIdentifier>
extends UDP {
    public static final String THREAD_POOL_NAME_PREFIX = "Geode UDP";
    private JGroupsMessenger<ID> messenger;

    public void setMessenger(JGroupsMessenger<ID> m) {
        this.messenger = m;
    }

    protected void _send(Message msg, Address dest) {
        try {
            this.send(msg, dest);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (InterruptedException interruptedEx) {
            Thread.currentThread().interrupt();
        }
        catch (SocketException e) {
            if (!this.sock.isClosed() && !this.stack.getChannel().isClosed()) {
                this.log.error("Exception caught while sending message", (Throwable)e);
            }
        }
        catch (IOException e) {
            if (this.messenger != null) {
                this.messenger.handleJGroupsIOException(e, dest);
            }
        }
        catch (Throwable e) {
            this.log.error("Exception caught while sending message", e);
        }
    }

    protected void doSend(AsciiString cluster_name, byte[] buf, int offset, int length, Address dest) throws Exception {
        try {
            super.doSend(cluster_name, buf, offset, length, dest);
        }
        catch (SocketException sock_ex) {
            if (!this.sock.isClosed() && !this.stack.getChannel().isClosed()) {
                this.log.error("Exception caught while sending message", (Throwable)sock_ex);
            }
        }
        catch (IOException e) {
            if (this.messenger != null) {
                this.messenger.handleJGroupsIOException(e, dest);
            }
        }
        catch (Throwable e) {
            this.log.error("Exception caught while sending message", e);
        }
    }

    public void init() throws Exception {
        this.global_thread_factory = new DefaultThreadFactory("Geode ", true);
        this.timer_thread_factory = new LazyThreadFactory("Geode UDP Timer", true, true);
        this.default_thread_factory = new DefaultThreadFactory("Geode UDP Incoming", true, true);
        this.oob_thread_factory = new DefaultThreadFactory("Geode UDP OOB", true, true);
        this.internal_thread_factory = new DefaultThreadFactory("Geode UDP INT", true, true);
        super.init();
    }

    public void stop() {
        if (!this.getTimer().isShutdown()) {
            this.getTimer().stop();
        }
        super.stop();
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        if (data == null || length <= 0) {
            return;
        }
        if (this.local_physical_addr != null && this.local_physical_addr.equals(sender)) {
            return;
        }
        if (length - offset == 4 && data[offset] == 112 && data[offset + 1] == 105 && data[offset + 2] == 110 && data[offset + 3] == 103) {
            data[offset + 1] = 111;
            try {
                this.sendToSingleMember(sender, data, offset, length);
            }
            catch (Exception e) {
                this.log.fatal("Unable to respond to available-port check", (Throwable)e);
            }
            return;
        }
        super.receive(sender, data, offset, length);
    }
}

