/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.fd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipStatistics;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.HealthMonitor;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.FinalCheckPassedMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HeartbeatMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HeartbeatRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectMembersMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectRequest;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.lang.JavaWorkarounds;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.logging.log4j.Logger;
import org.jgroups.util.UUID;

public class GMSHealthMonitor<ID extends MemberIdentifier>
implements HealthMonitor<ID> {
    private final TcpSocketCreator socketCreator;
    private Services<ID> services;
    private volatile GMSMembershipView<ID> currentView;
    private volatile ID nextNeighbor;
    long memberTimeout;
    private volatile boolean isStopping = false;
    private final AtomicInteger requestId = new AtomicInteger();
    private static final Logger logger = Services.getLogger();
    private static final int NUM_HEARTBEATS = Integer.getInteger("geode.heartbeat-recipients", 2);
    public static final int LOGICAL_INTERVAL = Integer.getInteger("geode.logical-message-received-interval", 2);
    public static final long MEMBER_SUSPECT_COLLECTION_INTERVAL = Long.getLong("geode.suspect-member-collection-interval", 200L);
    @VisibleForTesting
    volatile long currentTimeStamp;
    private ID localAddress;
    final ConcurrentMap<ID, TimeStamp> memberTimeStamps = new ConcurrentHashMap<ID, TimeStamp>();
    private final ConcurrentHashMap<ID, GMSMembershipView<ID>> suspectedMemberIds = new ConcurrentHashMap();
    @VisibleForTesting
    final List<ID> membersInFinalCheck = Collections.synchronizedList(new ArrayList(30));
    private final Map<Integer, Response> requestIdVsResponse = new ConcurrentHashMap<Integer, Response>();
    private final Map<GMSMembershipView<ID>, Set<SuspectRequest<ID>>> suspectRequestsInView = new HashMap<GMSMembershipView<ID>, Set<SuspectRequest<ID>>>();
    private ScheduledExecutorService scheduler;
    private ExecutorService checkExecutor;
    private ScheduledFuture<?> monitorFuture;
    private volatile boolean playingDead = false;
    private volatile boolean beingSick = false;
    private ExecutorService serverSocketExecutor;
    static final int OK = 123;
    static final int ERROR = 0;
    private volatile int socketPort;
    private volatile ServerSocket serverSocket;
    private MembershipStatistics stats;
    private long monitorInterval;

    public GMSHealthMonitor(TcpSocketCreator socketCreator) {
        Objects.requireNonNull(socketCreator);
        this.socketCreator = socketCreator;
    }

    @Override
    public void contactedBy(ID sender) {
        this.contactedBy(sender, this.currentTimeStamp);
    }

    private void contactedBy(ID sender, long timeStamp) {
        TimeStamp cTS = (TimeStamp)JavaWorkarounds.computeIfAbsent(this.memberTimeStamps, sender, s -> new TimeStamp(timeStamp));
        if (cTS != null && cTS.getTime() < timeStamp) {
            cTS.setTime(timeStamp);
        }
        if (this.suspectedMemberIds.containsKey(sender)) {
            this.memberUnsuspected(sender);
            this.setNextNeighbor(this.currentView, null);
        }
    }

    private HeartbeatRequestMessage<ID> constructHeartbeatRequestMessage(ID mbr) {
        int reqId = this.requestId.getAndIncrement();
        HeartbeatRequestMessage<ID> hrm = new HeartbeatRequestMessage<ID>(mbr, reqId);
        hrm.setRecipient(mbr);
        return hrm;
    }

    private void checkMember(ID mbr) {
        GMSMembershipView<ID> cv = this.currentView;
        this.setNextNeighbor(cv, mbr);
        this.checkExecutor.execute(() -> {
            boolean pinged;
            try {
                pinged = this.doCheckMember(mbr, true);
            }
            catch (MembershipClosedException e) {
                return;
            }
            if (!pinged) {
                String reason = "Member isn't responding to heartbeat requests";
                this.memberSuspected(this.localAddress, mbr, reason);
                this.initiateSuspicion(mbr, reason);
                this.setNextNeighbor(this.currentView, null);
            } else {
                logger.trace("Setting next neighbor as member {} has responded.", (Object)mbr);
                this.memberUnsuspected(mbr);
                this.setNextNeighbor(this.currentView, null);
            }
        });
    }

    private void initiateSuspicion(ID mbr, String reason) {
        if (this.services.getJoinLeave().isMemberLeaving(mbr)) {
            return;
        }
        this.sendSuspectRequest(Collections.singletonList(new SuspectRequest<ID>(mbr, reason)));
    }

    /*
     * Exception decompiling
     */
    private boolean doCheckMember(ID member, boolean waitForResponse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doTCPCheckMember(ID suspectMember, int port, boolean retryIfConnectFails) {
        Socket clientSocket = null;
        long giveupTime = System.currentTimeMillis() + this.services.getConfig().getMemberTimeout();
        boolean passed = false;
        int iteration = 0;
        do {
            if (++iteration > 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            try {
                logger.debug("Checking member {} with TCP socket connection {}:{}.", suspectMember, (Object)suspectMember.getInetAddress(), (Object)port);
                clientSocket = this.socketCreator.forAdvancedUse().connect(new HostAndPort(suspectMember.getHostName(), port), (int)this.memberTimeout, (ConnectionWatcher)new ConnectTimeoutTask(this.services.getTimer(), this.memberTimeout), false, -1, false);
                clientSocket.setTcpNoDelay(true);
                passed = this.doTCPCheckMember(suspectMember, clientSocket);
            }
            catch (IOException e) {
            }
            catch (IllegalStateException e) {
                if (this.isStopping) continue;
                logger.trace("Unexpected exception", (Throwable)e);
            }
            finally {
                try {
                    if (clientSocket != null) {
                        clientSocket.setSoLinger(true, 0);
                        clientSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        } while (retryIfConnectFails && !passed && !this.isShutdown() && System.currentTimeMillis() < giveupTime);
        return passed;
    }

    boolean doTCPCheckMember(ID suspectMember, Socket clientSocket) {
        try {
            if (clientSocket.isConnected()) {
                clientSocket.setSoTimeout((int)this.services.getConfig().getMemberTimeout());
                InputStream in = clientSocket.getInputStream();
                DataOutputStream out = new DataOutputStream(clientSocket.getOutputStream());
                ID gmbr = suspectMember;
                this.writeMemberToStream(gmbr, out);
                this.stats.incFinalCheckRequestsSent();
                this.stats.incTcpFinalCheckRequestsSent();
                logger.debug("Connected to suspect member - reading response");
                int b = in.read();
                if (logger.isDebugEnabled()) {
                    logger.debug("Received {}", (Object)(b == 123 ? "OK" : (b == 0 ? "ERROR" : "unknown response: " + b)));
                }
                if (b >= 0) {
                    this.stats.incFinalCheckResponsesReceived();
                    this.stats.incTcpFinalCheckResponsesReceived();
                }
                if (b == 123) {
                    TimeStamp ts = (TimeStamp)this.memberTimeStamps.get(suspectMember);
                    if (ts != null) {
                        ts.setTime(System.currentTimeMillis());
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SocketTimeoutException e) {
            logger.debug("Availability check TCP/IP connection timed out for suspect member {}", suspectMember);
            return false;
        }
        catch (IOException e) {
            logger.trace("Unexpected exception", (Throwable)e);
            return false;
        }
    }

    void writeMemberToStream(ID gmbr, DataOutputStream out) throws IOException {
        out.writeShort(Version.getCurrentVersion().ordinal());
        out.writeInt(gmbr.getVmViewId());
        out.writeLong(gmbr.getUuidLeastSignificantBits());
        out.writeLong(gmbr.getUuidMostSignificantBits());
        out.flush();
    }

    @Override
    public void suspect(ID mbr, String reason) {
        this.initiateSuspicion(mbr, reason);
    }

    @Override
    public boolean checkIfAvailable(ID mbr, String reason, boolean initiateRemoval) {
        if (this.membersInFinalCheck.contains(mbr)) {
            return true;
        }
        return this.inlineCheckIfAvailable(this.localAddress, this.currentView, initiateRemoval, mbr, reason);
    }

    @Override
    public void start() throws MemberStartupException {
        this.scheduler = LoggingExecutors.newScheduledThreadPool((String)"Geode Failure Detection Scheduler", (int)1);
        this.checkExecutor = LoggingExecutors.newCachedThreadPool((String)"Geode Failure Detection thread ", (boolean)true);
        Monitor m = new Monitor(this.memberTimeout);
        this.monitorInterval = this.memberTimeout / (long)LOGICAL_INTERVAL;
        this.monitorFuture = this.scheduler.scheduleAtFixedRate(m, this.monitorInterval, this.monitorInterval, TimeUnit.MILLISECONDS);
        this.serverSocketExecutor = LoggingExecutors.newCachedThreadPool((String)"Geode Failure Detection Server thread ", (boolean)true);
    }

    ServerSocket createServerSocket(InetAddress socketAddress, int[] portRange) throws IOException {
        ServerSocket newSocket = this.socketCreator.forAdvancedUse().createServerSocketUsingPortRange(socketAddress, 50, true, false, 65536, portRange, false);
        this.socketPort = newSocket.getLocalPort();
        return newSocket;
    }

    private void startTcpServer(ServerSocket ssocket) {
        this.serverSocketExecutor.execute(() -> {
            logger.info("Started failure detection server thread on {}:{}.", (Object)ssocket.getInetAddress(), (Object)this.socketPort);
            Socket socket = null;
            try {
                while (!this.services.getCancelCriterion().isCancelInProgress() && !this.isStopping) {
                    try {
                        socket = ssocket.accept();
                        if (this.playingDead) continue;
                        this.serverSocketExecutor.execute(new ClientSocketHandler(socket));
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                    }
                    catch (IOException e) {
                        if (!this.isStopping) {
                            logger.trace("Unexpected exception", (Throwable)e);
                        }
                        try {
                            if (socket == null) continue;
                            socket.close();
                        }
                        catch (IOException ioe) {
                            logger.trace("Unexpected exception", (Throwable)ioe);
                        }
                    }
                }
                logger.info("GMSHealthMonitor server thread exiting");
                return;
            }
            finally {
                if (!ssocket.isClosed()) {
                    try {
                        ssocket.close();
                    }
                    catch (IOException e) {
                        logger.debug("Unexpected exception", (Throwable)e);
                    }
                }
            }
        });
    }

    private void startHeartbeatThread() {
        this.checkExecutor.execute(new Heart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void installView(GMSMembershipView<ID> newView) {
        Map<GMSMembershipView<ID>, Set<SuspectRequest<ID>>> map = this.suspectRequestsInView;
        synchronized (map) {
            this.suspectRequestsInView.clear();
        }
        Iterator it = this.memberTimeStamps.keySet().iterator();
        while (it.hasNext()) {
            if (newView.contains((MemberIdentifier)it.next())) continue;
            it.remove();
        }
        it = ((ConcurrentHashMap.KeySetView)this.suspectedMemberIds.keySet()).iterator();
        while (it.hasNext()) {
            if (newView.contains((MemberIdentifier)it.next())) continue;
            it.remove();
        }
        this.currentView = newView;
        this.setNextNeighbor(newView, null);
    }

    public synchronized GMSMembershipView<ID> getView() {
        return this.currentView;
    }

    protected synchronized void setNextNeighbor(GMSMembershipView<ID> newView, ID nextTo) {
        int index;
        List<ID> allMembers;
        if (newView == null) {
            return;
        }
        if (nextTo == null) {
            nextTo = this.localAddress;
        }
        if ((allMembers = newView.getMembers()).size() > 1 && this.suspectedMemberIds.size() >= allMembers.size() - 1) {
            boolean nonSuspectFound = false;
            for (MemberIdentifier member : allMembers) {
                if (member.equals(this.localAddress) || this.suspectedMemberIds.containsKey(member)) continue;
                nonSuspectFound = true;
                break;
            }
            if (!nonSuspectFound) {
                logger.info("All other members are suspect at this point");
                this.nextNeighbor = null;
                return;
            }
        }
        if ((index = allMembers.indexOf(nextTo)) != -1) {
            int nextNeighborIndex = (index + 1) % allMembers.size();
            MemberIdentifier newNeighbor = (MemberIdentifier)allMembers.get(nextNeighborIndex);
            if (this.suspectedMemberIds.containsKey(newNeighbor)) {
                this.setNextNeighbor(newView, newNeighbor);
                return;
            }
            ID oldNeighbor = this.nextNeighbor;
            if (oldNeighbor != newNeighbor) {
                logger.debug("Failure detection is now watching " + newNeighbor);
                this.nextNeighbor = newNeighbor;
            }
        }
        if (this.nextNeighbor != null && this.nextNeighbor.equals(this.localAddress)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Health monitor is unable to find a neighbor to watch.  Current suspects are {}", (Object)this.suspectedMemberIds.keySet());
            }
            this.nextNeighbor = null;
        }
    }

    public ID getNextNeighbor() {
        return this.nextNeighbor;
    }

    @Override
    public void init(Services<ID> s) throws MembershipConfigurationException {
        this.isStopping = false;
        this.services = s;
        this.memberTimeout = s.getConfig().getMemberTimeout();
        this.stats = this.services.getStatistics();
        this.services.getMessenger().addHandler(HeartbeatRequestMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(HeartbeatMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(SuspectMembersMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(FinalCheckPassedMessage.class, this::processMessage);
    }

    @Override
    public void started() throws MemberStartupException {
        this.setLocalAddress(this.services.getMessenger().getMemberID());
        try {
            this.serverSocket = this.createServerSocket(this.localAddress.getInetAddress(), this.services.getConfig().getMembershipPortRange());
        }
        catch (IOException e) {
            throw new MemberStartupException("Problem creating HealthMonitor socket", e);
        }
        this.startTcpServer(this.serverSocket);
        this.startHeartbeatThread();
    }

    @Override
    public void stop() {
        this.stopServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServices() {
        logger.debug("Stopping HealthMonitor");
        this.isStopping = true;
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        Collection<Response> val = this.requestIdVsResponse.values();
        Iterator<Response> iterator = val.iterator();
        while (iterator.hasNext()) {
            Response r;
            Response response = r = iterator.next();
            synchronized (response) {
                r.notify();
            }
        }
        if (this.checkExecutor != null) {
            this.checkExecutor.shutdown();
        }
        this.stopServer();
    }

    void stopServer() {
        if (this.serverSocketExecutor != null) {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    logger.trace("Unexpected exception", (Throwable)e);
                }
            }
            this.serverSocketExecutor.shutdownNow();
            try {
                this.serverSocketExecutor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown() && this.checkExecutor.isShutdown() && this.serverSocketExecutor.isShutdown();
    }

    public boolean isSuspectMember(ID m) {
        return this.suspectedMemberIds.containsKey(m);
    }

    @Override
    public void stopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberSuspected(ID initiator, ID suspect, String reason) {
        Map<GMSMembershipView<ID>, Set<SuspectRequest<ID>>> map = this.suspectRequestsInView;
        synchronized (map) {
            this.suspectedMemberIds.put(suspect, this.currentView);
            HashSet<SuspectRequest<ID>> requests = (HashSet<SuspectRequest<ID>>)this.suspectRequestsInView.get(this.currentView);
            boolean found = false;
            if (requests == null) {
                requests = new HashSet<SuspectRequest<ID>>();
                requests.add(new SuspectRequest<ID>(suspect, reason));
            }
            for (SuspectRequest suspectRequest : requests) {
                if (!suspect.equals(suspectRequest.getSuspectMember())) continue;
                found = true;
                break;
            }
            if (!found) {
                requests.add(new SuspectRequest<ID>(suspect, reason));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberUnsuspected(ID mbr) {
        Map<GMSMembershipView<ID>, Set<SuspectRequest<ID>>> map = this.suspectRequestsInView;
        synchronized (map) {
            Collection suspectRequests;
            if (this.suspectedMemberIds.remove(mbr) != null) {
                logger.info("No longer suspecting {}", mbr);
            }
            if ((suspectRequests = (Collection)this.suspectRequestsInView.get(this.currentView)) != null) {
                ArrayList<SuspectRequest> removals = new ArrayList<SuspectRequest>(suspectRequests.size());
                for (SuspectRequest suspectRequest : suspectRequests) {
                    if (!mbr.equals(suspectRequest.getSuspectMember())) continue;
                    removals.add(suspectRequest);
                }
                suspectRequests.removeAll(removals);
            }
        }
    }

    @Override
    public void beSick() {
        this.beingSick = true;
    }

    @Override
    public void playDead() {
        this.playingDead = true;
    }

    @Override
    public void beHealthy() {
        this.beingSick = false;
        this.playingDead = false;
    }

    @Override
    public void emergencyClose() {
        this.stopServices();
    }

    @Override
    public void setLocalAddress(ID idm) {
        this.localAddress = idm;
    }

    void processMessage(HeartbeatRequestMessage<ID> m) {
        if (this.isStopping) {
            return;
        }
        if (this.beingSick || this.playingDead) {
            logger.debug("sick member is ignoring check request");
            return;
        }
        this.stats.incHeartbeatRequestsReceived();
        if (this.isStopping) {
            return;
        }
        ID me = this.localAddress;
        if (me == null || me.getVmViewId() >= 0 && m.getTarget().equals(me)) {
            HeartbeatMessage hm = new HeartbeatMessage(m.getRequestId());
            hm.setRecipient(m.getSender());
            Set<ID> membersNotReceivedMsg = this.services.getMessenger().send(hm);
            this.stats.incHeartbeatsSent();
            if (membersNotReceivedMsg != null && membersNotReceivedMsg.contains(m.getSender())) {
                logger.debug("Unable to send heartbeat to member: {}", m.getSender());
            }
        } else {
            logger.debug("Ignoring heartbeat request intended for {}.  My ID is {}", m.getTarget(), me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(HeartbeatMessage<ID> m) {
        if (this.isStopping) {
            return;
        }
        if (this.beingSick || this.playingDead) {
            logger.debug("sick member is ignoring check response");
            return;
        }
        this.stats.incHeartbeatsReceived();
        if (m.getRequestId() >= 0) {
            Response resp = this.requestIdVsResponse.get(m.getRequestId());
            logger.trace("Got heartbeat from member {}. {}", m.getSender(), (Object)(resp != null ? "Check thread still waiting" : "Check thread is not waiting"));
            if (resp != null) {
                Response response = resp;
                synchronized (response) {
                    resp.setResponseMsg(m);
                    resp.notify();
                }
            }
        }
        this.contactedBy(m.getSender(), System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(SuspectMembersMessage<ID> incomingRequest) {
        Object message;
        if (this.isStopping) {
            return;
        }
        if (this.beingSick || this.playingDead) {
            logger.debug("sick member is ignoring suspect message");
            return;
        }
        this.logSuspectRequests(incomingRequest, incomingRequest.getSender());
        this.stats.incSuspectsReceived();
        GMSMembershipView cv = this.currentView;
        if (cv == null) {
            return;
        }
        List<SuspectRequest<ID>> suspectRequests = incomingRequest.getMembers();
        Object sender = incomingRequest.getSender();
        int viewId = sender.getVmViewId();
        if (cv.getViewId() >= viewId && !cv.contains(incomingRequest.getSender())) {
            logger.info("Membership ignoring suspect request for " + incomingRequest + " from non-member " + incomingRequest.getSender());
            this.services.getJoinLeave().remove(sender, "this process is initiating suspect processing but is no longer a member");
            return;
        }
        Iterator<SuspectRequest<ID>> it = incomingRequest.getMembers().iterator();
        while (it.hasNext()) {
            SuspectRequest<ID> req = it.next();
            if (!req.getSuspectMember().equals(this.localAddress)) continue;
            message = new HeartbeatMessage(-1);
            ((AbstractGMSMessage)message).setRecipient(sender);
            try {
                this.services.getMessenger().send(message);
                this.stats.incHeartbeatsSent();
                it.remove();
            }
            catch (MembershipClosedException e) {
                return;
            }
        }
        logger.debug("Processing {}", incomingRequest);
        if (cv.getCoordinator().equals(this.localAddress)) {
            this.checkIfAvailable(sender, suspectRequests, cv);
        } else {
            GMSMembershipView<Object> check = new GMSMembershipView<Object>(cv, cv.getViewId() + 1);
            ArrayList<SuspectRequest<ID>> membersToCheck = new ArrayList<SuspectRequest<ID>>();
            message = this.suspectRequestsInView;
            synchronized (message) {
                this.recordSuspectRequests(suspectRequests, cv);
                Set<SuspectRequest<ID>> suspectsInView = this.suspectRequestsInView.get(cv);
                logger.debug("Current suspects are {}", suspectsInView);
                Iterator<SuspectRequest<ID>> iterator = suspectsInView.iterator();
                while (iterator.hasNext()) {
                    SuspectRequest<ID> sr = iterator.next();
                    check.remove(sr.getSuspectMember());
                    membersToCheck.add(sr);
                }
            }
            ArrayList<MemberIdentifier> membersLeaving = new ArrayList<MemberIdentifier>();
            for (MemberIdentifier member : cv.getMembers()) {
                if (!this.services.getJoinLeave().isMemberLeaving(member)) continue;
                membersLeaving.add(member);
            }
            if (!membersLeaving.isEmpty()) {
                logger.debug("Current leave requests are {}", membersLeaving);
                check.removeAll(membersLeaving);
            }
            logger.debug("Proposed view with suspects & leaving members removed is {}\nwith coordinator {}\nmy address is {}", check, check.getCoordinator(), this.localAddress);
            ID coordinator = check.getCoordinator();
            if (coordinator != null && coordinator.equals(this.localAddress)) {
                this.checkIfAvailable(sender, membersToCheck, cv);
            }
        }
    }

    void processMessage(FinalCheckPassedMessage<ID> m) {
        if (this.isStopping) {
            return;
        }
        if (!this.membersInFinalCheck.contains(m.getSuspect())) {
            this.contactedBy(m.getSuspect());
        }
    }

    private void logSuspectRequests(SuspectMembersMessage<ID> incomingRequest, ID sender) {
        for (SuspectRequest<ID> req : incomingRequest.getMembers()) {
            String who = sender.equals(this.localAddress) ? "myself" : sender.toString();
            logger.info("received suspect message from {} for {}: {}", (Object)who, req.getSuspectMember(), (Object)req.getReason());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSuspectRequests(List<SuspectRequest<ID>> suspectRequests, GMSMembershipView<ID> cv) {
        Map<GMSMembershipView<ID>, Set<SuspectRequest<ID>>> map = this.suspectRequestsInView;
        synchronized (map) {
            Set<SuspectRequest<ID>> suspectedMembers = this.suspectRequestsInView.get(cv);
            if (suspectedMembers == null) {
                suspectedMembers = new HashSet<SuspectRequest<ID>>();
                this.suspectRequestsInView.put(cv, suspectedMembers);
            }
            suspectedMembers.addAll(suspectRequests);
        }
    }

    private void checkIfAvailable(ID initiator, List<SuspectRequest<ID>> sMembers, GMSMembershipView<ID> cv) {
        for (SuspectRequest<ID> sr : sMembers) {
            ID mbr = sr.getSuspectMember();
            if (!cv.contains(mbr) || this.membersInFinalCheck.contains(mbr) || mbr.equals(this.localAddress)) continue;
            String reason = sr.getReason();
            logger.debug("Scheduling availability check for member {}; reason={}", mbr, (Object)reason);
            this.checkExecutor.execute(() -> {
                try {
                    this.inlineCheckIfAvailable(initiator, cv, true, mbr, reason);
                }
                catch (MembershipClosedException membershipClosedException) {
                }
                catch (Exception e) {
                    logger.info("Unexpected exception while verifying member", (Throwable)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean inlineCheckIfAvailable(ID initiator, GMSMembershipView<ID> cv, boolean isFinalCheck, ID mbr, String reason) {
        if (this.services.getJoinLeave().isMemberLeaving(mbr)) {
            return false;
        }
        boolean failed = false;
        logger.info("Performing availability check for suspect member {} reason={}", mbr, (Object)reason);
        this.membersInFinalCheck.add(mbr);
        this.setNextNeighbor(this.currentView, mbr);
        try {
            boolean pinged;
            this.services.memberSuspected(initiator, mbr, reason);
            long startTime = System.currentTimeMillis();
            int port = cv.getFailureDetectionPort(mbr);
            if (port <= 0) {
                logger.info("Unable to locate failure detection port - requesting a heartbeat");
                if (logger.isDebugEnabled()) {
                    logger.debug("\ncurrent view: {}\nports: {}", cv, (Object)Arrays.toString(cv.getFailureDetectionPorts()));
                }
                pinged = this.doCheckMember(mbr, true);
                this.stats.incFinalCheckRequestsSent();
                this.stats.incUdpFinalCheckRequestsSent();
                if (pinged) {
                    this.stats.incFinalCheckResponsesReceived();
                    this.stats.incUdpFinalCheckResponsesReceived();
                }
            } else {
                this.doCheckMember(mbr, false);
                boolean retryIfConnectFails = isFinalCheck;
                pinged = this.doTCPCheckMember(mbr, port, retryIfConnectFails);
            }
            if (!pinged && !this.isStopping) {
                failed = true;
                TimeStamp ts = (TimeStamp)this.memberTimeStamps.get(mbr);
                if (ts == null || ts.getTime() < startTime) {
                    logger.info("Availability check failed for member {}", mbr);
                    if (isFinalCheck) {
                        logger.info("Requesting removal of suspect member {}", mbr);
                        this.services.getJoinLeave().remove(mbr, reason);
                        this.memberSuspected(this.localAddress, mbr, reason);
                    } else if (this.doTCPCheckMember(this.localAddress, this.socketPort, false)) {
                        this.membersInFinalCheck.remove(mbr);
                        this.memberSuspected(this.localAddress, mbr, reason);
                        this.initiateSuspicion(mbr, reason);
                        SuspectMembersMessage<ID> suspectMembersMessage = new SuspectMembersMessage<ID>(Collections.singletonList(this.localAddress), Collections.singletonList(new SuspectRequest<ID>(mbr, "failed availability check")));
                        suspectMembersMessage.setSender(this.localAddress);
                        logger.debug("Performing local processing on suspect request");
                        this.processMessage(suspectMembersMessage);
                    } else {
                        logger.info("Self-check for availability failed - will not continue to suspect {} for now", mbr);
                        failed = false;
                    }
                } else {
                    logger.info("Availability check detected recent message traffic for suspect member " + mbr + " at time " + new Date(ts.getTime()));
                    failed = false;
                }
            }
            if (!failed) {
                if (!this.isStopping && initiator.getVersionOrdinal() >= Version.GEODE_1_4_0.ordinal()) {
                    FinalCheckPassedMessage message = new FinalCheckPassedMessage(initiator, mbr);
                    List<ID> members = cv.getMembers();
                    ArrayList<MemberIdentifier> recipients = new ArrayList<MemberIdentifier>(members.size());
                    for (MemberIdentifier member : members) {
                        if (this.isSuspectMember(member) || this.membersInFinalCheck.contains(member) || member.equals(this.localAddress)) continue;
                        recipients.add(member);
                    }
                    if (recipients.size() > 0) {
                        message.setRecipients(recipients);
                        this.services.getMessenger().send(message);
                    }
                }
                logger.info("Availability check passed for suspect member " + mbr);
            }
        }
        finally {
            if (!failed) {
                this.memberUnsuspected(mbr);
                this.setNextNeighbor(this.currentView, null);
            }
            this.membersInFinalCheck.remove(mbr);
        }
        return !failed;
    }

    @Override
    public void memberShutdown(ID mbr, String reason) {
    }

    @Override
    public int getFailureDetectionPort() {
        return this.socketPort;
    }

    private void sendSuspectRequest(List<SuspectRequest<ID>> requests) {
        Set<ID> failedRecipients;
        List<ID> recipients;
        logger.debug("Sending suspect request for members {}", requests);
        if (this.currentView.size() > 9) {
            HashSet<ID> filter = new HashSet<ID>();
            Enumeration<ID> e = this.suspectedMemberIds.keys();
            while (e.hasMoreElements()) {
                filter.add(e.nextElement());
            }
            filter.addAll(requests.stream().map(SuspectRequest::getSuspectMember).collect(Collectors.toList()));
            recipients = this.currentView.getPreferredCoordinators(filter, this.services.getJoinLeave().getMemberID(), 10);
        } else {
            recipients = this.currentView.getMembers();
        }
        logger.trace("Sending suspect messages to {}", recipients);
        SuspectMembersMessage<ID> smm = new SuspectMembersMessage<ID>(recipients, requests);
        smm.setSender(this.localAddress);
        try {
            failedRecipients = this.services.getMessenger().send(smm);
            this.stats.incSuspectsSent();
        }
        catch (MembershipClosedException e) {
            return;
        }
        if (failedRecipients != null && failedRecipients.size() > 0) {
            logger.trace("Unable to send suspect message to {}", failedRecipients);
        }
        logger.trace("Processing suspect message locally");
        this.processMessage(smm);
    }

    public MembershipStatistics getStats() {
        return this.stats;
    }

    class Heart
    implements Runnable {
        public static final int OVERSLEEP_WARNING_THRESHOLD_PERIODS = 2;
        public final long sleepPeriodMillis;
        public final long sleepPeriodNanos;
        public final long sleepLimitNanos;

        Heart() {
            this.sleepPeriodMillis = GMSHealthMonitor.this.memberTimeout / (long)LOGICAL_INTERVAL;
            this.sleepPeriodNanos = TimeUnit.NANOSECONDS.convert(this.sleepPeriodMillis, TimeUnit.MILLISECONDS);
            this.sleepLimitNanos = 2L * this.sleepPeriodNanos;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Geode Heartbeat Sender");
            this.sendPeriodicHeartbeats(Thread::sleep, System::nanoTime, arg_0 -> ((Logger)logger).warn(arg_0));
        }

        @VisibleForTesting
        void sendPeriodicHeartbeats(Sleeper sleeper, NanoTimer nanoTimer, Warner warner) {
            while (!GMSHealthMonitor.this.isStopping && !GMSHealthMonitor.this.services.getCancelCriterion().isCancelInProgress()) {
                List mbrs;
                int index;
                try {
                    long timeBeforeSleep = nanoTimer.nanoTime();
                    sleeper.sleep(this.sleepPeriodMillis);
                    long timeAfterSleep = nanoTimer.nanoTime();
                    long asleepNanos = timeAfterSleep - timeBeforeSleep;
                    if (asleepNanos > this.sleepLimitNanos) {
                        warner.warn(String.format("Failure detection heartbeat-generation thread overslept by more than a full period. Asleep time: %,d nanoseconds. Period: %,d nanoseconds.", asleepNanos, this.sleepPeriodNanos));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                GMSMembershipView v = GMSHealthMonitor.this.currentView;
                if (v == null || (index = (mbrs = v.getMembers()).indexOf(GMSHealthMonitor.this.localAddress)) < 0 || mbrs.size() < 2 || GMSHealthMonitor.this.playingDead) continue;
                this.sendHeartbeats(mbrs, index);
            }
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendHeartbeats(List<ID> mbrs, int startIndex) {
            Object coordinator = GMSHealthMonitor.this.currentView.getCoordinator();
            if (coordinator != null && !coordinator.equals(GMSHealthMonitor.this.localAddress)) {
                HeartbeatMessage message = new HeartbeatMessage(-1);
                message.setRecipient(coordinator);
                try {
                    if (GMSHealthMonitor.this.isStopping) {
                        return;
                    }
                    GMSHealthMonitor.this.services.getMessenger().sendUnreliably(message);
                    GMSHealthMonitor.this.stats.incHeartbeatsSent();
                }
                catch (MembershipClosedException e) {
                    return;
                }
            }
            int index = startIndex;
            int numSent = 0;
            while (true) {
                MemberIdentifier mbr;
                if (--index < 0) {
                    index = mbrs.size() - 1;
                }
                if ((mbr = (MemberIdentifier)mbrs.get(index)).equals(GMSHealthMonitor.this.localAddress)) return;
                if (mbr.equals(coordinator)) continue;
                if (GMSHealthMonitor.this.isStopping) {
                    return;
                }
                HeartbeatMessage<MemberIdentifier> message = new HeartbeatMessage<MemberIdentifier>(-1);
                message.setRecipient(mbr);
                GMSHealthMonitor.this.services.getMessenger().sendUnreliably(message);
                GMSHealthMonitor.this.stats.incHeartbeatsSent();
                if (++numSent >= NUM_HEARTBEATS) return;
                continue;
                break;
            }
            catch (MembershipClosedException e) {
                return;
            }
        }
    }

    @FunctionalInterface
    static interface Warner {
        public void warn(String var1);
    }

    @FunctionalInterface
    static interface NanoTimer {
        public long nanoTime();
    }

    @FunctionalInterface
    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }

    private static class ConnectTimeoutTask
    extends TimerTask
    implements ConnectionWatcher {
        final Timer scheduler;
        Socket socket;
        final long timeout;

        ConnectTimeoutTask(Timer scheduler, long timeout) {
            this.scheduler = scheduler;
            this.timeout = timeout;
        }

        public void beforeConnect(Socket socket) {
            this.socket = socket;
            this.scheduler.schedule((TimerTask)this, this.timeout);
        }

        public void afterConnect(Socket socket) {
            this.cancel();
        }

        @Override
        public void run() {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ClientSocketHandler
    implements Runnable {
        private final Socket socket;

        public ClientSocketHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                this.socket.setTcpNoDelay(true);
                DataInputStream in = new DataInputStream(this.socket.getInputStream());
                OutputStream out = this.socket.getOutputStream();
                short version = in.readShort();
                int vmViewId = in.readInt();
                long uuidLSBs = in.readLong();
                long uuidMSBs = in.readLong();
                GMSHealthMonitor.this.stats.incFinalCheckRequestsReceived();
                GMSHealthMonitor.this.stats.incTcpFinalCheckRequestsReceived();
                MemberIdentifier gmbr = GMSHealthMonitor.this.localAddress;
                UUID myUUID = gmbr.getUUID();
                int myVmViewId = gmbr.getVmViewId();
                if (GMSHealthMonitor.this.playingDead) {
                    logger.debug("HealthMonitor: simulating sick member in health check");
                } else if (uuidLSBs == myUUID.getLeastSignificantBits() && uuidMSBs == myUUID.getMostSignificantBits() && (vmViewId == myVmViewId || myVmViewId < 0)) {
                    logger.debug("HealthMonitor: sending OK reply");
                    out.write(123);
                    out.flush();
                    this.socket.shutdownOutput();
                    GMSHealthMonitor.this.stats.incFinalCheckResponsesSent();
                    GMSHealthMonitor.this.stats.incTcpFinalCheckResponsesSent();
                    logger.debug("HealthMonitor: server replied OK.");
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("HealthMonitor: sending ERROR reply - my UUID is {},{} received is {},{}.  My viewID is {} received is {}", (Object)Long.toHexString(myUUID.getMostSignificantBits()), (Object)Long.toHexString(myUUID.getLeastSignificantBits()), (Object)Long.toHexString(uuidMSBs), (Object)Long.toHexString(uuidLSBs), (Object)myVmViewId, (Object)vmViewId);
                    }
                    out.write(0);
                    out.flush();
                    this.socket.shutdownOutput();
                    GMSHealthMonitor.this.stats.incFinalCheckResponsesSent();
                    GMSHealthMonitor.this.stats.incTcpFinalCheckResponsesSent();
                    logger.debug("HealthMonitor: server replied ERROR.");
                }
            }
            catch (IOException in) {
            }
            catch (RuntimeException e) {
                logger.debug("Unexpected runtime exception", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                logger.debug("Unexpected error", (Throwable)e);
                throw e;
            }
            finally {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class Response {
        private AbstractGMSMessage<ID> responseMsg;

        private Response() {
        }

        public AbstractGMSMessage<ID> getResponseMsg() {
            return this.responseMsg;
        }

        public void setResponseMsg(AbstractGMSMessage<ID> responseMsg) {
            this.responseMsg = responseMsg;
        }
    }

    private class Monitor
    implements Runnable {
        private final long MONITOR_DELAY_THRESHOLD = Long.getLong("gemfire.statSamplerDelayThreshold", 3000L);
        final long memberTimeoutInMillis;

        public Monitor(long memberTimeout) {
            this.memberTimeoutInMillis = memberTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                MemberIdentifier neighbor = GMSHealthMonitor.this.nextNeighbor;
                if (logger.isDebugEnabled()) {
                    logger.debug("cluster health monitor invoked with {}", (Object)neighbor);
                }
                try {
                    TimeStamp nextNeighborTS;
                    long currentTime;
                    if (GMSHealthMonitor.this.isStopping) {
                        return;
                    }
                    long oldTimeStamp = GMSHealthMonitor.this.currentTimeStamp = (currentTime = System.currentTimeMillis());
                    GMSHealthMonitor.this.currentTimeStamp = System.currentTimeMillis();
                    GMSMembershipView myView = GMSHealthMonitor.this.currentView;
                    if (myView == null) {
                        return;
                    }
                    if (GMSHealthMonitor.this.currentTimeStamp - oldTimeStamp > GMSHealthMonitor.this.monitorInterval + this.MONITOR_DELAY_THRESHOLD) {
                        logger.info("Failure detector has noticed a JVM pause and is giving all members a heartbeat in view {}", (Object)GMSHealthMonitor.this.currentView);
                        for (MemberIdentifier member : myView.getMembers()) {
                            GMSHealthMonitor.this.contactedBy(member);
                        }
                        return;
                    }
                    if (neighbor == null) break block18;
                    GMSHealthMonitor member = GMSHealthMonitor.this;
                    synchronized (member) {
                        nextNeighborTS = (TimeStamp)GMSHealthMonitor.this.memberTimeStamps.get(neighbor);
                    }
                    if (nextNeighborTS == null) {
                        logger.debug("timestamp for {} was found null - setting current time as timestamp", (Object)neighbor);
                        TimeStamp customTS = new TimeStamp(currentTime);
                        GMSHealthMonitor.this.memberTimeStamps.put(neighbor, customTS);
                        return;
                    }
                    long interval = this.memberTimeoutInMillis / (long)LOGICAL_INTERVAL;
                    long lastTS = currentTime - nextNeighborTS.getTime();
                    if (lastTS + interval >= this.memberTimeoutInMillis) {
                        logger.debug("Checking member {} ", (Object)neighbor);
                        GMSHealthMonitor.this.checkMember(neighbor);
                    }
                }
                finally {
                    if (logger.isDebugEnabled()) {
                        logger.debug("cluster health monitor pausing");
                    }
                }
            }
        }
    }

    static class TimeStamp {
        private volatile long timeStamp;

        TimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getTime() {
            return this.timeStamp;
        }

        public void setTime(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

