/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.geode.distributed.internal.membership.api.MemberData;
import org.apache.geode.distributed.internal.membership.gms.MemberDataBuilderImpl;

public interface MemberDataBuilder {
    public static MemberDataBuilder newBuilder(InetAddress hostAddress, String hostName) {
        return MemberDataBuilderImpl.newBuilder(hostAddress, hostName);
    }

    public static MemberDataBuilder newBuilderForLocalHost(String hostName) {
        return MemberDataBuilderImpl.newBuilderForLocalHost(hostName);
    }

    public static String[] parseGroups(String csvRoles, String csvGroups) {
        ArrayList<String> groups = new ArrayList<String>();
        MemberDataBuilder.parseCsv(groups, csvRoles);
        MemberDataBuilder.parseCsv(groups, csvGroups);
        return groups.toArray(new String[groups.size()]);
    }

    public static void parseCsv(List<String> groups, String csv) {
        if (csv == null || csv.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            String groupName = st.nextToken().trim();
            if (groups.contains(groupName)) continue;
            groups.add(groupName);
        }
    }

    public MemberDataBuilder setMembershipPort(int var1);

    public MemberDataBuilder setDirectChannelPort(int var1);

    public MemberDataBuilder setVmPid(int var1);

    public MemberDataBuilder setVmKind(int var1);

    public MemberDataBuilder setVmViewId(int var1);

    public MemberDataBuilder setName(String var1);

    public MemberDataBuilder setGroups(String[] var1);

    public MemberDataBuilder setDurableId(String var1);

    public MemberDataBuilder setDurableTimeout(int var1);

    public MemberDataBuilder setPreferredForCoordinator(boolean var1);

    public MemberDataBuilder setNetworkPartitionDetectionEnabled(boolean var1);

    public MemberDataBuilder setVersionOrdinal(short var1);

    public MemberDataBuilder setUuidMostSignificantBits(long var1);

    public MemberDataBuilder setUuidLeastSignificantBits(long var1);

    public MemberDataBuilder setIsPartial(boolean var1);

    public MemberDataBuilder setUniqueTag(String var1);

    public MemberData build();
}

