/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.cluster.client.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.ClusterManagementServiceTransport;
import org.apache.geode.management.api.CommandType;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;

public class ClientClusterManagementService
implements ClusterManagementService {
    private final ClusterManagementServiceTransport transport;

    public ClientClusterManagementService(ClusterManagementServiceTransport transport) {
        this.transport = transport;
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config) {
        ClusterManagementRealizationResult result = this.transport.submitMessage(config, config.getCreationCommandType());
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config) {
        ClusterManagementRealizationResult result = this.transport.submitMessage(config, CommandType.DELETE);
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult update(T config) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> list(T config) {
        ClusterManagementListResult result = this.transport.submitMessageForList(config);
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> get(T config) {
        ClusterManagementGetResult result = this.transport.submitMessageForGet(config);
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> start(A op) {
        ClusterManagementOperationResult result = this.transport.submitMessageForStart(op);
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> get(A opType, String opId) {
        ClusterManagementOperationResult result = this.transport.submitMessageForGetOperation(opType, opId);
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> CompletableFuture<ClusterManagementOperationResult<A, V>> getFuture(A opType, String opId) {
        AtomicReference<CompletableFuture<ClusterManagementOperationResult>> futureAtomicReference = new AtomicReference<CompletableFuture<ClusterManagementOperationResult>>();
        futureAtomicReference.set(CompletableFuture.supplyAsync(() -> {
            while (futureAtomicReference.get() == null || !((CompletableFuture)futureAtomicReference.get()).isCancelled()) {
                ClusterManagementOperationResult result = this.get(opType, opId);
                if (result.getOperationEnd() != null) {
                    return result;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new ClusterManagementException(result, (Throwable)e);
                }
            }
            return null;
        }));
        return (CompletableFuture)futureAtomicReference.get();
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<A, V> list(A opType) {
        ClusterManagementListOperationsResult result = this.transport.submitMessageForListOperation(opType);
        this.assertSuccessful(result);
        return result;
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public void close() {
        this.transport.close();
    }

    private void assertSuccessful(ClusterManagementResult result) {
        if (result == null) {
            ClusterManagementResult somethingVeryBadHappened = new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, "Unable to parse server response.");
            throw new ClusterManagementException(somethingVeryBadHappened);
        }
        if (!result.isSuccessful()) {
            throw new ClusterManagementException(result);
        }
    }
}

